/**
 * The top-level singleton sfw service object
 * @object {object} nokia.services 
 */
if (typeof(nokia) != "undefined") {
    if ((typeof(nokia.services) != "undefined") && (nokia.services != null)) {
        nokia.services.load = _sfw_service_load;
        nokia.services.listServices = _sfw_service_list;
        nokia.services.init = _sfw_service_init;
        nokia.services.version = "0.1";
        nokia.services.info = "Service Framework";
        nokia.services.factory = null;
    }
    else {
        nokia.services = {
            load: _sfw_service_load,
            listServices: _sfw_service_list,
            init:_sfw_service_init,
            version: "0.1",
            info: "Service Framework",
            factory: null
        };
    }
} else {
    nokia = {
        services : {
            load: _sfw_service_load,
            listServices: _sfw_service_list,
            init:_sfw_service_init,
            version: "0.1",
            info: "Service Framework",
            factory: null
        }
    };
}

/**
 * Creates a factory object and embeds it to html file
 * 
 * @function {public object} createFactoryObject
 * @returns factory plugin 
 */
function createFactoryObject() {
    var factory = document.getElementById("serviceFactory");
    //plugin is not embeded yet
    if (!factory) { 
        //embed plugin in a div node to html file
        var newdiv = document.createElement('div');
        newdiv.id = "factoryDiv";
        newdiv.innerHTML = '<embed  id="serviceFactory" type="application/x-sfw-plugin" height="0" hidden=true > </embed>';
        document.body.insertBefore(newdiv, document.body.firstChild);   
        // Setup the nokia.factory
        nokia.factory = document.getElementById("serviceFactory");
        // Call this again to execute else case
        setTimeout(createFactoryObject, 1 );
    } else {
        
        function _newObject(){
           return new Object();
        };
        
        function _newArray(){
           return new Array();
        };
        
        function _newDate(){
           return new Date();
        };

        // If the client already has the plugin embedded
        nokia.factory=factory;
        nokia.factory.SFW_CreateJSObject(_newObject,_newArray,_newDate);
    }
}


/**
 * Implemention of nokia.services.load method 
 * 
 * @function {public object} _sfw_service_load
 * @param {string} serviceName service name of requested service
 * @param {string} interfaceName interface name of requested service
 * @param {string} version version of requested service
 * @returns service object
 */
function _sfw_service_load(serviceName, interfaceName, version){

    //factory's getLastErrCode api is called to check SFW plugin has been loaded correctly
    try {
        nokia.factory.getLastErrCode();
    } catch(ex) {
        throw new Error("Error loading Service framework NP plugin!");
    }

    try {
        var so = nokia.factory.getServiceObject(serviceName, interfaceName, version);
        if (nokia.factory.getLastErrCode()!=0){
            throw e;
        }
        return so;
    } catch (e) {
       throw new Error(nokia.factory.getLastErrDescription());
    }
}

/**
 * Implemention of the nokia.services.listServices method
 * 
 * @function {public array} _sfw_service_list
 * @returns list of registered services
 */
function _sfw_service_list()
{
    //factory's getLastErrCode api is called to check SFW plugin has been loaded correctly
    try {
        nokia.factory.getLastErrCode();
    } catch(ex) {
        throw new Error("Error loading Service framework NP plugin!");
    }

    try {
        var l = nokia.factory.getServiceProviders(); 
        if (nokia.factory.getLastErrCode()!=0){
            throw e;
        }
        return l;  
    } catch (e){
        throw new Error(nokia.factory.getLastErrDescription());
    }
}

/**
 * Implementation of the nokia.services.init method
 * @function _sfw_service_init
 * @param (function) callback function to callback to
 */
function _sfw_service_init(callback) {
    try {
        createFactoryObject();
        // Automatically callback to client after 1 MS
        setTimeout(callback, 1 );
    } catch(ex) {
        throw new Error(ex.message);
    }
}

/**
 * @var {bool} sfw_debug_on is ture if in debug mode
 */
var sfw_debug_on = true;

/**
 * @function {public void} sfw_debug if sfw_debug_on = true alert the input message
 * @param {string} message 
 */
function sfw_debug(message)
{
    if (sfw_debug_on) {
        alert(message);
    }
}
