/**
 * @author ajana
 */
/**
 * @class
 */
nokia.device.Telephony = function PSTelephonyInterface(){

    var DeviceException = nokia.device.DeviceException;
    
    var error = new DeviceException(0, 'dummy');
    
    /*
     * Internal
     * qt telephony interface object.
     */
    var qtTelephonyIf = nokia._services.load("nokia.device.telephony", "com.nokia.ITelephony", "1.0");

    return {
        /**
        * @constant {String} 
        * interfaceName.
        */      
        interfaceName: "telephony",
        /**
        * @constant {Number} 
        * version.
        */      
        version: nokia.device._interfaces['telephony'],

        /**
         * Makes a voice call the the given number
         * This is a synchronous API.
         *
         * @param {String}
         *          phoneNumber The phone number to which a voice call will be made.
         * @exception {DeviceException} Code 1 (INVALID_ARG_ERR): Invalid Phone number.
         * 								Code 2 (MISSING_ARG_ERR): If phoneNumber is missing.
         */
        initiateVoiceCall: function(phoneNumber){
        
            //input validations.
            if (!phoneNumber) {
                throw new DeviceException(error.MISSING_ARG_ERR, 'mandatory parameter phoneNumber is missing');
            }
            else 
                if ((typeof phoneNumber) != "string") {
                    throw new DeviceException(error.INVALID_ARG_ERR, 'phoneNumber param must be a string');
                }
            
            var ret = qtTelephonyIf.initiateVoiceCall(phoneNumber);
            if (ret["errorCode"] == -2 ||ret["errorCode"] == -6) {
                throw new DeviceException(error.INVALID_ARG_ERR, ret["errorMessage"]);
            }
        }
        
    }
    
};
