
/**
 * @class
 */
nokia.device.Contacts = function PSContactsInterface(){

    var DeviceException = nokia.device.DeviceException;
    var DeviceAPIError = nokia.device.DeviceAPIError;
    var error = new DeviceException(0,'dummy');
    var errorAPI = new DeviceAPIError(0,'dummy');
	var notificationId = -1;
	var usec_count=0;
	
	var __s60_start_and_wait_cb;
	
	function __s60_on_app_exit(){
					  window.widget.onshow = null;
					  if(__s60_start_and_wait_cb){
					    __s60_start_and_wait_cb();
					  }
					}
					
	function __s60_on_app_start(){
		  window.widget.onhide = null;
		  window.widget.onshow = __s60_on_app_exit;
		}
		
	function __s60_start_and_wait(args, app_exit_cb){
		  __s60_start_and_wait_cb = app_exit_cb;
		  window.widget.onhide = __s60_on_app_start;
		}

	
	
	var contactsAsyncCallbackMap = function(){
		//this.usec_count			=0,
		this.maptype			="getContacts",	//Used for Contacts
		this.callbackArray		=new Array(),
		this.getTransactionId	=function(){
		usec_count++;
		return usec_count;
	},
	this.add=function(sCb, errCb,options){
			var obj = new Object();
	        obj.success_cb = sCb;
			obj.error_cb = errCb;
			obj.options = options;
	        obj.transactionId = this.getTransactionId();        
	        this.callbackArray.push(obj);
			return obj.transactionId;
	},
	this.get=function(tid,mtype){
			var i = this.callbackArray.length -1;
	        if(!mtype){
				for (; i >= 0; i--) {
	            	if (this.callbackArray[i].transactionId == tid) {
		            	return this.callbackArray[i];
	            	}
	        	}
	    	}else{
		    	for (; i >= 0; i--) {	//Used for Contacts
	            	if (this.callbackArray[i].transactionId == tid) {
		            	if(this.maptype==mtype)
	                		return this.callbackArray[i];
	            	}
	        	}
	    	}
	    	return null;
	},
	this.remove=function(tid){
			var i = this.callbackArray.length -1;
	        for (; i >= 0; i--) {
	            if (this.callbackArray[i].transactionId == tid) {
	                this.callbackArray.splice(i, 1);
	            }
	        }
		}
	
	};
	
	var getcontactscbmap		=	new contactsAsyncCallbackMap;
	getcontactscbmap.maptype 	= 	"getContacts";
	var getgroupscbmap			=	new contactsAsyncCallbackMap;
	getgroupscbmap.maptype		= 	"getGroups";
	var getIdscbmap				=	new contactsAsyncCallbackMap;
	getIdscbmap.maptype			=	"getIds";

	
    function __contact_cb(error,trans,iter)
		{	
			try{
					var retObj = getcontactscbmap.get(trans,"getContacts");	        
	        		if(retObj){
			        	getcontactscbmap.remove(trans);
		        		var callback = retObj.success_cb;
		        		var errorCallback = retObj.error_cb;
		        		
		        		if (error) {
			        		if(errorCallback){
			        			var exception = new DeviceAPIError(error,"getContacts:Failed");
			            		errorCallback(exception);	            			
	            			}
		        		}
		        		else
		        			callback(iter);
        			}
    			}
    			catch(er){
	    			alert(er);
    			}
		}
		
		
		function __get_group_cb(error,trans,iter)
				{	
					try{
						var retObj = getgroupscbmap.get(trans,"getGroups");
				
						getgroupscbmap.remove(trans);
		        
		        		if (retObj) {
			        		var callback = retObj.success_cb;
			        		var errorCallback = retObj.error_cb;
			        		
			        		if (error) {
				        		if(errorCallback){
				        			var exception = new DeviceAPIError(error,"getGroups:Failed");
				            		errorCallback(exception);	            			
		            			}
			        		}
			        		else
			        			callback(iter);
		        		}
	    			}
	    			catch(er){
		    			alert(er);
	    			}
				}
		
    function __ids_cb(error,trans,iter)
		{	
			try{
					var retObj = getIdscbmap.get(trans,"getIds");	        
	        		if(retObj){
			        	getIdscbmap.remove(trans);
		        		var callback = retObj.success_cb;
		        		var errorCallback = retObj.error_cb;
		        		
		        		if (error) {
			        		if(errorCallback){
			        			var exception = new DeviceAPIError(error,"getContactIds:Failed");
			            		errorCallback(exception);	            			
	            			}
		        		}
		        		else
		        			callback(iter);
        			}
    			}
    			catch(er){
	    			alert(er);
    			}
		}


     
    try {
       	var qtContactsIf = nokia._services.load("nokia.device.contacts", "com.nokia.IContacts", "1.0");
       	qtContactsIf.addEventListener("asyncCallbackC(int,int,QObject*)",__contact_cb);	
       	qtContactsIf.addEventListener("asyncCallbackG(int,int,QObject*)",__get_group_cb);
       	qtContactsIf.addEventListener("asyncCallback(int,int,QVariant)",__ids_cb);		
    }catch(e){
        throw DeviceException(error.DATA_NOT_FOUND_ERR,'failed to load requested service interface');
    }

    return     {	    
	    /**
	    * @constant {String} 
	    * interfaceName.
	    */      
	    interfaceName: "contacts",
	    /**
	    * @constant {Number} 
	    * version.
	    */      
	    version: nokia.device._interfaces['contacts'],
		/**
		* @constant {Number} 
		* sorts contacts in ascending order.
		*/
		SORT_ASCENDING	: 0,
		/**
		 * @constant {Number} 
		 * sorts contacts in descending order.
		*/
		SORT_DESCENDING	: 1,	   
		
		/*
		 * Constants used to identify the event in the notification callback
		 */
		EVENT_CONTACT_ADDED : 0,
		EVENT_CONTACT_UPDATED : 1,
	 	EVENT_CONTACT_DELETED : 2,
		EVENT_GROUP_ADDED : 3,
		EVENT_GROUP_UPDATED : 4,
		EVENT_GROUP_DELETED : 5, 
	    
        /**
         * Get an iterator to a list of contacts. This is an asynchronous function.
         * Returns a transaction id.
         * @param {function} successCallback A function with the signature function((Iterator} of ContactData).
         * @param {string} [match] Specifies a matching filter for the contacts to return.
         *                  All the contacts whose fields name.last or name.first start with the string <i>match</i> in
         *                  will be listed.
         * @param {string} [sortOrder] Specifies the sort order, 0 indicates ascending, and 1 indicates descending.
         *                  The contacts are sorted by name.last, and name.first. 
         * @param {function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i> - one of the errors:
         * <ul>
         * <li>
         * DATA_OUT_OF_RANGE_ERR: sortingOrder is not one of SORT_ASCENDING or SORT_DESCENDING.
         * </li>
         * <li>
         * DATA_NOT_FOUND_ERR: if no contacts match the parameters.
         * </li>
         * </ul>
         * @return {number} Returns a transaction id.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): successCallback is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): <ul><li>successCallback is not a function</li>
         *                                                        <li>errorCallback is not a function</li>
         *                                                        <li>match is not a string</li>  
         *                                                        <li>sortOrder is not a number</li>
         *                                                        </ul>
         */
        getContacts : function(__succes_cb, __match, __sort_order, __error_cb) { 	        
	        
				
				if(!__succes_cb)
					throw new DeviceException(error.MISSING_ARG_ERR, 'getContacts:Missing Success Callback');
				
				if(__succes_cb==null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'getContacts:Missing Success Callback');
		
				if(__succes_cb==undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'getContacts:Missing Success Callback');
		
				if(typeof(__succes_cb)=="undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'getContacts:Missing Success Callback');
		
					
				if((typeof __succes_cb) != "function" )
					throw new DeviceException(error.INVALID_ARG_ERR, 'getContacts:Invalid Success Callback');
				
				if((typeof __match) == "undefined")	
					__match = "";
					
				if((__match) == null)
					__match = "";
					
				if((typeof __match) != "string")
					throw new DeviceException(error.INVALID_ARG_ERR, 'getContacts:Invalid Filter Criteria');	
					
				if((typeof __sort_order) == "undefined")
					__sort_order = this.SORT_ASCENDING;	
				
				if((__sort_order) == null)
					__sort_order = this.SORT_ASCENDING;
					
				if((__sort_order) == undefined)
					__sort_order = this.SORT_ASCENDING;
					
				if((typeof  __sort_order) != "number")
					throw new DeviceException(error.INVALID_ARG_ERR, 'Invalid Success Callback');
		
				if((__error_cb)||(__error_cb!=null))
					if((typeof __error_cb) != "function" )
						throw new DeviceException(error.INVALID_ARG_ERR, 'getContacts:Invalid Error Callback');
			
				function _contact_error_cb(error){
		          	if (__error_cb) {
		            	var exception = new DeviceAPIError(error,"getContacts:Failed");
		            	__error_cb(exception);
					}
				}
				
			try{		
					var tidgl = getcontactscbmap.add(__succes_cb, __error_cb);
			    		
			    	ret=qtContactsIf.getContactsAsync( __match,__sort_order,tidgl );
			    				    	
			    	if (ret.ErrorCode != 0){				    	
				    	
				    	getcontactscbmap.remove(tidgl);
			    		
				    	if((ret.ErrorCode == error.INVALID_ARG_ERR)||(ret.ErrorCode == error.MISSING_ARG_ERR))		//throw only for these errors
			    		 	throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);
			    		else
			    		{
			    			setTimeout(_contact_error_cb(ret.ErrorCode),10);	//All other errors returned asynchronously.why? ..."Thats what the spec says"
		    			}
		    		 }	
				}
				catch(er){
					throw(er);
					}
					
					return tidgl;				
        },

        /**
         * Get an iterator to the list of groups. This is an
         * asynchronous function. Returns a transaction id.
         * @param {function} successCallback  A function with the signature function({@link Iterator} of {@link GroupInfo}).
         * @param {function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i> - one of the errors:
         * <ul>
         * <li>
         * DATA_NOT_FOUND_ERR: no contacts are found.
         * </li>
         * </ul>
         * @return {number} Returns a transaction id, that will be passed to the callback function too.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): successCallback is undefined.<br>
         *                              Code 2 (INVALID_ARG_ERR): <ul><li>successCallback is not a function</li>
         *                                                        <li>errorCallback is not a function</li>
         *                                                        </ul>
         */
        getGroups : function(__success_cb, __error_cb) {
	        
		        if(!__success_cb)
				throw new DeviceException(error.MISSING_ARG_ERR, 'getGroups:Missing Success Callback');	
			
				if(__success_cb==null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'getGroups:Missing Success Callback');	
					
				if(__success_cb==undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'getGroups:Missing Success Callback');	
					
				if(typeof(__success_cb)=="undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'getGroups:Missing Success Callback');		
				
				if((typeof __success_cb) != "function" )
					throw new DeviceException(error.INVALID_ARG_ERR, 'getGroups:Invalid Success Callback');
					
				if((__error_cb)||(__error_cb!=null))
					if((typeof __error_cb) != "function" )
						throw new DeviceException(error.INVALID_ARG_ERR, 'getGroups:Invalid Error Callback');
		
					
				try{		
				
				var tidg2 = getgroupscbmap.add(__success_cb, __error_cb);
				ret=qtContactsIf.getGroupsAsync( tidg2 );
					
				if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);
		
				}
				catch(er){
					throw(er);
				}
				
				return tidg2;			  
        
        },              
        /**
         * Adds a new contact to the default database. This is a synchronous function.
         * @param {ContactData} contact The new contact to be added. The id property is not
         *        needed, it will
         *        be ignored, addContact will generate an id.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): contact is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): contact does not fit {@link ContactData} data scheme.<br>
         *                           Code 104 (SERVICE_IN_USE_ERR): If some other client is modifying the database simultaneously. 
         * @return {string} The id of the added contact.
         */
        addContact: function(__acontact){
	            
	        	if((__acontact) == null)
				throw new DeviceException(error.MISSING_ARG_ERR, 'addContact:Contact Data Needed');
				
				if((typeof __acontact) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'addContact:Contact Data Needed');
					
				if((__acontact) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'addContact:Contact Data Needed');
				
				if((typeof __acontact) != "object")
					throw new DeviceException(error.INVALID_ARG_ERR, 'addContact:Invalid Contact Data');
				
				var connectId	= 1;
				var ret 		= -1;
				try{	   		
				    	ret=qtContactsIf.addContact(  __acontact,connectId );
				    	
				    	if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);	
					}
				catch(er){
					throw(er);
					}
					
				return ret.ReturnValue;		
        },
        
        /**
         * Adds a new group to the default database. This is a synchronous function.
         * @param {string} groupName Specifies the name of the group to be added.
         * @return {string} The id of the added group.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): groupName is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): groupName is not a string.<br>
         *                           Code 104 (SERVICE_IN_USE_ERR): If some other client is modifying the database simultaneously. 
         */
        addGroup: function(__agroupName){
	        
		        if((__agroupName) == null)
				throw new DeviceException(error.MISSING_ARG_ERR, 'addGroup:Group Data Needed');
					
				if((typeof __agroupName) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'addGroup:Group Data Needed');
					
				if((__agroupName) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'addGroup:Group Data Needed');
					
				if((typeof __agroupName) != "string")
						throw new DeviceException(error.INVALID_ARG_ERR, 'addGroup:Invalid Group Data')
				
				var ret 		= -1;
				try{	   		
				    	ret=qtContactsIf.addGroup(  __agroupName );
				    	
			    		if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);	 	
				
					}
				catch(er){
					throw(er);
					}
				
				return ret.ReturnValue;	
        },

        /**
         * Modifies an existing contact. This is a synchronous function.
         * The ContactData parameter object must contain valid a id (i.e., an id of a contact that
         * exists in the database). <b>Note:</b> if the id is not valid, then a new contact will be added.
         * @param {ContactData} contact This contains the details need to modify an existing contact.
         *         The <i>id</i> field in the ContactData object is mandatory. 
         *         If unexisting "id" is provided as input a new contact will be added to the database.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): contact is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): contact object missed an id field see {@link ContactData}.<br>
         *                           Code 104 (SERVICE_IN_USE_ERR): If some other client is modifying the database simultaneously. 
         * @return {void}
         */
        updateContact: function(__acontact){
	        
		        if((__acontact) == null)
				throw new DeviceException(error.MISSING_ARG_ERR, 'updateContact:Contact Data Needed');
					
				if((typeof __acontact) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'updateContact:Contact Data Needed');
					
				if((__acontact) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'updateContact:Contact Data Needed');
				
				if((typeof __acontact) != "object")
					throw new DeviceException(error.INVALID_ARG_ERR, 'updateContact:Invalid Contact Data');
					
				if(typeof __acontact.id != "string")
					throw new DeviceException(error.INVALID_ARG_ERR, 'updateContact:Invalid Contact Id');
				
					var connectId	= 1;
					var ret 		= -1;
					
				try{	   		
			    		ret=qtContactsIf.updateContact(  __acontact,connectId );
			    		
			    		if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);	 	
					}
				catch(er){
							throw(er);
					}
				
				return ret.ReturnValue;			
        
        },
        /**
         * Modifies an existing group. This is a synchronous function.
         * The GroupData parameter object must contain a valid id (i.e., an id of a group that
         * exists in the database).
         * @param {GroupData} group A GroupData instance, whose property values will
         *         replace the stored values of the group with the same id.
         *         The <i>id</i> field in the GroupData object is mandatory.
         *         If unexisting "id" is provided as input a new group will be added to the database.
         * @return {void}
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): group is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): group object missed an id field see {@link GroupData}.<br>
         *                           Code 104 (SERVICE_IN_USE_ERR): If some other client is modifying the database simultaneously. 
         */
        updateGroup: function(__agroup){
            
        		if((__agroup) == null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'updateGroup:Group Data Needed');
					
				if((typeof __agroup) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'updateGroup:Group Data  Needed');
					
				if((__agroup) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'updateGroup:Group Data  Needed');
					
				if((typeof __agroup) != "object")
					throw new DeviceException(error.INVALID_ARG_ERR, 'updateGroup:Invalid Group Data');
				
				if((__agroup.groupId) == null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'updateGroup:Group ID Needed');
					
				if((typeof __agroup.groupId) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'updateGroup:Group ID  Needed');
					
				if((__agroup.groupId) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'updateGroup:Group ID  Needed');
				
				if(typeof __agroup.groupId != "string" )
					throw new DeviceException(error.INVALID_ARG_ERR, 'updateGroup:Invalid Group Id');
					
				if (__agroup.groupName) {
					if (typeof __agroup.groupName != "string") 
						throw new DeviceAPIError(error.INVALID_ARG_ERR, 'updateGroup:Invalid Group Name');
				}
				
				
				var ret 		= -1;
				try{
					
			    	ret=qtContactsIf.updateGroup(  __agroup );
		
			    	if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);	
				}
				catch(er){
					throw(er);
					}
				
				return ret.ReturnValue;    
        },
        /**
         * Deletes one or more existing contacts from the contacts database.
         * This is a synchronous function. If any of the contact ids passed is/are
         * parmeter are invalid, then no contact will be deleted.
         * @param {string[]} id The id of the contact or the ids of the contacts that are deleted.
         *                      May be a string or an array of strings.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): id is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): id is not a string or array of strings.<br>
         *                           Code 101 (DATA_NOT_FOUND_ERR) if contact id specified is not found.<br>
         *                           Code 104 (SERVICE_IN_USE_ERR): If some other client is modifying the database simultaneously.
         * @return {void}
         */
        deleteContacts: function(__Ids){
	        	if((__Ids) == null)
				throw new DeviceException(error.MISSING_ARG_ERR, 'deleteContact:Contact Data Needed');
					
				if((typeof __Ids) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'deleteContact:Contact Data Needed');
					
				if((__Ids) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'deleteContact:Contact Data Needed');
				
					
				if((typeof __Ids) != "object")
				{
					if((typeof __Ids) == "string")
					{
						var idArray = new Array();
						idArray.push(__Ids);
						
						__Ids=idArray;		
					}
					else
					{
						throw new DeviceException(error.INVALID_ARG_ERR, 'deleteContact:Invalid Contact Data');
					}
				}				
			
					var connectId	= 1;
					var ret 		= -1;
					
				try{	   		
			    		ret=qtContactsIf.deleteContacts(__Ids );
			    		
			    		if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);	 	
			
					}
				catch(er){
							throw(er);
					}
				
				return ret.ReturnValue;		        
        },

        /**
         * Deletes one or more existing groups from the contacts database.
         * This is a synchronous function.
         * @alias ContactService.deleteGroups
         * @param {string[]} id The id of the group or ids of the groups that are deleted.
         *                      May be a string or an array of strings.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): id is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): id is not a string or array of strings.<br>
         *                           Code 101 (DATA_NOT_FOUND_ERR) if group id specified is not found.<br>
         *                           Code 104 (SERVICE_IN_USE_ERR): If some other client is modifying the database simultaneously.
         * @return {void}
         */
        deleteGroups: function(__groupIds){
	        
		        if((__groupIds) == null)
				throw new DeviceException(error.MISSING_ARG_ERR, 'deleteGroups:Group ID(s) Needed');
					
				if((typeof __groupIds) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'deleteGroups:Group ID(s) Needed');
					
				if((__groupIds) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'deleteGroups:Group ID(s) Needed');
					
				if((typeof __groupIds) != "object")
				{
					if((typeof __groupIds) == "string")
					{
						var idArray = new Array();
						idArray.push(__groupIds);
						
						__groupIds=idArray;		
					}
					else
					{
						throw new DeviceException(error.INVALID_ARG_ERR, 'deleteGroups:Invalid Group Data');
					}
				}
								
				var ret 		= -1;
				try{	   		
			    	ret=qtContactsIf.deleteGroups(  __groupIds );
			    	
			    	if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);	
			
				}
				catch(er){
					throw(er);
					}
				
				return ret.ReturnValue;	
        },
        
        /**
         * Retrieves data of a single contact. This is a
         * synchronous function.
         * @param {string} id The id of the contact whose data has to be retrieved.
         * @return {ContactData} The data of the contact, whose id matches the parameter <i>id</i>.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): id is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): id is not a string.<br>
         *                           Code 101 (DATA_NOT_FOUND_ERR) if contact id specified is not found.<br>
         */
        getContactInfo: function(__Id){

		        if((__Id) == null)
				throw new DeviceException(error.MISSING_ARG_ERR, 'getContactInfo:Contact Data Needed');
					
				if((typeof __Id) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'getContactInfo:Contact Data Needed');
					
				if((__Id) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'getContactInfo:Contact Data Needed');
					
				if((typeof __Id) != "string")
						throw new DeviceException(error.INVALID_ARG_ERR, 'getContactInfo:Invalid Contact ID');
						
					var connectId	= 1;
					var ret 		= -1;
					
				try{	   		
			    		ret=qtContactsIf.getContactInfo(__Id );
			    		
			    		if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);	 	
					}
				catch(er){
							throw(er);
					}
				
				return ret.ReturnValue;		        
        },
        
        /**
         * This function is used to retrieve details of a single group. This is an
         * synchronous function.
         * @param {string} id The id of the group that has to be retrieved.
         * @return {GroupInfo} The data of the group, whose id matches the parameter <i>id</i>.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): id is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): id is not a string.<br>
         *                           Code 101 (DATA_NOT_FOUND_ERR) if group id specified is not found.<br>
         */
        getGroupInfo: function(__group_id){
	        
			     if((__group_id) == null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'getGroupInfo:Group ID Needed');
					
				if((typeof __group_id) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'getGroupInfo:Group ID Needed');
					
				if((__group_id) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'getGroupInfo:Group ID Needed');
				
				if((typeof __group_id) != "string")
						throw new DeviceException(error.INVALID_ARG_ERR, 'getGroupInfo:Invalid Group Id');
				
				var ret = -1;
				try{	   		
			    	ret = qtContactsIf.getGroupInfo( __group_id );
					//DEBUG(ret);
			    	
				if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);
				}
				catch(er){
					throw(er);
					}
				return ret.ReturnValue;
	        },
        
        /**
         * Get a list of contacts' id's. This is an
         * synchronous/asynchronous function. Returns a transaction id.
         * @param {function} successCallback A function with the signature function(string[]).
         *                  Upon the successful execution of operation , contactId(s) will be sent
         *                  to this function	
         * @param {string} [match] Specifies a matching filter for the contacts to return.
         *                  All the contacts whose fields name.last or name.first start with the string <i>match</i> in
         *                  will be listed.
         * @param {string} [sortOrder] Specifies the sort order, 0 indicates ascending, and 1 indicates descending.
         *                  The contacts are sorted by name.last, and name.first.  <b>Note:</b> sorting is not currently supported,
         *                  the list of contacts will not be sorted regardless of the value of this parameter.
         * @param {function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i> - one of the errors:
         * <ul>
         * <li>
         * DATA_OUT_OF_RANGE_ERR: sortingOrder is not one of SORT_ASCENDING or SORT_DESCENDING.
         * </li>
         * <li>
         * DATA_NOT_FOUND_ERR: if no contacts match the parameters.
         * </li>
         * </ul>
         * @return {number} Returns a transaction id.
         * @throws {DeviceException} Code 2 (INVALID_ARG_ERR): <ul><li>successCallback is not a function</li>
         *                                                        <li>errorCallback is not a function</li>
         *                                                        <li>match is not a string</li>  
         *                                                        <li>sortOrder is not a number</li>
         *                                                        </ul>
         */
        getContactIds: function(__succes_cb, __match, __sort_order, __error_cb){
	        
			    var connectId = -1;
			
				if((__succes_cb)||(__succes_cb!=null))
					if((typeof __succes_cb) != "function" )
						throw new DeviceException(error.INVALID_ARG_ERR, 'getContactIds:Invalid succes Callback');
				
				if((typeof __match) == "undefined")	
					__match = "";
					
				if((__match) == null)
					__match = "";
					
				if((typeof __match) != "string")
					throw new DeviceException(error.INVALID_ARG_ERR, 'getContactIds:Invalid Filter Criteria');	
					
				if((typeof __sort_order) == "undefined")
					__sort_order = this.SORT_ASCENDING;	
				
				if((__sort_order) == null)
					__sort_order = this.SORT_ASCENDING;
					
				if((__sort_order) == undefined)
					__sort_order = this.SORT_ASCENDING;
					
				if((typeof  __sort_order) != "number")
					throw new DeviceException(error.INVALID_ARG_ERR, 'getContactIds:Invalid Success Callback');
		
				if((__error_cb)||(__error_cb!=null))
					if((typeof __error_cb) != "function" )
						throw new DeviceException(error.INVALID_ARG_ERR, 'getContactIds:Invalid Error Callback');
					
				function _contact_error_cb(error){
		          	if (__error_cb) {
		            	var exception = new DeviceAPIError(error,"getContactIds:Failed");
		            	__error_cb(exception);
					}
				}
				
				if(__succes_cb){	//Async Processing
					try{		
					    	var transID1 = getIdscbmap.add(__succes_cb, __error_cb);
								
					    	ret=qtContactsIf.getContactIdsAsync( __match,__sort_order,transID1 );
					    	
					    	if (ret.ErrorCode != 0){
								getIdscbmap.remove(transID1);
					    		if((ret.ErrorCode == error.INVALID_ARG_ERR)||(ret.ErrorCode == error.MISSING_ARG_ERR))		//throw only for these errors
					    		 	throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);
					    		else{
					    			setTimeout(_contact_error_cb(ret.ErrorCode),10);	//All other errors returned asynchronously.why? ..."Thats what the spec says"
				    			}
				    		 }	
						}
						catch(er){
							throw(er);
							}
							
							return transID1;
				}
				else{//sync processing
							try
							{
								ret=qtContactsIf.getContactIds( __match,__sort_order,connectId );
								
								if(ret.ErrorCode != 0)
									 throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);										
									
							}
							catch(er){
									throw(er);
								}
							return ret.ReturnValue;
					}
        },     
        

        
        /**
         * Get a list of groups' id's. This is an
         * asynchronous function. Returns a transaction id.
         * @param {function} [successCallback] A function with the signature function(string[]).
         * @param {function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i> - one of the errors:
         * <ul>
         * <li>
         * DATA_NOT_FOUND_ERR: if no groups are found.
         * </li>
         * </ul>
         * @return {number} Returns a transaction id.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): successCallback is undefined.<br>
         *                              Code 2 (INVALID_ARG_ERR): <ul><li>successCallback is not a function.</li>
         *                                                        <li>errorCallback is not a function.</li>
         *                                                        </ul>
         */
        getGroupIds: function(__succes_cb, __error_cb){
	        
        if((__succes_cb)||(__succes_cb!=null))
					if((typeof __succes_cb) != "function" )
						throw new DeviceException(error.INVALID_ARG_ERR, 'getGroupIds:Invalid succes Callback');
					
				if((__error_cb)||(__error_cb!=null))
					if((typeof __error_cb) != "function" )
						throw new DeviceException(error.INVALID_ARG_ERR, 'getGroupIds:Invalid Error Callback');
				
				
				if(__succes_cb){	//Async Processing
						try{		
			    				    	
							var transID2 = getIdscbmap.add(__succes_cb, __error_cb);
					    		
					    	ret=qtContactsIf.getGroupIdsAsync( transID2 );
					    	
							if (ret.ErrorCode != 0){
									  getIdscbmap.remove(transID2);
						    		  throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);													
							}

						}
						catch(er){
							throw(er+":GetList Failed");
							}
						return transID2;							
						
					}else{				//Sync Processing
							try
							{
								ret=qtContactsIf.getGroupIds();
								
								if(ret.ErrorCode != 0)
										 throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);										
									
							}
							catch(er){
									throw(er);
								}
							return ret.ReturnValue;
						
						
						}
        },
        
        /**
         * Add contacts to a group.
         * @param {string} groupId
         * @param {string[]} id Specifies the ids of contacts that are added to
         *                the group, whose id is <i>groupId</i>. May be a string or an array of strings.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): <ul><li>groupId is undefined.<li>
         *                                                      <li>id is undefined</li>
         *                                                      </ul>
         *                           Code 2 (INVALID_ARG_ERR): <ul><li>groupId is not a string.</li>
         *                                                         <li>id is not a string or array of strings.</li>
         *                                                      </ul> <br>
         *                           Code 101 (DATA_NOT_FOUND_ERR) if GroupId or id’s in idList are not found in database.  </li>                        
         *                           Code 102 (DATA_ALREADY_EXISTS_ERR) If a contact is added twice to one group.                           
         * @return {void}
         */
        addContactsToGroup: function(__groupId, __contactIDs){
	        
			    var ret 		= -1;
				
				if((__groupId) == null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'addContactsToGroup:Group ID Needed');
					
				if((typeof __groupId) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'addContactsToGroup:Group ID Needed');
					
				if((__groupId) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'addContactsToGroup:Group ID Needed');
				
				if((typeof __groupId) != "string")
						throw new DeviceException(error.INVALID_ARG_ERR, 'addContactsToGroup:Invalid Group Id');
			
						
				if((__contactIDs) == null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'addContactsToGroup:contactIDs Needed');
				
				if((__contactIDs) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'addContactsToGroup:contactIDs Needed');
					
				if((typeof __contactIDs) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'addContactsToGroup:contactIDs Needed');
					
				if ((typeof __contactIDs) != "object") {
					if((typeof __contactIDs) == "string")
					{
						var idArray = new Array();
						idArray.push(__contactIDs);
						
						__contactIDs=idArray;		
					}
					else
					{
						throw new DeviceException(error.INVALID_ARG_ERR, 'addContactsToGroup:Invalid contactIDs');
					}
				}
							
				try{	   		
			    	ret=qtContactsIf.addContactsToGroup(  __groupId , __contactIDs );
			    	
			    	if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);	
			
				}
				catch(er){
					throw(er);
					}
				
				return ret.ReturnValue;
        },
        
        /**
         * Remove contacts from a group.
         * @param {string} groupId
         * @param {string[]} id Specifies the ids of contacts that are removed from
         *                the group, whose id is <i>groupId</i>. May be a string or an array of strings.
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): <ul><li>groupId is undefined.<li>
         *                                                      <li>id is undefined</li>
         *                                                      </ul>
         *                           Code 2 (INVALID_ARG_ERR): <ul><li>groupId is not a string.</li>
         *                                                         <li>id is not a string or array of strings.</li>
         *                                                      </ul> <br>
         *                           Code 101 (DATA_NOT_FOUND_ERR) If a contact is deleted from a group twice or if groupId provided is not found..                          
         * @return {void}
         */
        removeContactsFromGroup: function(__groupId, __contactIDs){

			    var ret 		= -1;
				
				if((__groupId) == null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'removeContactsFromGroup:Group ID Needed');
					
				if((typeof __groupId) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'removeContactsFromGroup:Group ID Needed');
					
				if((__groupId) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'removeContactsFromGroup:Group ID Needed');
				
				if((typeof __groupId) != "string")
						throw new DeviceException(error.INVALID_ARG_ERR, 'removeContactsFromGroup:Invalid Group Id');
			
				if((__contactIDs) == null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'removeContactsFromGroup:contactIDs Needed');
				
				if((__contactIDs) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'removeContactsFromGroup:contactIDs Needed');
					
				if((typeof __contactIDs) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'removeContactsFromGroup:contactIDs Needed');
					
				if ((typeof __contactIDs) != "object") {
					if((typeof __contactIDs) == "string")
					{
						var idArray = new Array();
						idArray.push(__contactIDs);
						
						__contactIDs=idArray;		
					}
					else
					{
						throw new DeviceException(error.INVALID_ARG_ERR, 'removeContactsFromGroup:Invalid contactIDs');
					}
				}
						
				try{	   		
			    	ret=qtContactsIf.removeContactsFromGroup(  __groupId , __contactIDs );
			    	
			    	if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);		
				}
				catch(er){			
					throw(er);
					}
				
				return ret.ReturnValue;	        
        },
        
        /**
         * Cancels any asynchronous request identified uniquely by a trasactionId. This is synchronous API.
         * @param {number} transactionId
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): transactionId is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): transactionId is not a number.<br>
         *                           Code 101 (DATA_NOT_FOUND_ERR): If there are no active asynchronous request corresponds to the specified trasactionid.
         * @return {void}
         */
        cancel: function(__transaction_id){
	        
			     if((__transaction_id) == null)
					throw new DeviceException(error.MISSING_ARG_ERR, 'cancel:TransactionID Needed');
				
				if((__transaction_id) == undefined)
					throw new DeviceException(error.MISSING_ARG_ERR, 'cancel:TransactionID Needed');
					
				if((typeof __transaction_id) == "undefined")
					throw new DeviceException(error.MISSING_ARG_ERR, 'cancel:TransactionID Needed');
		
				if( ((typeof __transaction_id) != "number")  || (__transaction_id <=0) )
						throw new DeviceException(error.INVALID_ARG_ERR, 'cancel:TransactionID Needed');
						
				var ret = -1;
				try{
					ret = qtContactsIf.cancel( __transaction_id );
					
				if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);
				}
				catch(er){
					throw(er);
				}
				return ret.ReturnValue;

        },
        
        /**
         * Starts the device native contact editor UI with pre-populated contact data.
         * For the current implementation the parameter passed is an optional one.
         * <b>Note:</b> this function is not currently implemented, calling it will do nothing.
         * @param {function} callback A function with the signature function(data). This callback gets invoked in response to the user request of getting the list of Contacts.
         * @param {function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i> - one of the errors:
         * <ul>
         * <li>
         * -NA-
         * </li>
         * </ul>
         * @return {void}
         * @throws    {DeviceException} Code 1 (MISSING_ARG_ERR): callback is undefined.<br>
         *                              Code 2 (INVALID_ARG_ERR): <ul><li>callback is not a function</li>
         *                                                        <li>errorCallback is not a function</li>
         *                                                        <li>contact does not fit {@link ContactData} data scheme.</li>  
         *                                                        </ul>
         */
        startEditor: function(__success_cb,__acontact, _error_cb){
	        
			    if(!__success_cb)
						throw new DeviceException(error.MISSING_ARG_ERR, 'StartEditor:Missing Success Callback');			
		
					if((typeof __success_cb) != "function" )
						throw new DeviceException(error.INVALID_ARG_ERR, 'StartEditor:Invalid Success Callback');
	
					if(_error_cb)
						if((typeof _error_cb) != "function" )
							throw new DeviceException(error.INVALID_ARG_ERR, 'StartEditor:Invalid Error Callback');						
				
				
				if ((typeof __acontact) != "object") 					
					throw new DeviceException(error.INVALID_ARG_ERR, 'startEditor:Invalid Contact Data');			
							
					  
				    function contacts_cb(errCode, transId, result){   
							__success_cb(result);				
				    	}
				    
				    try{				    				
					var ret = qtContactsIf.startEditor(__acontact);
					__s60_start_and_wait('', contacts_cb);
										  
					  if (ret.ErrorCode != 0)
			    			throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);
				    }
					 catch(er){
						   throw(er);
					 }

        },
		
		startNotification: function(__contact_cb, __error_cb){
			
			function __Notification_cb( err, trans, notifydata ){
				if(err == 0){
					success_cbk(notifydata);				
				}
				else{
					var deverr = new DeviceAPIError(err,"startNotification: Operation Failed");
					error_cbk(deverr);
				}
			} 
		
			
			if(!__contact_cb){
				throw new DeviceException(error.MISSING_ARG_ERR, 'startNotification:Missing Success Callback');
			}
				
			if(typeof __contact_cb != "function"){
				throw new DeviceException(error.INVALID_ARG_ERR, 'startNotification:Invalid type of success callback');
			}
				
			if(__error_cb){
				if(typeof __error_cb != "function"){
					throw new DeviceException(error.INVALID_ARG_ERR, 'startNotification:Invalid type of error callback');
				}
			}
			
			var connectId = -1;
			connectId = qtContactsIf.addEventListener("asyncCallbackN(int,int,QMap<QString,QVariant>)",__Notification_cb);
				
			if( connectId < 0 ){
				//This should never happen, but adding as part of error handling - safety
				throw new DeviceException(error.NOT_ALLOWED_ERR, 'startNotification:Connect failed');
			}

			try{
	    	
	    	ret = qtContactsIf.startNotification( connectId );
				
				if( ret.ErrorCode != 0 ){
					qtContactsIf.removeEventListener( connectId );
					if(ret.ErrorCode == error.INVALID_ARG_ERR || ret.ErrorCode == error.MISSING_ARG_ERR || ret.ErrorCode == error.NOT_SUPPORTED_ERR){
						throw new DeviceException(ret.ErrorCode, ret.ErrorMessage);
					}
					else{
						if(__error_cb){
							setTimeout( function(){ 
													__error_cb(new DeviceAPIError(ret.ErrorCode, ret.ErrorMessage));
													}, 1000);
							qtContactsIf.removeEventListener(connectId);
						}
					}
					return;
				}
				
				success_cbk = __contact_cb;
				error_cbk = __error_cb;
				notificationId = connectId;
			}
			catch(e){
					//This should never happen, but adding as part of error handling - safety
					throw new DeviceException(error.NOT_ALLOWED_ERR, 'startNotification:Connect failed');
				}
			return;
		},
	
	/*
	 * public
	 * stopNotification
	 */
	stopNotification : function(){
		
		if( notificationId != -1 ){
			qtContactsIf.removeEventListener( notificationId );
			try{
				var ret = qtContactsIf.stopNotification();
				}
			catch(e){
				alert('this shld never happnd:'+e);
				//This should never happen, but adding as part of error handling - safety
				throw new DeviceException( error.NOT_ALLOWED_ERR, 'stopNotification:Operation failed');
			}
			
			if ( ret.ErrorCode != 0 ){
				alert( 'ret.ErrorCode:'+ret.ErrorCode);
				throw new DeviceException( ret.ErrorCode, ret.ErrorMessage );
			}
			notificationId = -1;
		}
		else{
			throw new DeviceException( error.DATA_NOT_FOUND_ERR, 'stopNotification:No pending notification present');
		}
	}
 }; //End of contacts return interface
	 
} //End contacts
