/**
 * @author thunga
 */

/**
 * @class
 */

/*
*/

var __s60_start_and_wait_cb;

//callback function
function __s60_on_app_exit(){    
  if(__s60_start_and_wait_cb != null){  	
    __s60_start_and_wait_cb();
  }
}

function __s60_on_app_start(){	
  window.widget.onhide = null;
  window.widget.onshow = __s60_on_app_exit;
}

/**
 *This function launches the camera apllication  
 *@param id : id of the application to be opened.
 *@param args : argument to be passed.
 *@param app_exit_cb : callback to be called when exit happpens.
 */
 
function __s60_start_and_wait(app_exit_cb){
  __s60_start_and_wait_cb = app_exit_cb;
  window.widget.onhide = __s60_on_app_start;
 // window.widget.openApplication(id, args);
}

var takePicscb = null;
	
var takePicecb = null;
function callbackfunc(result){

				var error = result.errorCode;

				if (error == 0) {
					 var retFlName = result.fileName;

					// retFlName = retFlName.replace(/\134/g, "/");

					 //retFlName = "file://"+retFlName;

					 takePicscb(retFlName);
				}
				else {
					//takePicecb(new DeviceAPIError1(error,'Error Occured in captureImage'));
					takePicecb(error);
				}
			}
	
function recordCompleteCallback(rv)
{
	window.widget.onhide = null;
	__recordingInProgress = false;
	if (__jilRecordCompleteCallback) {
		var retValue = rv.returnValue;
		__jilRecordCompleteCallback(retValue);
	}
}

var __jilRecordCompleteCallback = null;

nokia.device.Camera = function PSCameraInterface(){

    function camera_cb(errorCode,transId,result)
    {
        var retObj = asyncCallbackMap.get(transId);
        asyncCallbackMap.remove(transId);
		//Temporary hack for properly work of callback
		//One instantion of camera has been supported
		asyncCallbackMap.usec_count = 0;
        if(retObj)
        {
            var callback = retObj.success_cb;
            var errorCallback = retObj.error_cb;
            if(errorCode)
            {
                 if (errorCallback) {
                    errorCallback(new DeviceException(errorCode, "Camera : startCamera : error occured."));
                }
            }
            else
            {
                callback(result);
            }
        }
    }

    var DeviceException = nokia.device.DeviceException;
    var DeviceAPIError = nokia.device.DeviceAPIError;
    //camera application UID. 
    var CAMERA_APP_ID = 0x101f857a;
    var error = new DeviceException(0,'dummy');
    var errorAPI = new DeviceAPIError(0,'dummy');
	
	//flag indicating whether startRecording has been called
	var __recordingInProgress = false;
				
    /*
     * Internal
     * qt contacts interface object.
     */
	
    	var psCameraIntf = nokia._services.load("nokia.device.camera", "com.nokia.ICamera", "1.0");
        psCameraIntf.addEventListener("asyncCallback(int, int, QVariant)",camera_cb);

    
    /*
				  * supportedsizes global variable
				  */
				 var qtCameraSupportedSizes = [];
				 try{
				 qtCameraSupportedSizes = psCameraIntf.supportedSizes();//supported sizes
				}
				catch(er){
					sfw_debug("Unable to get supported sizes"+er);					
				}
				 /*
				 * Read only property - supported sizes
				 */
				 psCameraIntf.supportedSizes = qtCameraSupportedSizes;
    
		    function af(str){
				//alert(str);
			}
			/*
			 * golbal variable to keep track of the domObject 
			 */  
			var prevDomObj = null;
			
			var pluginObj = null;
			
			var vferrcode = 0;
			var vferrmessage = "Success";
			
			var width = 0;
			var height = 0;
			
			var CameraPlugin = null;
	

        // When widget gets hidden while video capture in progress this function gets invoked. Here we stop the video Capturing.		
	// Issue - If an error occurs while stopping we dont have a way to communicate to the user in this scenario
			function widgetHidden(){
				try{
					//alert("in widget onhidden");					
					if(CameraPlugin != null && __recordingInProgress){
							var returnObject = CameraPlugin.StopRecording();
							__recordingInProgress = false;
					}
					window.widget.onhide = null;
				}
				catch(e){
					af("exception in widgethidden func"+e.toString());
				}
			}
  return {
     	    /**
     	    * @constant {String} 
     	    * interfaceName.
     	    */      
     	    interfaceName: "camera",
     	    /**
     	    * @constant {Number} 
     	    * version.
     	    */      
     	    version: nokia.device._interfaces['camera'],
  	     /*
				 * Read only property - supported sizes
				 */
				 
				supportedSizes :  qtCameraSupportedSizes,
  	     
				/**
         * Starts the camera application and returns the list of meta data of images captured.         
         * @param {function} successCallback A function with the signature function((picdata}).         
         * @param {function} [errorCallback] This callback function gets invoked with
         * {@link DeviceError} object when error occurs in processing the async request.
         * <i>function(DeviceError)</i>
         * <i>{@link DeviceError}</i> - one of the errors:
                 
         * @throws {DeviceException} Code 1 (MISSING_ARG_ERR): successCallback is undefined.<br>
         *                           Code 2 (INVALID_ARG_ERR): <ul><li>successCallback is not a function</li>
         *                                                        <li>errorCallback is not a function</li>                                                              
         *                                                        </ul>
         */                 
				 
				startCamera:function(sCB, eCB){
				
				
				var start_date = new Date();		
				
				if(sCB == undefined || sCB == null){
					throw new DeviceException(error.MISSING_ARG_ERR, 'startCamera:Missing Success Callback');
				}
			
       	if(sCB && ((typeof sCB) != "function" )){
        		throw new DeviceException(error.INVALID_ARG_ERR, 'startCamera:Invalid Success Callback');
        }
					
				if(eCB && ((typeof eCB) != "function" )){
        		throw new DeviceException(error.INVALID_ARG_ERR, 'startCamera:Invalid Error Callback');	
       	}
        	
		try {
				var tid = asyncCallbackMap.add(sCB, eCB);
				
				var errormap = psCameraIntf.startCamera();
			} 
			catch (er) {
				sfw_debug("Unable to launch Camera" + er);
			}
		if (navigator.appVersion.toLowerCase().indexOf("linux") == -1) 
        {
			if (errormap.ErrorCode != 0) {
				if ((eCB != null) && (eCB != undefined)) 
					eCB(new DeviceAPIError(errormap.ErrorCode, "Camera:startCamera:Operation Failed"));
			}
			else {
				__s60_start_and_wait(callback);
			}
		}	
				
				//callback function.		
				function callback(arg1, arg2, arg3){					
					var end_date = new Date();					
					//get the list of images taken between the start and exit of the camera.
					try{
					var result = psCameraIntf.getList(start_date, end_date);			
				  }
				  catch(er){
				  sfw_debug("Unable to get meta data list of images"+er);	
				  }
					var errormap = result.errormap;		  		  
					if ( errormap.ErrorCode != 0) {
						eCB(new DeviceAPIError(errormap.ErrorCode, "Camera:Getlist:Operation Failed"));
						}
					else {
						sCB(result.picturedata);
						}
					}		
				},
			stopViewFinder: function(){
			try {
			        // If the plugin object gets deleted in the callback widget crashes. To fix this crash we have made removal of plugin after a delay of 0.5 seconds
				// This is actually a bug in webkit which needs to be fixed.
				if (prevDomObj) {
					CameraPlugin.StopViewFinder();
					setTimeout(function(){
	                            prevDomObj.removeChild(pluginObj);
				     prevDomObj = null;
	                                },500);
				
				}
			} 
			catch (e) {
				af("Exception in stop in cjse" + e.toString());
				throw e;
			}
		},
			/*
			 * API startViewFinder() to load the camera plugin and set the preview window of the camera. 
			 */
				startViewFinder: function (__domObject){
				try{
					if(!__domObject){
						throw new DeviceException(error.MISSING_ARG_ERR,'domObject input is missing');
					}
					if(typeof __domObject != 'object'){
						throw new DeviceException(error.INVALID_ARG_ERR,'domObject input is not an object');
					}
					if(!__domObject.style){
						throw new DeviceException(error.INVALID_ARG_ERR,'domObject input does not mention the height and width of the window');
					}
					if(prevDomObj){
						throw new DeviceException(error.INVALID_ARG_ERR,'a window is already set. Cannot set another window');
					}
					width = __domObject.style.width ;
					height = __domObject.style.height;
					//TODO: need to check the lower limit and upper limit throw exception accordingly
					if(width == "0px" || height == "0px"){						
						throw new DeviceException(error.INVALID_ARG_ERR,'domObject input is not valid.');
					}					
					if(width == "" || height == ""){						
						throw new DeviceException(error.INVALID_ARG_ERR,'domObject input is not valid.');
					}								
					var newdiv = document.createElement('div');
				    newdiv.id = "Camera";
				    newdiv.innerHTML = "\<object id = \"CameraDiv\" TYPE=nokiaplugin\/camera WIDTH="+width+" HEIGHT="+height+" text = \"Camera Nokia Plugin\" hidden="+true+"\>\<\/object\>";	
					__domObject.appendChild(newdiv, document.body.firstChild);
				    CameraPlugin = document.getElementById("CameraDiv");
			
					prevDomObj = __domObject;
				    pluginObj = newdiv;
				
      				  //alert("callingviewfinder");   
         			setTimeout(function(){
						if(CameraPlugin != null){
							var retVal = CameraPlugin.StartViewFinder();
							var errcode = retVal.errorCode;
							var errMessage = retVal.errorMessage;
							if(errcode != 0){							
								throw new DeviceException(errCode, errMessage);
							}
							}
							else{
								throw new DeviceException(error.INVALID_ARG_ERR, 'Operation Failed');
							}
						},500);
				}
				catch(e){
					prevDomObj = null;
					af("exception in cjse setCamWindow()"+e.toString());
					throw e;
				}
			},
			/**
			 * captures a still image and stores to a file
			 *
			 * Returns ??
			 * @param {Function}
			 *         callback - The supplied function will be called when capturing is complete
			 * @param {URL}
			 *         fileName - url of the file to which the image is to be saved 
			 * @param {lowRes}
			 *         Flag to indicate whether the resolution must be maximum or minimum
			 *         Defaults to false
			 * @return {Number} TransactionId which uniquely identifies asynchronous request.
			 * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): callback is undefined.<br>
			 *                              Code 2 (INVALID_ARG_ERR): <ul><li>callback is not a function</li>
			 *                                                            <li>fileName is not a string</li>
			 *                                                            <li>lowResolutionFlag is not boolean</li>
			 */                                                           
					
			captureImage: function(__callback, __options, __errorCallback){
			try {
				var __flName = __options.fileUri; 
				var __lowRes = __options.lowResolution;
				if(prevDomObj == null){
					throw new DeviceException(error.INVALID_ARG_ERR, 'window is not set');
				}
				af("in cjse flname"+__flName);
				function validateFlName(fName){
					var index = fName.indexOf(".");
					if(index != -1){
						var remName = fName.slice(index);
						if(remName == ".jpg")
							return true;
						else
							validateFlName(remName);	
					}
					else
						return false;
				};				
				if (!__callback) {
					throw new DeviceException(error.MISSING_ARG_ERR, 'success callback is mandatory');
				}
				if (typeof __callback != 'function') {
					throw new DeviceException(error.INVALID_ARG_ERR, 'Invalid type of success callback');
				}
				if (__errorCallback) {
					if (typeof __errorCallback != 'function') {
						throw new DeviceException(error.INVALID_ARG_ERR, 'Invalid type of error callback');
					}
				}
				takePicscb = __callback;
				takePicecb = __errorCallback;
				if (__flName) {
					if (typeof __flName != 'string') {
						throw new DeviceException(error.INVALID_ARG_ERR, 'Invalid type of file name input');
					}
				}
				if (__lowRes) {
					if (__lowRes != true && __lowRes != false) {
						throw new DeviceException(error.INVALID_ARG_ERR, 'invalid type of lowRes input');
					}
				}
				if(__flName != null && (__flName.length > 255 || __flName.length < 0)){
					throw new DeviceException(error.INVALID_ARG_ERR, 'invalid size of file name');
				}
				
				if(__flName)
					__flName = __flName + String.fromCharCode(0);
				if(prevDomObj == null){
					throw new DeviceException(error.INVALID_ARG_ERR, 'window is not set');
				}
				else{
					var result = CameraPlugin.TakePicture("callbackfunc" + String.fromCharCode(0), __flName, __lowRes);
					var errcode = result.errorCode;
					var errMessage = result.errorMessage;
					if (errcode != 0) {
	                    switch (errcode) {
	                        case error.INVALID_ARG_ERR:
	                        case error.MISSING_ARG_ERR:
	                        case error.NOT_SUPPORTED_ERR:
	                            throw new DeviceException(errcode, errMessage);
	                        default:
	                            if (__errorCallback) {
	                                setTimeout(function(){
	                                    __errorCallback(new DeviceException(errcode, errMessage));
	                                }, 1000);
	                                return;
	                            }
	                            else {
	                                throw new DeviceException(errcode, errMessage);
	                            }
                            }    
                         }										 
					 var retFlName = result.fileName;
					 
					 return retFlName;
				}
				
			} 
			catch (e) {
				af("Exception in captureImage in cjse" + e.toString());
				throw new DeviceException( e.code, e.message);
			}
		},

			

		/**
		 * starts the recording of video
		 *
		 * Returns unique transaction id.
		 * @param {Function}
		 *         callback - The supplied function will be called when recording is complete
		 * @param {URL}
		 *         fileName - url of the file to which the video is to be saved 
		 * @param {LowResolutionFlag}
		 *         Flag to indicate whether the resolution must be maximum or minimum
		 *         Defaults to false
		 * @param {MaxDuration}        
		 *         Maximum Duration for which the recording needs to be done
		 * @return {Number} TransactionId which uniquely identifies asynchronous request.
		 * @exception {DeviceException} Code 1 (MISSING_ARG_ERR): callback is undefined.<br>
		 *                              Code 2 (INVALID_ARG_ERR): <ul><li>callback is not a function</li>
		 *                                                            <li>fileName is not a string</li>
		 *                                                            <li>lowResolutionFlag is not boolean</li>
		 *                                                            <li>maxDuration is not a number</li>
		 */                                                           
			
			startVideoCapture: function(__callback, __options, __errorCallback) {
				try {
				var __fileName = __options.fileUri;
				var __lowResolutionFlag = __options.lowResolution;
				var __maxDuration = __options.duration;
				
                if(prevDomObj == null){
					throw new DeviceException(error.INVALID_ARG_ERR, 'window is not set');
				}
                if(__callback == null || typeof __callback == undefined) {
					throw new DeviceException(error.MISSING_ARG_ERR,'callback is missing');
				}
				
				else if( typeof __callback != "function") {
				    throw new DeviceException(error.INVALID_ARG_ERR,'callback is not a function');
				}

                if(__errorCallback != null && typeof __errorCallback != undefined) {
					if( typeof __errorCallback != "function") {
						throw new DeviceException(error.INVALID_ARG_ERR,'error callback is not a function');
					}

				}
				
				if (__fileName != null && typeof __fileName != "undefined" && __fileName != "") {
					if (typeof __fileName != "string") {
						throw new DeviceException(error.INVALID_ARG_ERR, 'filename is not a string');
					}
				}
				
				else
				   __fileName = null;
				
				if (__lowResolutionFlag != null && typeof __lowResolutionFlag != "undefined" ) {
					if (typeof __lowResolutionFlag != "boolean") {
						throw new DeviceException(error.INVALID_ARG_ERR, 'low Resolution is not a boolean value');
					}
				}
				
				else
				   __lowResolutionFlag = false;
				
				if (__maxDuration != null && typeof __maxDuration != "undefined") {
					if (typeof __maxDuration != "number" || (__maxDuration != __maxDuration | 0) || __maxDuration < 0) {
						throw new DeviceException(error.INVALID_ARG_ERR, 'maximum duration  is invalid');
					}
					
					else if(__maxDuration == 0 || __maxDuration > 300) {
					   throw new DeviceException(error.NOT_ALLOWED_ERR,'maximum duration is out of range ');
				    }

				}
				
                		else
				   __maxDuration = 300;
			
				   
					__jilRecordCompleteCallback = __callback;
					
					if(__fileName!=null)
					   __fileName = __fileName +String.fromCharCode(0);
					 
					__recordingInProgress = true;
					var returnObject = CameraPlugin.StartRecording( "recordCompleteCallback" + String.fromCharCode(0),__fileName, __lowResolutionFlag, __maxDuration, false );
					
					//use only errorMessage, returnObject.errorMessage accessible only once
					var errorMessage =  returnObject.errorMessage;
					var retValue = returnObject.returnValue;
					var tid = returnObject.transactionId;
					
				    if (returnObject.errorCode != 0) {
						__recordingInProgress = false;
	                    switch (returnObject.errorCode) {
	                        case error.INVALID_ARG_ERR:
	                        case error.MISSING_ARG_ERR:
	                        case error.NOT_SUPPORTED_ERR:
	                            throw new DeviceException(returnObject.errorCode, errorMessage);
	                        default:
	                            if (__errorCallback) {
	                                setTimeout(function(){
	                                    __errorCallback(new DeviceException(returnObject.errorCode, errorMessage));
	                                }, 1000);
	                                return;
	                            }
	                            else {
	                                throw new DeviceException(returnObject.errorCode, errorMessage);
	                            }
                            }    
                         }	
     			   window.widget.onhide = widgetHidden;		 
				   return   retValue;      
                  }
				  
				catch(e) {
					
					throw new DeviceException( e.code, e.message);
				}
			},
		  		
				
	    /**
		 * stops the recording of video
		 */                                                           

		  stopVideoCapture : function (){
		  	try{
					if(prevDomObj == null){
						throw new DeviceException(error.NOT_ALLOWED_ERR, 'window is not set');
					}	
					var returnObject = CameraPlugin.StopRecording(  );
					
					var errorMessage = returnObject.errorMessage;
					
					
				    if (returnObject.errorCode != 0) {
	                   
	                       throw new DeviceException(returnObject.errorCode, errorMessage);
                                
                         }        
					
				}
				catch(e) {
				
					throw new DeviceException( e.code, e.message);
				}
		  }
  };  
}
