#!/usr/local/bin/perl -w
use XML::Simple;
use File::Path;
use File::Copy;
use Data::Dumper;
use Cwd;



sub environmentSetup()
{
     my $pwd = cwd();  
     if( exists $ENV{'CWRTPATH'} )
     {
          $cwrtpath =  $ENV{'CWRTPATH'};
          $cjsepath = $cwrtpath . "/wrt/jsapi/cjse";
     }
     #check if script is running from serviceproviders
     elsif($pwd =~ m"/wrt/serviceproviders")
     {
          $cwrtpath =  ".";
          $cjsepath = $pwd . "/../jsapi/cjse";
     }
     else
     {
          $cwrtpath =  ".";
          $cjsepath = $cwrtpath;
     }
     $configfile = $cjsepath . "/config/config.xml";
     $configparser = XMLin($configfile);
}

sub cleanup()
{
     if( -e $cjsepath . "/wgtwidgets" )
     {
          rmtree($cjsepath . "/wgtwidgets");
     }
     if( -e $cjsepath . "/wgzwidgets" )
     {
          rmtree($cjsepath . "/wgzwidgets");
     }

     if( -e $cjsepath . "/temp" )
     {
          rmtree($cjsepath . "/temp");          
     }
     
     if( -e $cjsepath . "/release/uncompressed" )
     {
          rmtree($cjsepath . "/release/uncompressed" );
     }
     
     if( -e $cjsepath . "/release/platformservices.js" )
     {
          unlink($cjsepath . "/release/platformservices.js");
     }
     
     mkdir( $cjsepath . "/release" );
     mkdir( $cjsepath . "/release/uncompressed" );
     mkdir( $cjsepath . "/temp" );
}

sub generateJSFiles()
{
    if( -e $configparser->{provider} ) 
    {
    print "\nMerging and generating cjse javascript files ...\n\n";
    $providerpath = $cjsepath . "/" . $configparser->{provider};
    if( -e $providerpath ) 
        {
        @files = <$providerpath/*>;
        
        open MODFILE, ">$cjsepath/temp/$configparser->{provider}.txt" or die $!; 
        foreach $file (@files) 
            {            
            print MODFILE "$file\n"; 
            }
        close MODFILE;
        
        system "java -jar $cjsepath/tools/JsCombine.jar $cjsepath/temp/$configparser->{provider}.txt $cjsepath/release/$configparser->{provider}.js > $cjsepath/temp/$configparser->{provider}.log";        
        system "java -jar $cjsepath/tools/custom_rhino.jar -c $cjsepath/release/$configparser->{provider}.js > $cjsepath/temp/$configparser->{provider}.js";
        }
        
    open DOMFILE, ">$cjsepath/temp/jsfiles.txt" or die $!; 
    print DOMFILE "$cjsepath/release/framework.js\n";
    @files = <$cjsepath/release/*.js>;
    foreach $file (@files) 
        {
        if( $file ne "$cjsepath/release/framework.js" )
            {
            print DOMFILE "$file\n";    
            }
        }
    close DOMFILE;
    
    system "java -jar $cjsepath/tools/JsCombine.jar $cjsepath/temp/jsfiles.txt $cjsepath/temp/intermediate.js > $cjsepath/temp/combinejs.log";
    system "java -jar $cjsepath/tools/custom_rhino.jar -c $cjsepath/temp/intermediate.js > $cjsepath/release/platformservices.js";
    copy(" $cjsepath/release/platformservices.js", " $cjsepath/release/device.js") or die "File cannot be copied";
    }
    else
    {
    print "Merging and generating cjse javascript files ...\n";
    for($i = 0; $i < scalar(@{$configparser->{provider}}); $i++)
        {
        $providerpath = $cjsepath . "/" . $configparser->{provider}->[$i];
        open MODFILE, ">$cjsepath/temp/$configparser->{provider}->[$i].txt" or die $!; 
        if( -e $providerpath ) 
            {
            @files = <$providerpath/*>;
            
            open MODFILE, ">$cjsepath/temp/$configparser->{provider}->[$i].txt" or die $!; 
            foreach $file (@files) 
                {            
                print MODFILE "$file\n"; 
                }
            close MODFILE;
            
            system "java -jar $cjsepath/tools/JsCombine.jar $cjsepath/temp/$configparser->{provider}->[$i].txt $cjsepath/release/uncompressed/$configparser->{provider}->[$i].js > $cjsepath/temp/$configparser->{provider}->[$i].log";
            system "java -jar $cjsepath/tools/custom_rhino.jar -c $cjsepath/release/uncompressed/$configparser->{provider}->[$i].js > $cjsepath/release/$configparser->{provider}->[$i].js";
            }
        }
        
    open DOMFILE, ">$cjsepath/temp/jsfiles.txt" or die $!; 
    print DOMFILE "$cjsepath/release/framework.js\n";
    @files = <$cjsepath/release/*.js>;
    foreach $file (@files) 
        {
        if( $file ne "$cjsepath/release/framework.js" )
            {
            print DOMFILE "$file\n";    
            }
        }
    close DOMFILE;
    
    system "java -jar $cjsepath/tools/JsCombine.jar $cjsepath/temp/jsfiles.txt $cjsepath/temp/intermediate.js > $cjsepath/temp/combinejs.log";
    system "java -jar $cjsepath/tools/custom_rhino.jar -c $cjsepath/temp/intermediate.js > $cjsepath/release/platformservices.js";
    copy("$cjsepath/release/platformservices.js", "$cjsepath/release/device.js") or die "File cannot be copied";
    
    
    
    print "cjse javascript libraries successfully created ...\n";
    }
}

environmentSetup();
cleanup();
generateJSFiles();