# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#

####################################################################################
#
# Common Web Run Time - common settings - cwrt.pri
#
# This project include by any cWRT component that utilizes common settings.
# It should not be included directly in case the component has dependencies on
# webkit - cwrt-webkit.pri must be included instead.
#
####################################################################################

isEmpty(_CWRT_PRI_INCLUDED_): {
    _CWRT_PRI_INCLUDED_=1

    CONFIG(debug, debug|release) {
        SUBDIRPART = Debug
    } else {
        SUBDIRPART = Release
    }

    contains( wrt_tracing, on ) {
        DEFINES += ENABLE_TRACE_SIGNAL
    }

    CWRT_HOME=$$PWD

    # Figure out the root of where stuff should go (this could be done via configure)
    OUTPUT_DIR = $$PWD/..

    OBJECTS_DIR = $$OUTPUT_DIR/WrtBuild/$$SUBDIRPART/$$TARGET/tmp
    MOC_DIR = $$OUTPUT_DIR/WrtBuild/$$SUBDIRPART/$$TARGET/tmp
    RCC_DIR = $$OUTPUT_DIR/WrtBuild/$$SUBDIRPART/$$TARGET/tmp
    UI_DIR = $$OUTPUT_DIR/WrtBuild/$$SUBDIRPART/$$TARGET/tmp
    TEMPDIR= $$OUTPUT_DIR/WrtBuild/$$SUBDIRPART/$$TARGET/build
    DESTDIR = $$OUTPUT_DIR/WrtBuild/$$SUBDIRPART/bin
    QMAKE_RPATHDIR = $$DESTDIR $$QMAKE_RPATHDIR
    QMAKE_LIBDIR = $$DESTDIR $$QMAKE_LIBDIR

    INCLUDEPATH+=$$CWRT_HOME

    unix:!symbian {
        include(../shared.pri)
        # Backwards compatibility in current build system
        maemo {
            #
            maemo5 {
                CONFIG-=maemo6
            } else {
                CONFIG+=maemo6
            }
            include(cwrt-maemo.pri)
        }
    }

    # Add the output dirs to the link path too
    LIBS += -L$$DESTDIR

    DEPENDPATH += .
    INCLUDEPATH += .

    # keep below in sync with cwrt-export.pri
    # FIXME: win32 is special-cased due to blind-fixing a build failure caused by r26966

    maemo5|maemo6 {
        # instead of copying header files (exporting), add here the
        # include paths for components that are written to depend on
        # copying. See cwrt-export.pri for the implementation.
        # ideally, new sub-target libraries should create .pri file
        # which would provide LIBS and INCLUDES and consumers of those
        # libraries would include that .pri.
        CWRT_INCLUDE = $$PWD/ipc/serviceipc $$PWD/ipc/serviceipcserver $$PWD/security $$PWD/servicefw/inc $$PWD/servicefw/servicehandler $$PWD/securestorage
    } else: symbian {
	CWRT_INCLUDE = $$MW_LAYER_PUBLIC_EXPORT_PATH(cwrt)
    } else {
        CWRT_INCLUDE = $$PWD/include/
    }
    # Currently only used for Linux and Maemo platforms. Please if-else if this needed for Symbian.
    # When using this component should concatenate component specific header directory.
    CWRT_INSTALL_PUBLIC_HEADERS_DIR = /usr/include/cwrt

    !win32-msvc*:QMAKE_CXXFLAGS_DEBUG += -g

    CONFIG(gcov)   {
       LIBS           += -lgcov
       QMAKE_CXXFLAGS += -fprofile-arcs -ftest-coverage
    }
}
