# Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
#
# This file is part of Qt Web Runtime.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# version 2.1 as published by the Free Software Foundation.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#

######################################################################
#
# Export macro common settings
# Users need to define EXPORT_FILES and EXPORT_DIR
#
######################################################################


maemo5|maemo6 {
    isEmpty(EXPORT_FILE_EXT) {
        EXPORT_FILE_EXT = h
    }
    isEmpty(EXPORT_DIR) {
        EXPORT_DIR = $$CWRT_INCLUDE
    }

    # for non-symbian, non win32 platforms it does not seem to make any sense to
    # copy header files around. The include path should just be
    # correctly set up, so that sub-targets can include correct
    # headers.  this in turn should be done by including the .pri file
    # of the library that the sub-target is depending on. This should be
    # sensible strategy for symbian platforms also.

    # However, since the servicefw sub-targets and servicefw consumers
    # (plugins) and are written to depend file copying,
    # we must put the include paths to CWRT_INCLUDE if we want to avoid
    # copying

    # To have one platform do copying and the other not do copying can
    # in worst case cause hard-to-debug missing include things. This
    # is why we complicate things by checking that the files that are
    # exported (copied) are found from CWRT_INCLUDE path on maemo. If
    # not, the build fails and the developer can add the path to
    # include path.

    # the below does not cause noticeable qmake-time build time increase
    # at the moment, at least.

    for(file, EXPORT_FILES): {
        isxml=$$find(file, .*.xml$)
        isEmpty(isxml): {
             pass=0
             for(dir, CWRT_INCLUDE): {
                 exists($${dir}$${QMAKE_DIR_SEP}$${file}): pass=1
             }
             !contains(pass, 1): error(Failed to find exported file \'$${file}\' in CWRT_INCLUDE path. Please add the path to CWRT_INCLUDE in \'cwrt.pri\')
        }
    }
} else: symbian {
    isEmpty(EXPORT_DIR) {
        for(exp_file, EXPORT_FILES) {
            BLD_INF_RULES.prj_exports += "$${exp_file}   $$MW_LAYER_PUBLIC_EXPORT_PATH(cwrt/$$basename(exp_file))"
        }
    } else {
        for(exp_file, EXPORT_FILES) {
            BLD_INF_RULES.prj_exports += "$${exp_file}   $${EXPORT_DIR}$$basename(exp_file)"
        }
    }
} else {
   isEmpty(EXPORT_FILE_EXT) {
        EXPORT_FILE_EXT = h
   }
   isEmpty(EXPORT_DIR) {
        EXPORT_DIR = $$CWRT_INCLUDE
   }
   win32: EXPORT_DIR = $$replace(EXPORT_DIR, "\/", "\\")
   export_cmd.input = EXPORT_FILES
   export_cmd.output = $$EXPORT_DIR${QMAKE_FILE_BASE}.$$EXPORT_FILE_EXT
   win32 {
       export_cmd.commands = copy /y ${QMAKE_FILE_NAME} $$EXPORT_DIR${QMAKE_FILE_BASE}.$$EXPORT_FILE_EXT
   } else {
       export_cmd.commands = $(COPY) ${QMAKE_FILE_NAME} $$EXPORT_DIR${QMAKE_FILE_BASE}.$$EXPORT_FILE_EXT
   }
   export_cmd.CONFIG = target_predeps no_link
   export_cmd.clean = $$EXPORT_DIR${QMAKE_FILE_BASE}.$$EXPORT_FILE_EXT
   QMAKE_EXTRA_COMPILERS += export_cmd
}
