/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author:  Flavio Ceolin <flavio.ceolin@profusion.mobi>
 *          Jonas Gastal <jgastal@profusion.mobi>
 *          Raphael Kubo da Costa <kubo@profusion.mobi>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef WGT2DEB_H
#define WGT2DEB_H

#ifdef __cplusplus
extern "C" {
#endif

#if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ > 4)
# define GNU_PRINTF(fmt, arg)  __attribute__((format (printf, fmt, arg)))
#else
# define GNU_PRINTF(fmt, arg)
#endif

#define ERR(fmt, ...)                                           \
    _err(__FILE__, __LINE__, __FUNCTION__, fmt, ##__VA_ARGS__)
#define DBG(fmt, ...)                                           \
    _dbg(__FILE__, __LINE__, __FUNCTION__, fmt, ##__VA_ARGS__)

bool create_debian(const char *distro, const char *name, const char *validatedName, const char *version, const char *description,
                   char **icon, const char *viewmode_widget, const char *viewmode_application, const char *webappid,
                   const char *wgt_path, const char *deb_path, const char *tmpdir, const char *license);

void _err(const char *file, int line, const char *func, const char *fmt, ...) GNU_PRINTF(4, 5);
void _dbg(const char *file, int line, const char *func, const char *fmt, ...) GNU_PRINTF(4, 5);
void dbg_init(void);

char *get_config_from_zip(const char *zipfile);

#ifdef __cplusplus
}
#endif

#endif
