/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#include <QWebInspector>
#include <QGraphicsProxyWidget>
#include <QGraphicsLinearLayout>

#include "wrtwebinspector.h"

// qgraphicsproxywidget display cache size
static const QSize CACHE_SIZE(800,480);

namespace WRT{
   namespace Maemo{
      WrtWebInspector::WrtWebInspector( QGraphicsItem * parent /* =0 */)
        : QGraphicsProxyWidget( parent),
          m_inspector( new QWebInspector)
      {
          // inspector must be enabled in QWebSettings
          QWebSettings::globalSettings()->setAttribute( QWebSettings::DeveloperExtrasEnabled, true);

          setCacheMode( QGraphicsItem::ItemCoordinateCache, CACHE_SIZE);
          setWidget( m_inspector);
      }


      WrtWebInspector::~WrtWebInspector(){
      }


      void WrtWebInspector::setPage( QWebPage* page){
          if( page){
              m_inspector->setPage( page);
          }
      }

   } // namespace Maemo
} // namespace WRT

