/*
 * Copyright (c) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * This file is part of Qt Web Runtime.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef WEBKINETICSCROLLER_H
#define WEBKINETICSCROLLER_H

#include <QAbstractKineticScroller>
#include <QGraphicsWidget>
#include <QPointer>

class QGraphicsWebView;
class QWebFrame;
class QWebHitTestResult;

namespace WRT {
namespace Maemo {

class WebKineticScroller : public QGraphicsWidget, public QAbstractKineticScroller
{
    Q_OBJECT

public:
    WebKineticScroller(QGraphicsWebView* webView);
    ~WebKineticScroller();

    void activateScrollingForView();

protected:
    bool sceneEventFilter(QGraphicsItem* i, QEvent* e);
    QSize viewportSize() const;
    QPoint maximumScrollPosition() const;
    QPoint scrollPosition() const;
    void setScrollPosition(const QPoint& p, const QPoint& overShoot);
    void sendEvent(QGraphicsItem* i, QEvent* e);
    QWebFrame* currentFrame() const;
    QWebFrame* scrollingFrameAt(const QWebHitTestResult& hitResult) const;
    bool isDraggableElement(const QWebHitTestResult& hitResult) const;

    QGraphicsWebView* m_webView;
    bool m_ignoreEvents;
    bool m_draggable;
    QPointer<QWebFrame> m_frame;
};

}
}

#endif // WEBKINETICSCROLLER_H
