/*
 * Decompiled with CFR 0.152.
 */
package com.thecodecentral.jscombine;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class jsCombine {
    private ArrayList<String> fileList = new ArrayList();
    private String outFileName;

    public jsCombine(String fileListName, String outFileName) {
        this.outFileName = outFileName;
        try {
            this.fileList = this.parseFileList(fileListName);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    private ArrayList<String> parseFileList(String fileListName) throws IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        File file = new File(fileListName);
        if (!file.exists()) {
            throw new IOException("Couldn't find file " + fileListName);
        }
        Scanner scan = new Scanner(file);
        while (scan.hasNext()) {
            fileNames.add(scan.nextLine());
        }
        return fileNames;
    }

    public String combineFileList() throws IOException {
        String page = "";
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(this.outFileName)));
        for (String fileName : this.fileList) {
            System.out.println("Reading file: " + fileName + " ... ");
            File file = new File(fileName);
            if (!file.exists()) {
                System.out.println("Couldn't find file " + fileName);
                continue;
            }
            Scanner scanner = new Scanner(file);
            System.out.println("Combining file: " + fileName + " ... ");
            while (scanner.hasNext()) {
                writer.println(scanner.nextLine());
            }
        }
        writer.close();
        return page;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: fileListFileName outPutFileName");
            System.exit(0);
        }
        jsCombine c = new jsCombine(args[0], args[1]);
        try {
            c.combineFileList();
            System.out.println("Done!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

