#include "wolan.h"
#include "clshost.h"
#include "ui_wolan.h"
#include <QtNetwork>
#include <QtGui>
#include <QDataStream>
#include <QtMaemo5>

//00:c0:9F:2B:A5:97

WoLAN::WoLAN(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::WoLAN)
{
    ui->setupUi(this);
    //qDebug() << "Open input file";
    QString sFilename;

    //sFilename = QDir().currentPath();
    sFilename = "/opt/wolan/wolan.conf";
    bEditMode = false;
    bAddMode=false;
    tgList.getFromFile(sFilename);

    iCurrentTarget = tgList.lstTarget.size()-1;
    DisplayTarget (iCurrentTarget);
    ui->label->setText("             ");
    //ui->progressBar->setValue(0);
    //ui->progressBar->setMaximum(0);
    ui->fraBar->setVisible(false);
}

WoLAN::~WoLAN()
{
    delete ui;
}



void WoLAN::on_pushButton_clicked()
{
    QString sMsg;
    int i,j;
    bool b;

    ui->pushButton->setEnabled(false);
    QByteArray bMsg;
    for (i=0;i<=5;i++)
        bMsg.append("\xff");
    for (i=0;i<=15;i++)
        for (j=0;j<17;j+=3)
            bMsg.append(ui->lMAC->text().mid(j,2).toInt(&b,16));

    //<<QByteArray(16,ui->lMAC->text());

     udpSocket.connectToHost(ui->lIP->text(), ui->lPort->text().toInt());
    if (udpSocket.waitForConnected(1000))

    {
        udpSocket.write(bMsg);
    }
    udpSocket.close();

    ui->label->setText("Sent at " +  QTime::currentTime().toString("hh:mm:ss"));
    //QMaemo5InformationBox::information(this, "Sent at " +  QTime::currentTime().toString("hh:mm:ss"),
    //                                            QMaemo5InformationBox::DefaultTimeout);

    timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(checkConnection()));
    iNbrSeconds=ui->lTimeOut->text().toInt();
    setButtons(false);
    timer->start(1000);
    ui->progressBar->setValue(0);
    ui->progressBar->setMaximum(iNbrSeconds);
    ui->frame->setVisible(false);
    ui->fraInfo->setVisible(false);
    ui->fraBut->setVisible(false);
    ui->fraBar->setVisible(true);
}

void WoLAN::checkConnection()
{
    //timer->stop();

    ui->progressBar->setValue(ui->progressBar->value()+1);
    //ui->lblTimer->setText(iNbrSeconds +" Sec");
    //ui->lblTimer->show();
    tcpClient.connectToHost(ui->lIP->text(), ui->ltcpPort->text().toInt());

    if  (tcpClient.waitForConnected(1000))
    {

        ui->label->setText ("Host is up");
        //ui->lblTimer->setText("");
        QMaemo5InformationBox::information(this, "Host is up",
                          QMaemo5InformationBox::NoTimeout);
        timer->stop();
        qDebug("Connected!");

        ui->fraBar->setVisible(false);
        ui->fraInfo->setVisible(true);
        ui->frame->setVisible(true);
        ui->fraBut->setVisible(true);
        setButtons(true);
    } else if (--iNbrSeconds<=0)
    {
        ui->label->setText ("Host is not running");
        QMaemo5InformationBox::information(this, "Host is not running",
                               QMaemo5InformationBox::NoTimeout);

        qDebug("Not connected");
        timer->stop();
        //ui->lblTimer->setText("");
        ui->progressBar->setValue(0);
        ui->fraBar->setVisible(false);
        ui->fraInfo->setVisible(true);
        ui->frame->setVisible(true);
        ui->fraBut->setVisible(true);
        setButtons(true);
    }
    if (tcpClient.error() == QAbstractSocket::HostNotFoundError)
    {
        timer->stop();

        // NOLBL ui->label->setText ("Cannot find IP address for " + ui->lIP->text());
        QMaemo5InformationBox::information(this,"Cannot find IP address for <b>" + ui->lIP->text() + "</b>",
                                                    QMaemo5InformationBox::NoTimeout);
        ui->label->setText("");
        ui->fraBar->setVisible(false);
        ui->frame->setVisible(true);
        ui->fraInfo->setVisible(true);
        setButtons(true);
    }

    tcpClient.close();

}



void WoLAN::on_butAdd_clicked()
{
    clsHost *tg;
    if (bEditMode || bAddMode)  // not Add but Save
    {
        SetInterfaceMode(false);
        if (!bAddMode)
        {
            tg=tgList.lstTarget.at(iCurrentTarget);
        }
        else
        {
            tg = new clsHost;
            tgList.lstTarget.append(tg);
            iCurrentTarget=tgList.lstTarget.size()-1;
        }
        tg->sIP=ui->lIP->text();
        tg->sMAC=ui->lMAC->text();
        tg->iPort=ui->lPort->text().toInt();
        tg->itcpPort=ui->ltcpPort->text().toInt();
        tg->iTimeOut=ui->lTimeOut->text().toInt();
        tgList.saveToFile();
        bAddMode=false;
        bEditMode=false;
        DisplayTarget (iCurrentTarget);
    }
    else // Insert a target
    {
        bAddMode= true;
        DisplayTarget(-1);
        SetInterfaceMode(true);
        ui->lIP->setFocus();
    }

}


void WoLAN::on_butEdit_clicked()
{
    bEditMode=true;
    SetInterfaceMode(true);
}

void WoLAN::DisplayTarget(int iTg)
{
    clsHost *tg;

    if (iTg!=-1)
    {
        tg=tgList.lstTarget.at(iTg);
        ui->lIP->setText(tg->sIP);
        ui->lMAC->setText(tg->sMAC);
        ui->lPort->setText(QString::number(tg->iPort));
        ui->ltcpPort->setText(QString::number(tg->itcpPort));
        ui->lTimeOut->setText(QString::number(tg->iTimeOut));
    } else
    {
        ui->lIP->setText("");
        ui->lMAC->setText("");
        ui->lPort->setText("");
        ui->ltcpPort->setText("");
        ui->lTimeOut->setText("");
    }
    ui->labPos->setText(QString::number(iTg+1) + "/" + QString::number(tgList.lstTarget.size()));
    ui->butNext->setEnabled(iTg < tgList.lstTarget.size()-1);
    ui->butPrev->setEnabled( iTg!=0 && iTg !=-1 );

    ui->butEdit->setEnabled(tgList.lstTarget.size()!=0);
    ui->butDel->setEnabled(tgList.lstTarget.size()!=0);
    ui->label->setText("");
}

void WoLAN::on_butDel_clicked()
{
    if (bEditMode or bAddMode)  // not del but cancel
    {
        SetInterfaceMode(false);
        DisplayTarget(iCurrentTarget);
        bEditMode=false;
        bAddMode=false;
    }
    else // delete a target
    {
        tgList.lstTarget.removeAt(iCurrentTarget);
        if (tgList.lstTarget.size()==0)
            iCurrentTarget=-1;
        else if (iCurrentTarget>0)
            --iCurrentTarget;
        tgList.saveToFile();
        DisplayTarget(iCurrentTarget);
    }

}

void WoLAN::setButtons(bool bEnabled)
{
    ui->pushButton->setEnabled(bEnabled);
    ui->butAdd->setEnabled(bEnabled);
    ui->butEdit->setEnabled(bEnabled);
    ui->butDel->setEnabled(bEnabled);
    ui->butNext->setEnabled((iCurrentTarget < tgList.lstTarget.size()-1) && bEnabled);
    ui->butPrev->setEnabled(( iCurrentTarget!=0 && iCurrentTarget !=-1 ) && bEnabled);
}

void WoLAN::SetInterfaceMode(bool bEdit)
{
    // bEdit = true -> edit/add mode
    ui->butEdit->setEnabled(!bEdit);
    ui->lIP->setReadOnly(!bEdit);
    ui->lMAC->setReadOnly(!bEdit);
    ui->lPort->setReadOnly(!bEdit);
    ui->ltcpPort->setReadOnly(!bEdit);
    ui->lTimeOut->setReadOnly(!bEdit);
    if (bEdit)
    {
        ui->butAdd->setText("Save");
        ui->butDel->setText("Cancel");
    }else
    {
        ui->butAdd->setText("Add");
        ui->butDel->setText("Del");
    }

    ui->butNext->setEnabled(!bEdit);
    ui->butPrev->setEnabled(!bEdit);
    ui->pushButton->setEnabled(!bEdit);
    //ui->lIP->setFocus();
}

void WoLAN::on_butPrev_clicked()
{
    DisplayTarget(--iCurrentTarget);
}

void WoLAN::on_butNext_clicked()
{
    DisplayTarget(++iCurrentTarget);
}
