#include "wolan.h"
#include "ui_wolan.h"
#include <QtNetwork>
#include <QtGui>
#include <QDataStream>
#include <QFile>

WoLAN::WoLAN(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::WoLAN)
{
    ui->setupUi(this);
     qDebug() << "Open input file";
     QString sFilename;

     sFilename = QDir().homePath();
     sFilename.append("/.WoLAN.conf");
     QFile file(sFilename);
     if (file.open(QIODevice::ReadOnly | QIODevice::Text))
     {
         QTextStream in(&file);
         ui->lIP->setText(in.readLine());
         ui->lMAC->setText(in.readLine());
         ui->lPort->setText(in.readLine());
     }
     else
     {
         qDebug()<< "file does not exist";
     }



}

WoLAN::~WoLAN()
{
    qDebug() <<"open output file";
    QString sFilename;

    sFilename = QDir().homePath();
    sFilename.append("/.WoLAN.conf");

    QFile file(sFilename);
    if (file.open(QIODevice::WriteOnly | QIODevice::Truncate | QIODevice::Text))
    {
        QTextStream out(&file);
        out << ui->lIP->text() << "\n";
        out << ui->lMAC->text() << "\n";
        out << ui->lPort->text()<< "\n";
    }
    delete ui;
}



void WoLAN::on_pushButton_clicked()
{
    /*
    tcpClient.connectToHost(QHostAddress(ui->lIP->text()), ui->lPort->text().toInt());
    connect(&tcpClient, SIGNAL(connected()), this, SLOT(startTransfer()));
    connect(&tcpClient, SIGNAL(readyRead()), this, SLOT(readReply()));
    connect(&tcpClient, SIGNAL(error(QAbstractSocket::SocketError)),
            this, SLOT(displayError(QAbstractSocket::SocketError)));
    */
    QString sMsg;
    /*
import socket

s=socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
s.setsockopt(socket.SOL_SOCKET, socket.SO_BROADCAST, 1)
s.sendto('\xff'*6+'\x00\xc0\x9f\x2b\xa5\x97'*16, ("wushu.zapto.org",9))
*/
    int i,j;
    bool b;
    ui->pushButton->setEnabled(false);
    QByteArray bMsg;
    for (i=0;i<=5;i++)
        bMsg.append("\xff");
    for (i=0;i<=15;i++)
        for (j=0;j<17;j+=3)
            bMsg.append(ui->lMAC->text().mid(j,2).toInt(&b,16));

    //<<QByteArray(16,ui->lMAC->text());

    udpSocket.writeDatagram(bMsg,QHostAddress(ui->lIP->text()), ui->lPort->text().toInt());
    ui->label->setText("Sent at " +  QTime::currentTime().toString("hh:mm:ss"));
    ui->pushButton->setEnabled(true);
}
void WoLAN::startTransfer()
{
    qDebug() <<"Connected";

    //    tcpClient.write("admin");
    ui->label->setText(tr("Connected"));
}

void WoLAN::readReply()
{
    QString qBuf;
    qBuf=tcpClient.readAll();
    qDebug() << "ReadReply" << qBuf;
    ui->label->setText(qBuf);
    if (qBuf.contains("Login: "))
    {
        qDebug() << "Please login";
        tcpClient.write ("admin\n");
    }
    else if (qBuf.contains("Password: "))
    {
        qDebug() << "Enter your pwd";
        tcpClient.write ("jockoca\n");

    }
    else if (qBuf.contains("> "))
    {
        tcpClient.write ("reboot\n");
    }

 }

void WoLAN::displayError(QAbstractSocket::SocketError socketError)
{
    if (socketError == QTcpSocket::RemoteHostClosedError)
        return;

    QMessageBox::information(this, tr("Network error"),tr("The following error occurred: %1.").arg(tcpClient.errorString()));

    tcpClient.close();
  }
