/* File generated automatically from tools/winapi/tests.dat; do not edit! */
/* This file can be copied, modified and distributed without restriction. */

/*
 * Unit tests for data structure packing
 */

#define WINVER 0x0501
#define _WIN32_IE 0x0501
#define _WIN32_WINNT 0x0501

#define WINE_NOWINSOCK

#include <stdarg.h>
#include "windef.h"
#include "winbase.h"
#include "rpc.h"
#include "rpcndr.h"
#include "rpcproxy.h"

#include "wine/test.h"

/***********************************************************************
 * Compatibility macros
 */

#define DWORD_PTR UINT_PTR
#define LONG_PTR INT_PTR
#define ULONG_PTR UINT_PTR

/***********************************************************************
 * Windows API extension
 */

#if defined(_MSC_VER) && (_MSC_VER >= 1300) && defined(__cplusplus)
# define _TYPE_ALIGNMENT(type) __alignof(type)
#elif defined(__GNUC__)
# define _TYPE_ALIGNMENT(type) __alignof__(type)
#else
/*
 * FIXME: May not be possible without a compiler extension
 *        (if type is not just a name that is, otherwise the normal
 *         TYPE_ALIGNMENT can be used)
 */
#endif

#if defined(TYPE_ALIGNMENT) && defined(_MSC_VER) && _MSC_VER >= 800 && !defined(__cplusplus)
#pragma warning(disable:4116)
#endif

#if !defined(TYPE_ALIGNMENT) && defined(_TYPE_ALIGNMENT)
# define TYPE_ALIGNMENT _TYPE_ALIGNMENT
#endif

/***********************************************************************
 * Test helper macros
 */

#define TEST_TYPE_SIZE(type, size)             C_ASSERT(sizeof(type) == size);

#ifdef TYPE_ALIGNMENT
# define TEST_TYPE_ALIGN(type, align)          C_ASSERT(TYPE_ALIGNMENT(type) == align);
#else
# define TEST_TYPE_ALIGN(type, align)
#endif

#ifdef _TYPE_ALIGNMENT
# define TEST_TARGET_ALIGN(type, align)        C_ASSERT(_TYPE_ALIGNMENT(*(type)0) == align);
# define TEST_FIELD_ALIGN(type, field, align)  C_ASSERT(_TYPE_ALIGNMENT(((type*)0)->field) == align);
#else
# define TEST_TARGET_ALIGN(type, align)
# define TEST_FIELD_ALIGN(type, field, align)
#endif

#define TEST_FIELD_OFFSET(type, field, offset) C_ASSERT(FIELD_OFFSET(type, field) == offset);

#define TEST_TARGET_SIZE(type, size)            TEST_TYPE_SIZE(*(type)0, size)
#define TEST_FIELD_SIZE(type, field, size)      TEST_TYPE_SIZE((((type*)0)->field), size)
#define TEST_TYPE_SIGNED(type)                  C_ASSERT((type) -1 < 0);
#define TEST_TYPE_UNSIGNED(type)                C_ASSERT((type) -1 > 0);


#ifdef _WIN64

static void test_pack_I_RPC_HANDLE(void)
{
    /* I_RPC_HANDLE */
    TEST_TYPE_SIZE   (I_RPC_HANDLE, 8)
    TEST_TYPE_ALIGN  (I_RPC_HANDLE, 8)
}

static void test_pack_RPC_STATUS(void)
{
    /* RPC_STATUS */
    TEST_TYPE_SIZE   (RPC_STATUS, 4)
    TEST_TYPE_ALIGN  (RPC_STATUS, 4)
}

static void test_pack_PRPC_POLICY(void)
{
    /* PRPC_POLICY */
    TEST_TYPE_SIZE   (PRPC_POLICY, 8)
    TEST_TYPE_ALIGN  (PRPC_POLICY, 8)
    TEST_TARGET_SIZE (PRPC_POLICY, 12)
    TEST_TARGET_ALIGN(PRPC_POLICY, 4)
}

static void test_pack_RPC_AUTH_IDENTITY_HANDLE(void)
{
    /* RPC_AUTH_IDENTITY_HANDLE */
    TEST_TYPE_SIZE   (RPC_AUTH_IDENTITY_HANDLE, 8)
    TEST_TYPE_ALIGN  (RPC_AUTH_IDENTITY_HANDLE, 8)
}

static void test_pack_RPC_AUTH_KEY_RETRIEVAL_FN(void)
{
    /* RPC_AUTH_KEY_RETRIEVAL_FN */
}

static void test_pack_RPC_AUTHZ_HANDLE(void)
{
    /* RPC_AUTHZ_HANDLE */
    TEST_TYPE_SIZE   (RPC_AUTHZ_HANDLE, 8)
    TEST_TYPE_ALIGN  (RPC_AUTHZ_HANDLE, 8)
}

static void test_pack_RPC_BINDING_HANDLE(void)
{
    /* RPC_BINDING_HANDLE */
    TEST_TYPE_SIZE   (RPC_BINDING_HANDLE, 8)
    TEST_TYPE_ALIGN  (RPC_BINDING_HANDLE, 8)
}

static void test_pack_RPC_BINDING_VECTOR(void)
{
    /* RPC_BINDING_VECTOR */
    TEST_TYPE_SIZE   (RPC_BINDING_VECTOR, 16)
    TEST_TYPE_ALIGN  (RPC_BINDING_VECTOR, 8)
    TEST_FIELD_SIZE  (RPC_BINDING_VECTOR, Count, 4)
    TEST_FIELD_ALIGN (RPC_BINDING_VECTOR, Count, 4)
    TEST_FIELD_OFFSET(RPC_BINDING_VECTOR, Count, 0)
    TEST_FIELD_SIZE  (RPC_BINDING_VECTOR, BindingH, 8)
    TEST_FIELD_ALIGN (RPC_BINDING_VECTOR, BindingH, 8)
    TEST_FIELD_OFFSET(RPC_BINDING_VECTOR, BindingH, 8)
}

static void test_pack_RPC_IF_HANDLE(void)
{
    /* RPC_IF_HANDLE */
    TEST_TYPE_SIZE   (RPC_IF_HANDLE, 8)
    TEST_TYPE_ALIGN  (RPC_IF_HANDLE, 8)
}

static void test_pack_RPC_IF_ID(void)
{
    /* RPC_IF_ID */
    TEST_TYPE_SIZE   (RPC_IF_ID, 20)
    TEST_TYPE_ALIGN  (RPC_IF_ID, 4)
    TEST_FIELD_SIZE  (RPC_IF_ID, Uuid, 16)
    TEST_FIELD_ALIGN (RPC_IF_ID, Uuid, 4)
    TEST_FIELD_OFFSET(RPC_IF_ID, Uuid, 0)
    TEST_FIELD_SIZE  (RPC_IF_ID, VersMajor, 2)
    TEST_FIELD_ALIGN (RPC_IF_ID, VersMajor, 2)
    TEST_FIELD_OFFSET(RPC_IF_ID, VersMajor, 16)
    TEST_FIELD_SIZE  (RPC_IF_ID, VersMinor, 2)
    TEST_FIELD_ALIGN (RPC_IF_ID, VersMinor, 2)
    TEST_FIELD_OFFSET(RPC_IF_ID, VersMinor, 18)
}

static void test_pack_RPC_POLICY(void)
{
    /* RPC_POLICY */
    TEST_TYPE_SIZE   (RPC_POLICY, 12)
    TEST_TYPE_ALIGN  (RPC_POLICY, 4)
    TEST_FIELD_SIZE  (RPC_POLICY, Length, 4)
    TEST_FIELD_ALIGN (RPC_POLICY, Length, 4)
    TEST_FIELD_OFFSET(RPC_POLICY, Length, 0)
    TEST_FIELD_SIZE  (RPC_POLICY, EndpointFlags, 4)
    TEST_FIELD_ALIGN (RPC_POLICY, EndpointFlags, 4)
    TEST_FIELD_OFFSET(RPC_POLICY, EndpointFlags, 4)
    TEST_FIELD_SIZE  (RPC_POLICY, NICFlags, 4)
    TEST_FIELD_ALIGN (RPC_POLICY, NICFlags, 4)
    TEST_FIELD_OFFSET(RPC_POLICY, NICFlags, 8)
}

static void test_pack_UUID_VECTOR(void)
{
    /* UUID_VECTOR */
    TEST_TYPE_SIZE   (UUID_VECTOR, 16)
    TEST_TYPE_ALIGN  (UUID_VECTOR, 8)
    TEST_FIELD_SIZE  (UUID_VECTOR, Count, 4)
    TEST_FIELD_ALIGN (UUID_VECTOR, Count, 4)
    TEST_FIELD_OFFSET(UUID_VECTOR, Count, 0)
    TEST_FIELD_SIZE  (UUID_VECTOR, Uuid, 8)
    TEST_FIELD_ALIGN (UUID_VECTOR, Uuid, 8)
    TEST_FIELD_OFFSET(UUID_VECTOR, Uuid, 8)
}

static void test_pack_PRPC_CLIENT_INTERFACE(void)
{
    /* PRPC_CLIENT_INTERFACE */
    TEST_TYPE_SIZE   (PRPC_CLIENT_INTERFACE, 8)
    TEST_TYPE_ALIGN  (PRPC_CLIENT_INTERFACE, 8)
    TEST_TARGET_SIZE (PRPC_CLIENT_INTERFACE, 96)
    TEST_TARGET_ALIGN(PRPC_CLIENT_INTERFACE, 8)
}

static void test_pack_PRPC_DISPATCH_TABLE(void)
{
    /* PRPC_DISPATCH_TABLE */
    TEST_TYPE_SIZE   (PRPC_DISPATCH_TABLE, 8)
    TEST_TYPE_ALIGN  (PRPC_DISPATCH_TABLE, 8)
    TEST_TARGET_SIZE (PRPC_DISPATCH_TABLE, 24)
    TEST_TARGET_ALIGN(PRPC_DISPATCH_TABLE, 8)
}

static void test_pack_PRPC_MESSAGE(void)
{
    /* PRPC_MESSAGE */
    TEST_TYPE_SIZE   (PRPC_MESSAGE, 8)
    TEST_TYPE_ALIGN  (PRPC_MESSAGE, 8)
    TEST_TARGET_SIZE (PRPC_MESSAGE, 80)
    TEST_TARGET_ALIGN(PRPC_MESSAGE, 8)
}

static void test_pack_PRPC_PROTSEQ_ENDPOINT(void)
{
    /* PRPC_PROTSEQ_ENDPOINT */
    TEST_TYPE_SIZE   (PRPC_PROTSEQ_ENDPOINT, 8)
    TEST_TYPE_ALIGN  (PRPC_PROTSEQ_ENDPOINT, 8)
    TEST_TARGET_SIZE (PRPC_PROTSEQ_ENDPOINT, 16)
    TEST_TARGET_ALIGN(PRPC_PROTSEQ_ENDPOINT, 8)
}

static void test_pack_PRPC_SERVER_INTERFACE(void)
{
    /* PRPC_SERVER_INTERFACE */
    TEST_TYPE_SIZE   (PRPC_SERVER_INTERFACE, 8)
    TEST_TYPE_ALIGN  (PRPC_SERVER_INTERFACE, 8)
    TEST_TARGET_SIZE (PRPC_SERVER_INTERFACE, 96)
    TEST_TARGET_ALIGN(PRPC_SERVER_INTERFACE, 8)
}

static void test_pack_PRPC_SYNTAX_IDENTIFIER(void)
{
    /* PRPC_SYNTAX_IDENTIFIER */
    TEST_TYPE_SIZE   (PRPC_SYNTAX_IDENTIFIER, 8)
    TEST_TYPE_ALIGN  (PRPC_SYNTAX_IDENTIFIER, 8)
    TEST_TARGET_SIZE (PRPC_SYNTAX_IDENTIFIER, 20)
    TEST_TARGET_ALIGN(PRPC_SYNTAX_IDENTIFIER, 4)
}

static void test_pack_RPC_CLIENT_INTERFACE(void)
{
    /* RPC_CLIENT_INTERFACE */
    TEST_TYPE_SIZE   (RPC_CLIENT_INTERFACE, 96)
    TEST_TYPE_ALIGN  (RPC_CLIENT_INTERFACE, 8)
    TEST_FIELD_SIZE  (RPC_CLIENT_INTERFACE, Length, 4)
    TEST_FIELD_ALIGN (RPC_CLIENT_INTERFACE, Length, 4)
    TEST_FIELD_OFFSET(RPC_CLIENT_INTERFACE, Length, 0)
    TEST_FIELD_SIZE  (RPC_CLIENT_INTERFACE, InterfaceId, 20)
    TEST_FIELD_ALIGN (RPC_CLIENT_INTERFACE, InterfaceId, 4)
    TEST_FIELD_OFFSET(RPC_CLIENT_INTERFACE, InterfaceId, 4)
    TEST_FIELD_SIZE  (RPC_CLIENT_INTERFACE, TransferSyntax, 20)
    TEST_FIELD_ALIGN (RPC_CLIENT_INTERFACE, TransferSyntax, 4)
    TEST_FIELD_OFFSET(RPC_CLIENT_INTERFACE, TransferSyntax, 24)
    TEST_FIELD_SIZE  (RPC_CLIENT_INTERFACE, DispatchTable, 8)
    TEST_FIELD_ALIGN (RPC_CLIENT_INTERFACE, DispatchTable, 8)
    TEST_FIELD_OFFSET(RPC_CLIENT_INTERFACE, DispatchTable, 48)
    TEST_FIELD_SIZE  (RPC_CLIENT_INTERFACE, RpcProtseqEndpointCount, 4)
    TEST_FIELD_ALIGN (RPC_CLIENT_INTERFACE, RpcProtseqEndpointCount, 4)
    TEST_FIELD_OFFSET(RPC_CLIENT_INTERFACE, RpcProtseqEndpointCount, 56)
    TEST_FIELD_SIZE  (RPC_CLIENT_INTERFACE, RpcProtseqEndpoint, 8)
    TEST_FIELD_ALIGN (RPC_CLIENT_INTERFACE, RpcProtseqEndpoint, 8)
    TEST_FIELD_OFFSET(RPC_CLIENT_INTERFACE, RpcProtseqEndpoint, 64)
    TEST_FIELD_SIZE  (RPC_CLIENT_INTERFACE, Reserved, 8)
    TEST_FIELD_ALIGN (RPC_CLIENT_INTERFACE, Reserved, 8)
    TEST_FIELD_OFFSET(RPC_CLIENT_INTERFACE, Reserved, 72)
    TEST_FIELD_SIZE  (RPC_CLIENT_INTERFACE, InterpreterInfo, 8)
    TEST_FIELD_ALIGN (RPC_CLIENT_INTERFACE, InterpreterInfo, 8)
    TEST_FIELD_OFFSET(RPC_CLIENT_INTERFACE, InterpreterInfo, 80)
    TEST_FIELD_SIZE  (RPC_CLIENT_INTERFACE, Flags, 4)
    TEST_FIELD_ALIGN (RPC_CLIENT_INTERFACE, Flags, 4)
    TEST_FIELD_OFFSET(RPC_CLIENT_INTERFACE, Flags, 88)
}

static void test_pack_RPC_DISPATCH_FUNCTION(void)
{
    /* RPC_DISPATCH_FUNCTION */
}

static void test_pack_RPC_DISPATCH_TABLE(void)
{
    /* RPC_DISPATCH_TABLE */
    TEST_TYPE_SIZE   (RPC_DISPATCH_TABLE, 24)
    TEST_TYPE_ALIGN  (RPC_DISPATCH_TABLE, 8)
    TEST_FIELD_SIZE  (RPC_DISPATCH_TABLE, DispatchTableCount, 4)
    TEST_FIELD_ALIGN (RPC_DISPATCH_TABLE, DispatchTableCount, 4)
    TEST_FIELD_OFFSET(RPC_DISPATCH_TABLE, DispatchTableCount, 0)
    TEST_FIELD_SIZE  (RPC_DISPATCH_TABLE, DispatchTable, 8)
    TEST_FIELD_ALIGN (RPC_DISPATCH_TABLE, DispatchTable, 8)
    TEST_FIELD_OFFSET(RPC_DISPATCH_TABLE, DispatchTable, 8)
    TEST_FIELD_SIZE  (RPC_DISPATCH_TABLE, Reserved, 8)
    TEST_FIELD_ALIGN (RPC_DISPATCH_TABLE, Reserved, 8)
    TEST_FIELD_OFFSET(RPC_DISPATCH_TABLE, Reserved, 16)
}

static void test_pack_RPC_MESSAGE(void)
{
    /* RPC_MESSAGE */
    TEST_TYPE_SIZE   (RPC_MESSAGE, 80)
    TEST_TYPE_ALIGN  (RPC_MESSAGE, 8)
    TEST_FIELD_SIZE  (RPC_MESSAGE, Handle, 8)
    TEST_FIELD_ALIGN (RPC_MESSAGE, Handle, 8)
    TEST_FIELD_OFFSET(RPC_MESSAGE, Handle, 0)
    TEST_FIELD_SIZE  (RPC_MESSAGE, DataRepresentation, 4)
    TEST_FIELD_ALIGN (RPC_MESSAGE, DataRepresentation, 4)
    TEST_FIELD_OFFSET(RPC_MESSAGE, DataRepresentation, 8)
    TEST_FIELD_SIZE  (RPC_MESSAGE, Buffer, 8)
    TEST_FIELD_ALIGN (RPC_MESSAGE, Buffer, 8)
    TEST_FIELD_OFFSET(RPC_MESSAGE, Buffer, 16)
    TEST_FIELD_SIZE  (RPC_MESSAGE, BufferLength, 4)
    TEST_FIELD_ALIGN (RPC_MESSAGE, BufferLength, 4)
    TEST_FIELD_OFFSET(RPC_MESSAGE, BufferLength, 24)
    TEST_FIELD_SIZE  (RPC_MESSAGE, ProcNum, 4)
    TEST_FIELD_ALIGN (RPC_MESSAGE, ProcNum, 4)
    TEST_FIELD_OFFSET(RPC_MESSAGE, ProcNum, 28)
    TEST_FIELD_SIZE  (RPC_MESSAGE, TransferSyntax, 8)
    TEST_FIELD_ALIGN (RPC_MESSAGE, TransferSyntax, 8)
    TEST_FIELD_OFFSET(RPC_MESSAGE, TransferSyntax, 32)
    TEST_FIELD_SIZE  (RPC_MESSAGE, RpcInterfaceInformation, 8)
    TEST_FIELD_ALIGN (RPC_MESSAGE, RpcInterfaceInformation, 8)
    TEST_FIELD_OFFSET(RPC_MESSAGE, RpcInterfaceInformation, 40)
    TEST_FIELD_SIZE  (RPC_MESSAGE, ReservedForRuntime, 8)
    TEST_FIELD_ALIGN (RPC_MESSAGE, ReservedForRuntime, 8)
    TEST_FIELD_OFFSET(RPC_MESSAGE, ReservedForRuntime, 48)
    TEST_FIELD_SIZE  (RPC_MESSAGE, ManagerEpv, 8)
    TEST_FIELD_ALIGN (RPC_MESSAGE, ManagerEpv, 8)
    TEST_FIELD_OFFSET(RPC_MESSAGE, ManagerEpv, 56)
    TEST_FIELD_SIZE  (RPC_MESSAGE, ImportContext, 8)
    TEST_FIELD_ALIGN (RPC_MESSAGE, ImportContext, 8)
    TEST_FIELD_OFFSET(RPC_MESSAGE, ImportContext, 64)
    TEST_FIELD_SIZE  (RPC_MESSAGE, RpcFlags, 4)
    TEST_FIELD_ALIGN (RPC_MESSAGE, RpcFlags, 4)
    TEST_FIELD_OFFSET(RPC_MESSAGE, RpcFlags, 72)
}

static void test_pack_RPC_PROTSEQ_ENDPOINT(void)
{
    /* RPC_PROTSEQ_ENDPOINT */
    TEST_TYPE_SIZE   (RPC_PROTSEQ_ENDPOINT, 16)
    TEST_TYPE_ALIGN  (RPC_PROTSEQ_ENDPOINT, 8)
    TEST_FIELD_SIZE  (RPC_PROTSEQ_ENDPOINT, RpcProtocolSequence, 8)
    TEST_FIELD_ALIGN (RPC_PROTSEQ_ENDPOINT, RpcProtocolSequence, 8)
    TEST_FIELD_OFFSET(RPC_PROTSEQ_ENDPOINT, RpcProtocolSequence, 0)
    TEST_FIELD_SIZE  (RPC_PROTSEQ_ENDPOINT, Endpoint, 8)
    TEST_FIELD_ALIGN (RPC_PROTSEQ_ENDPOINT, Endpoint, 8)
    TEST_FIELD_OFFSET(RPC_PROTSEQ_ENDPOINT, Endpoint, 8)
}

static void test_pack_RPC_SERVER_INTERFACE(void)
{
    /* RPC_SERVER_INTERFACE */
    TEST_TYPE_SIZE   (RPC_SERVER_INTERFACE, 96)
    TEST_TYPE_ALIGN  (RPC_SERVER_INTERFACE, 8)
    TEST_FIELD_SIZE  (RPC_SERVER_INTERFACE, Length, 4)
    TEST_FIELD_ALIGN (RPC_SERVER_INTERFACE, Length, 4)
    TEST_FIELD_OFFSET(RPC_SERVER_INTERFACE, Length, 0)
    TEST_FIELD_SIZE  (RPC_SERVER_INTERFACE, InterfaceId, 20)
    TEST_FIELD_ALIGN (RPC_SERVER_INTERFACE, InterfaceId, 4)
    TEST_FIELD_OFFSET(RPC_SERVER_INTERFACE, InterfaceId, 4)
    TEST_FIELD_SIZE  (RPC_SERVER_INTERFACE, TransferSyntax, 20)
    TEST_FIELD_ALIGN (RPC_SERVER_INTERFACE, TransferSyntax, 4)
    TEST_FIELD_OFFSET(RPC_SERVER_INTERFACE, TransferSyntax, 24)
    TEST_FIELD_SIZE  (RPC_SERVER_INTERFACE, DispatchTable, 8)
    TEST_FIELD_ALIGN (RPC_SERVER_INTERFACE, DispatchTable, 8)
    TEST_FIELD_OFFSET(RPC_SERVER_INTERFACE, DispatchTable, 48)
    TEST_FIELD_SIZE  (RPC_SERVER_INTERFACE, RpcProtseqEndpointCount, 4)
    TEST_FIELD_ALIGN (RPC_SERVER_INTERFACE, RpcProtseqEndpointCount, 4)
    TEST_FIELD_OFFSET(RPC_SERVER_INTERFACE, RpcProtseqEndpointCount, 56)
    TEST_FIELD_SIZE  (RPC_SERVER_INTERFACE, RpcProtseqEndpoint, 8)
    TEST_FIELD_ALIGN (RPC_SERVER_INTERFACE, RpcProtseqEndpoint, 8)
    TEST_FIELD_OFFSET(RPC_SERVER_INTERFACE, RpcProtseqEndpoint, 64)
    TEST_FIELD_SIZE  (RPC_SERVER_INTERFACE, DefaultManagerEpv, 8)
    TEST_FIELD_ALIGN (RPC_SERVER_INTERFACE, DefaultManagerEpv, 8)
    TEST_FIELD_OFFSET(RPC_SERVER_INTERFACE, DefaultManagerEpv, 72)
    TEST_FIELD_SIZE  (RPC_SERVER_INTERFACE, InterpreterInfo, 8)
    TEST_FIELD_ALIGN (RPC_SERVER_INTERFACE, InterpreterInfo, 8)
    TEST_FIELD_OFFSET(RPC_SERVER_INTERFACE, InterpreterInfo, 80)
    TEST_FIELD_SIZE  (RPC_SERVER_INTERFACE, Flags, 4)
    TEST_FIELD_ALIGN (RPC_SERVER_INTERFACE, Flags, 4)
    TEST_FIELD_OFFSET(RPC_SERVER_INTERFACE, Flags, 88)
}

static void test_pack_RPC_SYNTAX_IDENTIFIER(void)
{
    /* RPC_SYNTAX_IDENTIFIER */
    TEST_TYPE_SIZE   (RPC_SYNTAX_IDENTIFIER, 20)
    TEST_TYPE_ALIGN  (RPC_SYNTAX_IDENTIFIER, 4)
    TEST_FIELD_SIZE  (RPC_SYNTAX_IDENTIFIER, SyntaxGUID, 16)
    TEST_FIELD_ALIGN (RPC_SYNTAX_IDENTIFIER, SyntaxGUID, 4)
    TEST_FIELD_OFFSET(RPC_SYNTAX_IDENTIFIER, SyntaxGUID, 0)
    TEST_FIELD_SIZE  (RPC_SYNTAX_IDENTIFIER, SyntaxVersion, 4)
    TEST_FIELD_ALIGN (RPC_SYNTAX_IDENTIFIER, SyntaxVersion, 2)
    TEST_FIELD_OFFSET(RPC_SYNTAX_IDENTIFIER, SyntaxVersion, 16)
}

static void test_pack_RPC_VERSION(void)
{
    /* RPC_VERSION */
    TEST_TYPE_SIZE   (RPC_VERSION, 4)
    TEST_TYPE_ALIGN  (RPC_VERSION, 2)
    TEST_FIELD_SIZE  (RPC_VERSION, MajorVersion, 2)
    TEST_FIELD_ALIGN (RPC_VERSION, MajorVersion, 2)
    TEST_FIELD_OFFSET(RPC_VERSION, MajorVersion, 0)
    TEST_FIELD_SIZE  (RPC_VERSION, MinorVersion, 2)
    TEST_FIELD_ALIGN (RPC_VERSION, MinorVersion, 2)
    TEST_FIELD_OFFSET(RPC_VERSION, MinorVersion, 2)
}

static void test_pack_ARRAY_INFO(void)
{
    /* ARRAY_INFO */
    TEST_TYPE_SIZE   (ARRAY_INFO, 48)
    TEST_TYPE_ALIGN  (ARRAY_INFO, 8)
    TEST_FIELD_SIZE  (ARRAY_INFO, Dimension, 4)
    TEST_FIELD_ALIGN (ARRAY_INFO, Dimension, 4)
    TEST_FIELD_OFFSET(ARRAY_INFO, Dimension, 0)
    TEST_FIELD_SIZE  (ARRAY_INFO, BufferConformanceMark, 8)
    TEST_FIELD_ALIGN (ARRAY_INFO, BufferConformanceMark, 8)
    TEST_FIELD_OFFSET(ARRAY_INFO, BufferConformanceMark, 8)
    TEST_FIELD_SIZE  (ARRAY_INFO, BufferVarianceMark, 8)
    TEST_FIELD_ALIGN (ARRAY_INFO, BufferVarianceMark, 8)
    TEST_FIELD_OFFSET(ARRAY_INFO, BufferVarianceMark, 16)
    TEST_FIELD_SIZE  (ARRAY_INFO, MaxCountArray, 8)
    TEST_FIELD_ALIGN (ARRAY_INFO, MaxCountArray, 8)
    TEST_FIELD_OFFSET(ARRAY_INFO, MaxCountArray, 24)
    TEST_FIELD_SIZE  (ARRAY_INFO, OffsetArray, 8)
    TEST_FIELD_ALIGN (ARRAY_INFO, OffsetArray, 8)
    TEST_FIELD_OFFSET(ARRAY_INFO, OffsetArray, 32)
    TEST_FIELD_SIZE  (ARRAY_INFO, ActualCountArray, 8)
    TEST_FIELD_ALIGN (ARRAY_INFO, ActualCountArray, 8)
    TEST_FIELD_OFFSET(ARRAY_INFO, ActualCountArray, 40)
}

static void test_pack_COMM_FAULT_OFFSETS(void)
{
    /* COMM_FAULT_OFFSETS */
    TEST_TYPE_SIZE   (COMM_FAULT_OFFSETS, 4)
    TEST_TYPE_ALIGN  (COMM_FAULT_OFFSETS, 2)
    TEST_FIELD_SIZE  (COMM_FAULT_OFFSETS, CommOffset, 2)
    TEST_FIELD_ALIGN (COMM_FAULT_OFFSETS, CommOffset, 2)
    TEST_FIELD_OFFSET(COMM_FAULT_OFFSETS, CommOffset, 0)
    TEST_FIELD_SIZE  (COMM_FAULT_OFFSETS, FaultOffset, 2)
    TEST_FIELD_ALIGN (COMM_FAULT_OFFSETS, FaultOffset, 2)
    TEST_FIELD_OFFSET(COMM_FAULT_OFFSETS, FaultOffset, 2)
}

static void test_pack_CS_STUB_INFO(void)
{
    /* CS_STUB_INFO */
    TEST_TYPE_SIZE   (CS_STUB_INFO, 16)
    TEST_TYPE_ALIGN  (CS_STUB_INFO, 8)
    TEST_FIELD_SIZE  (CS_STUB_INFO, WireCodeset, 4)
    TEST_FIELD_ALIGN (CS_STUB_INFO, WireCodeset, 4)
    TEST_FIELD_OFFSET(CS_STUB_INFO, WireCodeset, 0)
    TEST_FIELD_SIZE  (CS_STUB_INFO, DesiredReceivingCodeset, 4)
    TEST_FIELD_ALIGN (CS_STUB_INFO, DesiredReceivingCodeset, 4)
    TEST_FIELD_OFFSET(CS_STUB_INFO, DesiredReceivingCodeset, 4)
    TEST_FIELD_SIZE  (CS_STUB_INFO, CSArrayInfo, 8)
    TEST_FIELD_ALIGN (CS_STUB_INFO, CSArrayInfo, 8)
    TEST_FIELD_OFFSET(CS_STUB_INFO, CSArrayInfo, 8)
}

static void test_pack_EXPR_EVAL(void)
{
    /* EXPR_EVAL */
}

static void test_pack_FULL_PTR_TO_REFID_ELEMENT(void)
{
    /* FULL_PTR_TO_REFID_ELEMENT */
    TEST_TYPE_SIZE   (FULL_PTR_TO_REFID_ELEMENT, 24)
    TEST_TYPE_ALIGN  (FULL_PTR_TO_REFID_ELEMENT, 8)
    TEST_FIELD_SIZE  (FULL_PTR_TO_REFID_ELEMENT, Next, 8)
    TEST_FIELD_ALIGN (FULL_PTR_TO_REFID_ELEMENT, Next, 8)
    TEST_FIELD_OFFSET(FULL_PTR_TO_REFID_ELEMENT, Next, 0)
    TEST_FIELD_SIZE  (FULL_PTR_TO_REFID_ELEMENT, Pointer, 8)
    TEST_FIELD_ALIGN (FULL_PTR_TO_REFID_ELEMENT, Pointer, 8)
    TEST_FIELD_OFFSET(FULL_PTR_TO_REFID_ELEMENT, Pointer, 8)
    TEST_FIELD_SIZE  (FULL_PTR_TO_REFID_ELEMENT, RefId, 4)
    TEST_FIELD_ALIGN (FULL_PTR_TO_REFID_ELEMENT, RefId, 4)
    TEST_FIELD_OFFSET(FULL_PTR_TO_REFID_ELEMENT, RefId, 16)
    TEST_FIELD_SIZE  (FULL_PTR_TO_REFID_ELEMENT, State, 1)
    TEST_FIELD_ALIGN (FULL_PTR_TO_REFID_ELEMENT, State, 1)
    TEST_FIELD_OFFSET(FULL_PTR_TO_REFID_ELEMENT, State, 20)
}

static void test_pack_FULL_PTR_XLAT_TABLES(void)
{
    /* FULL_PTR_XLAT_TABLES */
}

static void test_pack_GENERIC_BINDING_INFO(void)
{
    /* GENERIC_BINDING_INFO */
    TEST_FIELD_SIZE  (GENERIC_BINDING_INFO, pObj, 8)
    TEST_FIELD_ALIGN (GENERIC_BINDING_INFO, pObj, 8)
    TEST_FIELD_OFFSET(GENERIC_BINDING_INFO, pObj, 0)
    TEST_FIELD_SIZE  (GENERIC_BINDING_INFO, Size, 4)
    TEST_FIELD_ALIGN (GENERIC_BINDING_INFO, Size, 4)
    TEST_FIELD_OFFSET(GENERIC_BINDING_INFO, Size, 8)
}

static void test_pack_GENERIC_BINDING_ROUTINE_PAIR(void)
{
    /* GENERIC_BINDING_ROUTINE_PAIR */
}

static void test_pack_MALLOC_FREE_STRUCT(void)
{
    /* MALLOC_FREE_STRUCT */
}

static void test_pack_MIDL_FORMAT_STRING(void)
{
    /* MIDL_FORMAT_STRING */
    TEST_FIELD_SIZE  (MIDL_FORMAT_STRING, Pad, 2)
    TEST_FIELD_ALIGN (MIDL_FORMAT_STRING, Pad, 2)
    TEST_FIELD_OFFSET(MIDL_FORMAT_STRING, Pad, 0)
}

static void test_pack_MIDL_SERVER_INFO(void)
{
    /* MIDL_SERVER_INFO */
    TEST_TYPE_SIZE   (MIDL_SERVER_INFO, 64)
    TEST_TYPE_ALIGN  (MIDL_SERVER_INFO, 8)
    TEST_FIELD_SIZE  (MIDL_SERVER_INFO, pStubDesc, 8)
    TEST_FIELD_ALIGN (MIDL_SERVER_INFO, pStubDesc, 8)
    TEST_FIELD_OFFSET(MIDL_SERVER_INFO, pStubDesc, 0)
    TEST_FIELD_SIZE  (MIDL_SERVER_INFO, DispatchTable, 8)
    TEST_FIELD_ALIGN (MIDL_SERVER_INFO, DispatchTable, 8)
    TEST_FIELD_OFFSET(MIDL_SERVER_INFO, DispatchTable, 8)
    TEST_FIELD_SIZE  (MIDL_SERVER_INFO, ProcString, 8)
    TEST_FIELD_ALIGN (MIDL_SERVER_INFO, ProcString, 8)
    TEST_FIELD_OFFSET(MIDL_SERVER_INFO, ProcString, 16)
    TEST_FIELD_SIZE  (MIDL_SERVER_INFO, FmtStringOffset, 8)
    TEST_FIELD_ALIGN (MIDL_SERVER_INFO, FmtStringOffset, 8)
    TEST_FIELD_OFFSET(MIDL_SERVER_INFO, FmtStringOffset, 24)
    TEST_FIELD_SIZE  (MIDL_SERVER_INFO, ThunkTable, 8)
    TEST_FIELD_ALIGN (MIDL_SERVER_INFO, ThunkTable, 8)
    TEST_FIELD_OFFSET(MIDL_SERVER_INFO, ThunkTable, 32)
    TEST_FIELD_SIZE  (MIDL_SERVER_INFO, pTransferSyntax, 8)
    TEST_FIELD_ALIGN (MIDL_SERVER_INFO, pTransferSyntax, 8)
    TEST_FIELD_OFFSET(MIDL_SERVER_INFO, pTransferSyntax, 40)
    TEST_FIELD_SIZE  (MIDL_SERVER_INFO, nCount, 8)
    TEST_FIELD_ALIGN (MIDL_SERVER_INFO, nCount, 8)
    TEST_FIELD_OFFSET(MIDL_SERVER_INFO, nCount, 48)
    TEST_FIELD_SIZE  (MIDL_SERVER_INFO, pSyntaxInfo, 8)
    TEST_FIELD_ALIGN (MIDL_SERVER_INFO, pSyntaxInfo, 8)
    TEST_FIELD_OFFSET(MIDL_SERVER_INFO, pSyntaxInfo, 56)
}

static void test_pack_MIDL_STUB_DESC(void)
{
    /* MIDL_STUB_DESC */
    TEST_FIELD_SIZE  (MIDL_STUB_DESC, RpcInterfaceInformation, 8)
    TEST_FIELD_ALIGN (MIDL_STUB_DESC, RpcInterfaceInformation, 8)
    TEST_FIELD_OFFSET(MIDL_STUB_DESC, RpcInterfaceInformation, 0)
}

static void test_pack_MIDL_STUB_MESSAGE(void)
{
    /* MIDL_STUB_MESSAGE */
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, RpcMsg, 8)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, RpcMsg, 8)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, RpcMsg, 0)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, Buffer, 8)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, Buffer, 8)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, Buffer, 8)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, BufferStart, 8)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, BufferStart, 8)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, BufferStart, 16)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, BufferEnd, 8)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, BufferEnd, 8)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, BufferEnd, 24)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, BufferMark, 8)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, BufferMark, 8)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, BufferMark, 32)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, BufferLength, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, BufferLength, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, BufferLength, 40)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, MemorySize, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, MemorySize, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, MemorySize, 44)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, Memory, 8)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, Memory, 8)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, Memory, 48)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, ReuseBuffer, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, ReuseBuffer, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, ReuseBuffer, 60)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, pAllocAllNodesContext, 8)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, pAllocAllNodesContext, 8)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, pAllocAllNodesContext, 64)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, pPointerQueueState, 8)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, pPointerQueueState, 8)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, pPointerQueueState, 72)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, IgnoreEmbeddedPointers, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, IgnoreEmbeddedPointers, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, IgnoreEmbeddedPointers, 80)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, PointerBufferMark, 8)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, PointerBufferMark, 8)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, PointerBufferMark, 88)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, CorrDespIncrement, 1)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, CorrDespIncrement, 1)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, CorrDespIncrement, 96)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, uFlags, 1)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, uFlags, 1)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, uFlags, 97)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, MaxCount, 8)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, MaxCount, 8)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, MaxCount, 104)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, Offset, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, Offset, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, Offset, 112)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, ActualCount, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, ActualCount, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, ActualCount, 116)
}

static void test_pack_MIDL_STUBLESS_PROXY_INFO(void)
{
    /* MIDL_STUBLESS_PROXY_INFO */
    TEST_TYPE_SIZE   (MIDL_STUBLESS_PROXY_INFO, 48)
    TEST_TYPE_ALIGN  (MIDL_STUBLESS_PROXY_INFO, 8)
    TEST_FIELD_SIZE  (MIDL_STUBLESS_PROXY_INFO, pStubDesc, 8)
    TEST_FIELD_ALIGN (MIDL_STUBLESS_PROXY_INFO, pStubDesc, 8)
    TEST_FIELD_OFFSET(MIDL_STUBLESS_PROXY_INFO, pStubDesc, 0)
    TEST_FIELD_SIZE  (MIDL_STUBLESS_PROXY_INFO, ProcFormatString, 8)
    TEST_FIELD_ALIGN (MIDL_STUBLESS_PROXY_INFO, ProcFormatString, 8)
    TEST_FIELD_OFFSET(MIDL_STUBLESS_PROXY_INFO, ProcFormatString, 8)
    TEST_FIELD_SIZE  (MIDL_STUBLESS_PROXY_INFO, FormatStringOffset, 8)
    TEST_FIELD_ALIGN (MIDL_STUBLESS_PROXY_INFO, FormatStringOffset, 8)
    TEST_FIELD_OFFSET(MIDL_STUBLESS_PROXY_INFO, FormatStringOffset, 16)
    TEST_FIELD_SIZE  (MIDL_STUBLESS_PROXY_INFO, pTransferSyntax, 8)
    TEST_FIELD_ALIGN (MIDL_STUBLESS_PROXY_INFO, pTransferSyntax, 8)
    TEST_FIELD_OFFSET(MIDL_STUBLESS_PROXY_INFO, pTransferSyntax, 24)
    TEST_FIELD_SIZE  (MIDL_STUBLESS_PROXY_INFO, nCount, 8)
    TEST_FIELD_ALIGN (MIDL_STUBLESS_PROXY_INFO, nCount, 8)
    TEST_FIELD_OFFSET(MIDL_STUBLESS_PROXY_INFO, nCount, 32)
    TEST_FIELD_SIZE  (MIDL_STUBLESS_PROXY_INFO, pSyntaxInfo, 8)
    TEST_FIELD_ALIGN (MIDL_STUBLESS_PROXY_INFO, pSyntaxInfo, 8)
    TEST_FIELD_OFFSET(MIDL_STUBLESS_PROXY_INFO, pSyntaxInfo, 40)
}

static void test_pack_MIDL_SYNTAX_INFO(void)
{
    /* MIDL_SYNTAX_INFO */
    TEST_TYPE_SIZE   (MIDL_SYNTAX_INFO, 80)
    TEST_TYPE_ALIGN  (MIDL_SYNTAX_INFO, 8)
    TEST_FIELD_SIZE  (MIDL_SYNTAX_INFO, TransferSyntax, 20)
    TEST_FIELD_ALIGN (MIDL_SYNTAX_INFO, TransferSyntax, 4)
    TEST_FIELD_OFFSET(MIDL_SYNTAX_INFO, TransferSyntax, 0)
    TEST_FIELD_SIZE  (MIDL_SYNTAX_INFO, DispatchTable, 8)
    TEST_FIELD_ALIGN (MIDL_SYNTAX_INFO, DispatchTable, 8)
    TEST_FIELD_OFFSET(MIDL_SYNTAX_INFO, DispatchTable, 24)
    TEST_FIELD_SIZE  (MIDL_SYNTAX_INFO, ProcString, 8)
    TEST_FIELD_ALIGN (MIDL_SYNTAX_INFO, ProcString, 8)
    TEST_FIELD_OFFSET(MIDL_SYNTAX_INFO, ProcString, 32)
    TEST_FIELD_SIZE  (MIDL_SYNTAX_INFO, FmtStringOffset, 8)
    TEST_FIELD_ALIGN (MIDL_SYNTAX_INFO, FmtStringOffset, 8)
    TEST_FIELD_OFFSET(MIDL_SYNTAX_INFO, FmtStringOffset, 40)
    TEST_FIELD_SIZE  (MIDL_SYNTAX_INFO, TypeString, 8)
    TEST_FIELD_ALIGN (MIDL_SYNTAX_INFO, TypeString, 8)
    TEST_FIELD_OFFSET(MIDL_SYNTAX_INFO, TypeString, 48)
    TEST_FIELD_SIZE  (MIDL_SYNTAX_INFO, aUserMarshalQuadruple, 8)
    TEST_FIELD_ALIGN (MIDL_SYNTAX_INFO, aUserMarshalQuadruple, 8)
    TEST_FIELD_OFFSET(MIDL_SYNTAX_INFO, aUserMarshalQuadruple, 56)
    TEST_FIELD_SIZE  (MIDL_SYNTAX_INFO, pReserved1, 8)
    TEST_FIELD_ALIGN (MIDL_SYNTAX_INFO, pReserved1, 8)
    TEST_FIELD_OFFSET(MIDL_SYNTAX_INFO, pReserved1, 64)
    TEST_FIELD_SIZE  (MIDL_SYNTAX_INFO, pReserved2, 8)
    TEST_FIELD_ALIGN (MIDL_SYNTAX_INFO, pReserved2, 8)
    TEST_FIELD_OFFSET(MIDL_SYNTAX_INFO, pReserved2, 72)
}

static void test_pack_NDR_CCONTEXT(void)
{
    /* NDR_CCONTEXT */
    TEST_TYPE_SIZE   (NDR_CCONTEXT, 8)
    TEST_TYPE_ALIGN  (NDR_CCONTEXT, 8)
}

static void test_pack_NDR_NOTIFY_ROUTINE(void)
{
    /* NDR_NOTIFY_ROUTINE */
}

static void test_pack_NDR_NOTIFY2_ROUTINE(void)
{
    /* NDR_NOTIFY2_ROUTINE */
}

static void test_pack_NDR_RUNDOWN(void)
{
    /* NDR_RUNDOWN */
}

static void test_pack_NDR_SCONTEXT(void)
{
    /* NDR_SCONTEXT */
    TEST_TYPE_SIZE   (NDR_SCONTEXT, 8)
    TEST_TYPE_ALIGN  (NDR_SCONTEXT, 8)
}

static void test_pack_NDR_USER_MARSHAL_INFO(void)
{
    /* NDR_USER_MARSHAL_INFO */
    TEST_FIELD_SIZE  (NDR_USER_MARSHAL_INFO, InformationLevel, 4)
    TEST_FIELD_ALIGN (NDR_USER_MARSHAL_INFO, InformationLevel, 4)
    TEST_FIELD_OFFSET(NDR_USER_MARSHAL_INFO, InformationLevel, 0)
}

static void test_pack_NDR_USER_MARSHAL_INFO_LEVEL1(void)
{
    /* NDR_USER_MARSHAL_INFO_LEVEL1 */
    TEST_FIELD_SIZE  (NDR_USER_MARSHAL_INFO_LEVEL1, Buffer, 8)
    TEST_FIELD_ALIGN (NDR_USER_MARSHAL_INFO_LEVEL1, Buffer, 8)
    TEST_FIELD_OFFSET(NDR_USER_MARSHAL_INFO_LEVEL1, Buffer, 0)
    TEST_FIELD_SIZE  (NDR_USER_MARSHAL_INFO_LEVEL1, BufferSize, 4)
    TEST_FIELD_ALIGN (NDR_USER_MARSHAL_INFO_LEVEL1, BufferSize, 4)
    TEST_FIELD_OFFSET(NDR_USER_MARSHAL_INFO_LEVEL1, BufferSize, 8)
}

static void test_pack_PARRAY_INFO(void)
{
    /* PARRAY_INFO */
    TEST_TYPE_SIZE   (PARRAY_INFO, 8)
    TEST_TYPE_ALIGN  (PARRAY_INFO, 8)
    TEST_TARGET_SIZE (PARRAY_INFO, 48)
    TEST_TARGET_ALIGN(PARRAY_INFO, 8)
}

static void test_pack_PFORMAT_STRING(void)
{
    /* PFORMAT_STRING */
    TEST_TYPE_SIZE   (PFORMAT_STRING, 8)
    TEST_TYPE_ALIGN  (PFORMAT_STRING, 8)
}

static void test_pack_PFULL_PTR_TO_REFID_ELEMENT(void)
{
    /* PFULL_PTR_TO_REFID_ELEMENT */
    TEST_TYPE_SIZE   (PFULL_PTR_TO_REFID_ELEMENT, 8)
    TEST_TYPE_ALIGN  (PFULL_PTR_TO_REFID_ELEMENT, 8)
    TEST_TARGET_SIZE (PFULL_PTR_TO_REFID_ELEMENT, 24)
    TEST_TARGET_ALIGN(PFULL_PTR_TO_REFID_ELEMENT, 8)
}

static void test_pack_PFULL_PTR_XLAT_TABLES(void)
{
    /* PFULL_PTR_XLAT_TABLES */
    TEST_TYPE_SIZE   (PFULL_PTR_XLAT_TABLES, 8)
    TEST_TYPE_ALIGN  (PFULL_PTR_XLAT_TABLES, 8)
}

static void test_pack_PGENERIC_BINDING_INFO(void)
{
    /* PGENERIC_BINDING_INFO */
    TEST_TYPE_SIZE   (PGENERIC_BINDING_INFO, 8)
    TEST_TYPE_ALIGN  (PGENERIC_BINDING_INFO, 8)
}

static void test_pack_PGENERIC_BINDING_ROUTINE_PAIR(void)
{
    /* PGENERIC_BINDING_ROUTINE_PAIR */
    TEST_TYPE_SIZE   (PGENERIC_BINDING_ROUTINE_PAIR, 8)
    TEST_TYPE_ALIGN  (PGENERIC_BINDING_ROUTINE_PAIR, 8)
}

static void test_pack_PMIDL_SERVER_INFO(void)
{
    /* PMIDL_SERVER_INFO */
    TEST_TYPE_SIZE   (PMIDL_SERVER_INFO, 8)
    TEST_TYPE_ALIGN  (PMIDL_SERVER_INFO, 8)
    TEST_TARGET_SIZE (PMIDL_SERVER_INFO, 64)
    TEST_TARGET_ALIGN(PMIDL_SERVER_INFO, 8)
}

static void test_pack_PMIDL_STUB_DESC(void)
{
    /* PMIDL_STUB_DESC */
    TEST_TYPE_SIZE   (PMIDL_STUB_DESC, 8)
    TEST_TYPE_ALIGN  (PMIDL_STUB_DESC, 8)
}

static void test_pack_PMIDL_STUB_MESSAGE(void)
{
    /* PMIDL_STUB_MESSAGE */
    TEST_TYPE_SIZE   (PMIDL_STUB_MESSAGE, 8)
    TEST_TYPE_ALIGN  (PMIDL_STUB_MESSAGE, 8)
}

static void test_pack_PMIDL_STUBLESS_PROXY_INFO(void)
{
    /* PMIDL_STUBLESS_PROXY_INFO */
    TEST_TYPE_SIZE   (PMIDL_STUBLESS_PROXY_INFO, 8)
    TEST_TYPE_ALIGN  (PMIDL_STUBLESS_PROXY_INFO, 8)
    TEST_TARGET_SIZE (PMIDL_STUBLESS_PROXY_INFO, 48)
    TEST_TARGET_ALIGN(PMIDL_STUBLESS_PROXY_INFO, 8)
}

static void test_pack_PMIDL_SYNTAX_INFO(void)
{
    /* PMIDL_SYNTAX_INFO */
    TEST_TYPE_SIZE   (PMIDL_SYNTAX_INFO, 8)
    TEST_TYPE_ALIGN  (PMIDL_SYNTAX_INFO, 8)
    TEST_TARGET_SIZE (PMIDL_SYNTAX_INFO, 80)
    TEST_TARGET_ALIGN(PMIDL_SYNTAX_INFO, 8)
}

static void test_pack_PNDR_ASYNC_MESSAGE(void)
{
    /* PNDR_ASYNC_MESSAGE */
    TEST_TYPE_SIZE   (PNDR_ASYNC_MESSAGE, 8)
    TEST_TYPE_ALIGN  (PNDR_ASYNC_MESSAGE, 8)
}

static void test_pack_PNDR_CORRELATION_INFO(void)
{
    /* PNDR_CORRELATION_INFO */
    TEST_TYPE_SIZE   (PNDR_CORRELATION_INFO, 8)
    TEST_TYPE_ALIGN  (PNDR_CORRELATION_INFO, 8)
}

static void test_pack_PSCONTEXT_QUEUE(void)
{
    /* PSCONTEXT_QUEUE */
    TEST_TYPE_SIZE   (PSCONTEXT_QUEUE, 8)
    TEST_TYPE_ALIGN  (PSCONTEXT_QUEUE, 8)
    TEST_TARGET_SIZE (PSCONTEXT_QUEUE, 16)
    TEST_TARGET_ALIGN(PSCONTEXT_QUEUE, 8)
}

static void test_pack_PXMIT_ROUTINE_QUINTUPLE(void)
{
    /* PXMIT_ROUTINE_QUINTUPLE */
    TEST_TYPE_SIZE   (PXMIT_ROUTINE_QUINTUPLE, 8)
    TEST_TYPE_ALIGN  (PXMIT_ROUTINE_QUINTUPLE, 8)
}

static void test_pack_SCONTEXT_QUEUE(void)
{
    /* SCONTEXT_QUEUE */
    TEST_TYPE_SIZE   (SCONTEXT_QUEUE, 16)
    TEST_TYPE_ALIGN  (SCONTEXT_QUEUE, 8)
    TEST_FIELD_SIZE  (SCONTEXT_QUEUE, NumberOfObjects, 4)
    TEST_FIELD_ALIGN (SCONTEXT_QUEUE, NumberOfObjects, 4)
    TEST_FIELD_OFFSET(SCONTEXT_QUEUE, NumberOfObjects, 0)
    TEST_FIELD_SIZE  (SCONTEXT_QUEUE, ArrayOfObjects, 8)
    TEST_FIELD_ALIGN (SCONTEXT_QUEUE, ArrayOfObjects, 8)
    TEST_FIELD_OFFSET(SCONTEXT_QUEUE, ArrayOfObjects, 8)
}

static void test_pack_SERVER_ROUTINE(void)
{
    /* SERVER_ROUTINE */
}

static void test_pack_STUB_THUNK(void)
{
    /* STUB_THUNK */
}

static void test_pack_USER_MARSHAL_CB(void)
{
    /* USER_MARSHAL_CB */
    TEST_FIELD_SIZE  (USER_MARSHAL_CB, Flags, 4)
    TEST_FIELD_ALIGN (USER_MARSHAL_CB, Flags, 4)
    TEST_FIELD_OFFSET(USER_MARSHAL_CB, Flags, 0)
    TEST_FIELD_SIZE  (USER_MARSHAL_CB, pStubMsg, 8)
    TEST_FIELD_ALIGN (USER_MARSHAL_CB, pStubMsg, 8)
    TEST_FIELD_OFFSET(USER_MARSHAL_CB, pStubMsg, 8)
    TEST_FIELD_SIZE  (USER_MARSHAL_CB, pReserve, 8)
    TEST_FIELD_ALIGN (USER_MARSHAL_CB, pReserve, 8)
    TEST_FIELD_OFFSET(USER_MARSHAL_CB, pReserve, 16)
    TEST_FIELD_SIZE  (USER_MARSHAL_CB, Signature, 4)
    TEST_FIELD_ALIGN (USER_MARSHAL_CB, Signature, 4)
    TEST_FIELD_OFFSET(USER_MARSHAL_CB, Signature, 24)
}

static void test_pack_USER_MARSHAL_FREEING_ROUTINE(void)
{
    /* USER_MARSHAL_FREEING_ROUTINE */
}

static void test_pack_USER_MARSHAL_MARSHALLING_ROUTINE(void)
{
    /* USER_MARSHAL_MARSHALLING_ROUTINE */
}

static void test_pack_USER_MARSHAL_ROUTINE_QUADRUPLE(void)
{
    /* USER_MARSHAL_ROUTINE_QUADRUPLE */
}

static void test_pack_USER_MARSHAL_SIZING_ROUTINE(void)
{
    /* USER_MARSHAL_SIZING_ROUTINE */
}

static void test_pack_USER_MARSHAL_UNMARSHALLING_ROUTINE(void)
{
    /* USER_MARSHAL_UNMARSHALLING_ROUTINE */
}

static void test_pack_XMIT_HELPER_ROUTINE(void)
{
    /* XMIT_HELPER_ROUTINE */
}

static void test_pack_XMIT_ROUTINE_QUINTUPLE(void)
{
    /* XMIT_ROUTINE_QUINTUPLE */
}

static void test_pack_PRPC_STUB_FUNCTION(void)
{
    /* PRPC_STUB_FUNCTION */
}

#else /* _WIN64 */

static void test_pack_I_RPC_HANDLE(void)
{
    /* I_RPC_HANDLE */
    TEST_TYPE_SIZE   (I_RPC_HANDLE, 4)
    TEST_TYPE_ALIGN  (I_RPC_HANDLE, 4)
}

static void test_pack_RPC_STATUS(void)
{
    /* RPC_STATUS */
    TEST_TYPE_SIZE   (RPC_STATUS, 4)
    TEST_TYPE_ALIGN  (RPC_STATUS, 4)
}

static void test_pack_PRPC_POLICY(void)
{
    /* PRPC_POLICY */
    TEST_TYPE_SIZE   (PRPC_POLICY, 4)
    TEST_TYPE_ALIGN  (PRPC_POLICY, 4)
    TEST_TARGET_SIZE (PRPC_POLICY, 12)
    TEST_TARGET_ALIGN(PRPC_POLICY, 4)
}

static void test_pack_RPC_AUTH_IDENTITY_HANDLE(void)
{
    /* RPC_AUTH_IDENTITY_HANDLE */
    TEST_TYPE_SIZE   (RPC_AUTH_IDENTITY_HANDLE, 4)
    TEST_TYPE_ALIGN  (RPC_AUTH_IDENTITY_HANDLE, 4)
}

static void test_pack_RPC_AUTH_KEY_RETRIEVAL_FN(void)
{
    /* RPC_AUTH_KEY_RETRIEVAL_FN */
}

static void test_pack_RPC_AUTHZ_HANDLE(void)
{
    /* RPC_AUTHZ_HANDLE */
    TEST_TYPE_SIZE   (RPC_AUTHZ_HANDLE, 4)
    TEST_TYPE_ALIGN  (RPC_AUTHZ_HANDLE, 4)
}

static void test_pack_RPC_BINDING_HANDLE(void)
{
    /* RPC_BINDING_HANDLE */
    TEST_TYPE_SIZE   (RPC_BINDING_HANDLE, 4)
    TEST_TYPE_ALIGN  (RPC_BINDING_HANDLE, 4)
}

static void test_pack_RPC_BINDING_VECTOR(void)
{
    /* RPC_BINDING_VECTOR */
    TEST_TYPE_SIZE   (RPC_BINDING_VECTOR, 8)
    TEST_TYPE_ALIGN  (RPC_BINDING_VECTOR, 4)
    TEST_FIELD_SIZE  (RPC_BINDING_VECTOR, Count, 4)
    TEST_FIELD_ALIGN (RPC_BINDING_VECTOR, Count, 4)
    TEST_FIELD_OFFSET(RPC_BINDING_VECTOR, Count, 0)
    TEST_FIELD_SIZE  (RPC_BINDING_VECTOR, BindingH, 4)
    TEST_FIELD_ALIGN (RPC_BINDING_VECTOR, BindingH, 4)
    TEST_FIELD_OFFSET(RPC_BINDING_VECTOR, BindingH, 4)
}

static void test_pack_RPC_IF_HANDLE(void)
{
    /* RPC_IF_HANDLE */
    TEST_TYPE_SIZE   (RPC_IF_HANDLE, 4)
    TEST_TYPE_ALIGN  (RPC_IF_HANDLE, 4)
}

static void test_pack_RPC_IF_ID(void)
{
    /* RPC_IF_ID */
    TEST_TYPE_SIZE   (RPC_IF_ID, 20)
    TEST_TYPE_ALIGN  (RPC_IF_ID, 4)
    TEST_FIELD_SIZE  (RPC_IF_ID, Uuid, 16)
    TEST_FIELD_ALIGN (RPC_IF_ID, Uuid, 4)
    TEST_FIELD_OFFSET(RPC_IF_ID, Uuid, 0)
    TEST_FIELD_SIZE  (RPC_IF_ID, VersMajor, 2)
    TEST_FIELD_ALIGN (RPC_IF_ID, VersMajor, 2)
    TEST_FIELD_OFFSET(RPC_IF_ID, VersMajor, 16)
    TEST_FIELD_SIZE  (RPC_IF_ID, VersMinor, 2)
    TEST_FIELD_ALIGN (RPC_IF_ID, VersMinor, 2)
    TEST_FIELD_OFFSET(RPC_IF_ID, VersMinor, 18)
}

static void test_pack_RPC_POLICY(void)
{
    /* RPC_POLICY */
    TEST_TYPE_SIZE   (RPC_POLICY, 12)
    TEST_TYPE_ALIGN  (RPC_POLICY, 4)
    TEST_FIELD_SIZE  (RPC_POLICY, Length, 4)
    TEST_FIELD_ALIGN (RPC_POLICY, Length, 4)
    TEST_FIELD_OFFSET(RPC_POLICY, Length, 0)
    TEST_FIELD_SIZE  (RPC_POLICY, EndpointFlags, 4)
    TEST_FIELD_ALIGN (RPC_POLICY, EndpointFlags, 4)
    TEST_FIELD_OFFSET(RPC_POLICY, EndpointFlags, 4)
    TEST_FIELD_SIZE  (RPC_POLICY, NICFlags, 4)
    TEST_FIELD_ALIGN (RPC_POLICY, NICFlags, 4)
    TEST_FIELD_OFFSET(RPC_POLICY, NICFlags, 8)
}

static void test_pack_UUID_VECTOR(void)
{
    /* UUID_VECTOR */
    TEST_TYPE_SIZE   (UUID_VECTOR, 8)
    TEST_TYPE_ALIGN  (UUID_VECTOR, 4)
    TEST_FIELD_SIZE  (UUID_VECTOR, Count, 4)
    TEST_FIELD_ALIGN (UUID_VECTOR, Count, 4)
    TEST_FIELD_OFFSET(UUID_VECTOR, Count, 0)
    TEST_FIELD_SIZE  (UUID_VECTOR, Uuid, 4)
    TEST_FIELD_ALIGN (UUID_VECTOR, Uuid, 4)
    TEST_FIELD_OFFSET(UUID_VECTOR, Uuid, 4)
}

static void test_pack_PRPC_CLIENT_INTERFACE(void)
{
    /* PRPC_CLIENT_INTERFACE */
    TEST_TYPE_SIZE   (PRPC_CLIENT_INTERFACE, 4)
    TEST_TYPE_ALIGN  (PRPC_CLIENT_INTERFACE, 4)
    TEST_TARGET_SIZE (PRPC_CLIENT_INTERFACE, 68)
    TEST_TARGET_ALIGN(PRPC_CLIENT_INTERFACE, 4)
}

static void test_pack_PRPC_DISPATCH_TABLE(void)
{
    /* PRPC_DISPATCH_TABLE */
    TEST_TYPE_SIZE   (PRPC_DISPATCH_TABLE, 4)
    TEST_TYPE_ALIGN  (PRPC_DISPATCH_TABLE, 4)
    TEST_TARGET_SIZE (PRPC_DISPATCH_TABLE, 12)
    TEST_TARGET_ALIGN(PRPC_DISPATCH_TABLE, 4)
}

static void test_pack_PRPC_MESSAGE(void)
{
    /* PRPC_MESSAGE */
    TEST_TYPE_SIZE   (PRPC_MESSAGE, 4)
    TEST_TYPE_ALIGN  (PRPC_MESSAGE, 4)
    TEST_TARGET_SIZE (PRPC_MESSAGE, 44)
    TEST_TARGET_ALIGN(PRPC_MESSAGE, 4)
}

static void test_pack_PRPC_PROTSEQ_ENDPOINT(void)
{
    /* PRPC_PROTSEQ_ENDPOINT */
    TEST_TYPE_SIZE   (PRPC_PROTSEQ_ENDPOINT, 4)
    TEST_TYPE_ALIGN  (PRPC_PROTSEQ_ENDPOINT, 4)
    TEST_TARGET_SIZE (PRPC_PROTSEQ_ENDPOINT, 8)
    TEST_TARGET_ALIGN(PRPC_PROTSEQ_ENDPOINT, 4)
}

static void test_pack_PRPC_SERVER_INTERFACE(void)
{
    /* PRPC_SERVER_INTERFACE */
    TEST_TYPE_SIZE   (PRPC_SERVER_INTERFACE, 4)
    TEST_TYPE_ALIGN  (PRPC_SERVER_INTERFACE, 4)
    TEST_TARGET_SIZE (PRPC_SERVER_INTERFACE, 68)
    TEST_TARGET_ALIGN(PRPC_SERVER_INTERFACE, 4)
}

static void test_pack_PRPC_SYNTAX_IDENTIFIER(void)
{
    /* PRPC_SYNTAX_IDENTIFIER */
    TEST_TYPE_SIZE   (PRPC_SYNTAX_IDENTIFIER, 4)
    TEST_TYPE_ALIGN  (PRPC_SYNTAX_IDENTIFIER, 4)
    TEST_TARGET_SIZE (PRPC_SYNTAX_IDENTIFIER, 20)
    TEST_TARGET_ALIGN(PRPC_SYNTAX_IDENTIFIER, 4)
}

static void test_pack_RPC_CLIENT_INTERFACE(void)
{
    /* RPC_CLIENT_INTERFACE */
    TEST_TYPE_SIZE   (RPC_CLIENT_INTERFACE, 68)
    TEST_TYPE_ALIGN  (RPC_CLIENT_INTERFACE, 4)
    TEST_FIELD_SIZE  (RPC_CLIENT_INTERFACE, Length, 4)
    TEST_FIELD_ALIGN (RPC_CLIENT_INTERFACE, Length, 4)
    TEST_FIELD_OFFSET(RPC_CLIENT_INTERFACE, Length, 0)
    TEST_FIELD_SIZE  (RPC_CLIENT_INTERFACE, InterfaceId, 20)
    TEST_FIELD_ALIGN (RPC_CLIENT_INTERFACE, InterfaceId, 4)
    TEST_FIELD_OFFSET(RPC_CLIENT_INTERFACE, InterfaceId, 4)
    TEST_FIELD_SIZE  (RPC_CLIENT_INTERFACE, TransferSyntax, 20)
    TEST_FIELD_ALIGN (RPC_CLIENT_INTERFACE, TransferSyntax, 4)
    TEST_FIELD_OFFSET(RPC_CLIENT_INTERFACE, TransferSyntax, 24)
    TEST_FIELD_SIZE  (RPC_CLIENT_INTERFACE, DispatchTable, 4)
    TEST_FIELD_ALIGN (RPC_CLIENT_INTERFACE, DispatchTable, 4)
    TEST_FIELD_OFFSET(RPC_CLIENT_INTERFACE, DispatchTable, 44)
    TEST_FIELD_SIZE  (RPC_CLIENT_INTERFACE, RpcProtseqEndpointCount, 4)
    TEST_FIELD_ALIGN (RPC_CLIENT_INTERFACE, RpcProtseqEndpointCount, 4)
    TEST_FIELD_OFFSET(RPC_CLIENT_INTERFACE, RpcProtseqEndpointCount, 48)
    TEST_FIELD_SIZE  (RPC_CLIENT_INTERFACE, RpcProtseqEndpoint, 4)
    TEST_FIELD_ALIGN (RPC_CLIENT_INTERFACE, RpcProtseqEndpoint, 4)
    TEST_FIELD_OFFSET(RPC_CLIENT_INTERFACE, RpcProtseqEndpoint, 52)
    TEST_FIELD_SIZE  (RPC_CLIENT_INTERFACE, Reserved, 4)
    TEST_FIELD_ALIGN (RPC_CLIENT_INTERFACE, Reserved, 4)
    TEST_FIELD_OFFSET(RPC_CLIENT_INTERFACE, Reserved, 56)
    TEST_FIELD_SIZE  (RPC_CLIENT_INTERFACE, InterpreterInfo, 4)
    TEST_FIELD_ALIGN (RPC_CLIENT_INTERFACE, InterpreterInfo, 4)
    TEST_FIELD_OFFSET(RPC_CLIENT_INTERFACE, InterpreterInfo, 60)
    TEST_FIELD_SIZE  (RPC_CLIENT_INTERFACE, Flags, 4)
    TEST_FIELD_ALIGN (RPC_CLIENT_INTERFACE, Flags, 4)
    TEST_FIELD_OFFSET(RPC_CLIENT_INTERFACE, Flags, 64)
}

static void test_pack_RPC_DISPATCH_FUNCTION(void)
{
    /* RPC_DISPATCH_FUNCTION */
}

static void test_pack_RPC_DISPATCH_TABLE(void)
{
    /* RPC_DISPATCH_TABLE */
    TEST_TYPE_SIZE   (RPC_DISPATCH_TABLE, 12)
    TEST_TYPE_ALIGN  (RPC_DISPATCH_TABLE, 4)
    TEST_FIELD_SIZE  (RPC_DISPATCH_TABLE, DispatchTableCount, 4)
    TEST_FIELD_ALIGN (RPC_DISPATCH_TABLE, DispatchTableCount, 4)
    TEST_FIELD_OFFSET(RPC_DISPATCH_TABLE, DispatchTableCount, 0)
    TEST_FIELD_SIZE  (RPC_DISPATCH_TABLE, DispatchTable, 4)
    TEST_FIELD_ALIGN (RPC_DISPATCH_TABLE, DispatchTable, 4)
    TEST_FIELD_OFFSET(RPC_DISPATCH_TABLE, DispatchTable, 4)
    TEST_FIELD_SIZE  (RPC_DISPATCH_TABLE, Reserved, 4)
    TEST_FIELD_ALIGN (RPC_DISPATCH_TABLE, Reserved, 4)
    TEST_FIELD_OFFSET(RPC_DISPATCH_TABLE, Reserved, 8)
}

static void test_pack_RPC_MESSAGE(void)
{
    /* RPC_MESSAGE */
    TEST_TYPE_SIZE   (RPC_MESSAGE, 44)
    TEST_TYPE_ALIGN  (RPC_MESSAGE, 4)
    TEST_FIELD_SIZE  (RPC_MESSAGE, Handle, 4)
    TEST_FIELD_ALIGN (RPC_MESSAGE, Handle, 4)
    TEST_FIELD_OFFSET(RPC_MESSAGE, Handle, 0)
    TEST_FIELD_SIZE  (RPC_MESSAGE, DataRepresentation, 4)
    TEST_FIELD_ALIGN (RPC_MESSAGE, DataRepresentation, 4)
    TEST_FIELD_OFFSET(RPC_MESSAGE, DataRepresentation, 4)
    TEST_FIELD_SIZE  (RPC_MESSAGE, Buffer, 4)
    TEST_FIELD_ALIGN (RPC_MESSAGE, Buffer, 4)
    TEST_FIELD_OFFSET(RPC_MESSAGE, Buffer, 8)
    TEST_FIELD_SIZE  (RPC_MESSAGE, BufferLength, 4)
    TEST_FIELD_ALIGN (RPC_MESSAGE, BufferLength, 4)
    TEST_FIELD_OFFSET(RPC_MESSAGE, BufferLength, 12)
    TEST_FIELD_SIZE  (RPC_MESSAGE, ProcNum, 4)
    TEST_FIELD_ALIGN (RPC_MESSAGE, ProcNum, 4)
    TEST_FIELD_OFFSET(RPC_MESSAGE, ProcNum, 16)
    TEST_FIELD_SIZE  (RPC_MESSAGE, TransferSyntax, 4)
    TEST_FIELD_ALIGN (RPC_MESSAGE, TransferSyntax, 4)
    TEST_FIELD_OFFSET(RPC_MESSAGE, TransferSyntax, 20)
    TEST_FIELD_SIZE  (RPC_MESSAGE, RpcInterfaceInformation, 4)
    TEST_FIELD_ALIGN (RPC_MESSAGE, RpcInterfaceInformation, 4)
    TEST_FIELD_OFFSET(RPC_MESSAGE, RpcInterfaceInformation, 24)
    TEST_FIELD_SIZE  (RPC_MESSAGE, ReservedForRuntime, 4)
    TEST_FIELD_ALIGN (RPC_MESSAGE, ReservedForRuntime, 4)
    TEST_FIELD_OFFSET(RPC_MESSAGE, ReservedForRuntime, 28)
    TEST_FIELD_SIZE  (RPC_MESSAGE, ManagerEpv, 4)
    TEST_FIELD_ALIGN (RPC_MESSAGE, ManagerEpv, 4)
    TEST_FIELD_OFFSET(RPC_MESSAGE, ManagerEpv, 32)
    TEST_FIELD_SIZE  (RPC_MESSAGE, ImportContext, 4)
    TEST_FIELD_ALIGN (RPC_MESSAGE, ImportContext, 4)
    TEST_FIELD_OFFSET(RPC_MESSAGE, ImportContext, 36)
    TEST_FIELD_SIZE  (RPC_MESSAGE, RpcFlags, 4)
    TEST_FIELD_ALIGN (RPC_MESSAGE, RpcFlags, 4)
    TEST_FIELD_OFFSET(RPC_MESSAGE, RpcFlags, 40)
}

static void test_pack_RPC_PROTSEQ_ENDPOINT(void)
{
    /* RPC_PROTSEQ_ENDPOINT */
    TEST_TYPE_SIZE   (RPC_PROTSEQ_ENDPOINT, 8)
    TEST_TYPE_ALIGN  (RPC_PROTSEQ_ENDPOINT, 4)
    TEST_FIELD_SIZE  (RPC_PROTSEQ_ENDPOINT, RpcProtocolSequence, 4)
    TEST_FIELD_ALIGN (RPC_PROTSEQ_ENDPOINT, RpcProtocolSequence, 4)
    TEST_FIELD_OFFSET(RPC_PROTSEQ_ENDPOINT, RpcProtocolSequence, 0)
    TEST_FIELD_SIZE  (RPC_PROTSEQ_ENDPOINT, Endpoint, 4)
    TEST_FIELD_ALIGN (RPC_PROTSEQ_ENDPOINT, Endpoint, 4)
    TEST_FIELD_OFFSET(RPC_PROTSEQ_ENDPOINT, Endpoint, 4)
}

static void test_pack_RPC_SERVER_INTERFACE(void)
{
    /* RPC_SERVER_INTERFACE */
    TEST_TYPE_SIZE   (RPC_SERVER_INTERFACE, 68)
    TEST_TYPE_ALIGN  (RPC_SERVER_INTERFACE, 4)
    TEST_FIELD_SIZE  (RPC_SERVER_INTERFACE, Length, 4)
    TEST_FIELD_ALIGN (RPC_SERVER_INTERFACE, Length, 4)
    TEST_FIELD_OFFSET(RPC_SERVER_INTERFACE, Length, 0)
    TEST_FIELD_SIZE  (RPC_SERVER_INTERFACE, InterfaceId, 20)
    TEST_FIELD_ALIGN (RPC_SERVER_INTERFACE, InterfaceId, 4)
    TEST_FIELD_OFFSET(RPC_SERVER_INTERFACE, InterfaceId, 4)
    TEST_FIELD_SIZE  (RPC_SERVER_INTERFACE, TransferSyntax, 20)
    TEST_FIELD_ALIGN (RPC_SERVER_INTERFACE, TransferSyntax, 4)
    TEST_FIELD_OFFSET(RPC_SERVER_INTERFACE, TransferSyntax, 24)
    TEST_FIELD_SIZE  (RPC_SERVER_INTERFACE, DispatchTable, 4)
    TEST_FIELD_ALIGN (RPC_SERVER_INTERFACE, DispatchTable, 4)
    TEST_FIELD_OFFSET(RPC_SERVER_INTERFACE, DispatchTable, 44)
    TEST_FIELD_SIZE  (RPC_SERVER_INTERFACE, RpcProtseqEndpointCount, 4)
    TEST_FIELD_ALIGN (RPC_SERVER_INTERFACE, RpcProtseqEndpointCount, 4)
    TEST_FIELD_OFFSET(RPC_SERVER_INTERFACE, RpcProtseqEndpointCount, 48)
    TEST_FIELD_SIZE  (RPC_SERVER_INTERFACE, RpcProtseqEndpoint, 4)
    TEST_FIELD_ALIGN (RPC_SERVER_INTERFACE, RpcProtseqEndpoint, 4)
    TEST_FIELD_OFFSET(RPC_SERVER_INTERFACE, RpcProtseqEndpoint, 52)
    TEST_FIELD_SIZE  (RPC_SERVER_INTERFACE, DefaultManagerEpv, 4)
    TEST_FIELD_ALIGN (RPC_SERVER_INTERFACE, DefaultManagerEpv, 4)
    TEST_FIELD_OFFSET(RPC_SERVER_INTERFACE, DefaultManagerEpv, 56)
    TEST_FIELD_SIZE  (RPC_SERVER_INTERFACE, InterpreterInfo, 4)
    TEST_FIELD_ALIGN (RPC_SERVER_INTERFACE, InterpreterInfo, 4)
    TEST_FIELD_OFFSET(RPC_SERVER_INTERFACE, InterpreterInfo, 60)
    TEST_FIELD_SIZE  (RPC_SERVER_INTERFACE, Flags, 4)
    TEST_FIELD_ALIGN (RPC_SERVER_INTERFACE, Flags, 4)
    TEST_FIELD_OFFSET(RPC_SERVER_INTERFACE, Flags, 64)
}

static void test_pack_RPC_SYNTAX_IDENTIFIER(void)
{
    /* RPC_SYNTAX_IDENTIFIER */
    TEST_TYPE_SIZE   (RPC_SYNTAX_IDENTIFIER, 20)
    TEST_TYPE_ALIGN  (RPC_SYNTAX_IDENTIFIER, 4)
    TEST_FIELD_SIZE  (RPC_SYNTAX_IDENTIFIER, SyntaxGUID, 16)
    TEST_FIELD_ALIGN (RPC_SYNTAX_IDENTIFIER, SyntaxGUID, 4)
    TEST_FIELD_OFFSET(RPC_SYNTAX_IDENTIFIER, SyntaxGUID, 0)
    TEST_FIELD_SIZE  (RPC_SYNTAX_IDENTIFIER, SyntaxVersion, 4)
    TEST_FIELD_ALIGN (RPC_SYNTAX_IDENTIFIER, SyntaxVersion, 2)
    TEST_FIELD_OFFSET(RPC_SYNTAX_IDENTIFIER, SyntaxVersion, 16)
}

static void test_pack_RPC_VERSION(void)
{
    /* RPC_VERSION */
    TEST_TYPE_SIZE   (RPC_VERSION, 4)
    TEST_TYPE_ALIGN  (RPC_VERSION, 2)
    TEST_FIELD_SIZE  (RPC_VERSION, MajorVersion, 2)
    TEST_FIELD_ALIGN (RPC_VERSION, MajorVersion, 2)
    TEST_FIELD_OFFSET(RPC_VERSION, MajorVersion, 0)
    TEST_FIELD_SIZE  (RPC_VERSION, MinorVersion, 2)
    TEST_FIELD_ALIGN (RPC_VERSION, MinorVersion, 2)
    TEST_FIELD_OFFSET(RPC_VERSION, MinorVersion, 2)
}

static void test_pack_ARRAY_INFO(void)
{
    /* ARRAY_INFO */
    TEST_TYPE_SIZE   (ARRAY_INFO, 24)
    TEST_TYPE_ALIGN  (ARRAY_INFO, 4)
    TEST_FIELD_SIZE  (ARRAY_INFO, Dimension, 4)
    TEST_FIELD_ALIGN (ARRAY_INFO, Dimension, 4)
    TEST_FIELD_OFFSET(ARRAY_INFO, Dimension, 0)
    TEST_FIELD_SIZE  (ARRAY_INFO, BufferConformanceMark, 4)
    TEST_FIELD_ALIGN (ARRAY_INFO, BufferConformanceMark, 4)
    TEST_FIELD_OFFSET(ARRAY_INFO, BufferConformanceMark, 4)
    TEST_FIELD_SIZE  (ARRAY_INFO, BufferVarianceMark, 4)
    TEST_FIELD_ALIGN (ARRAY_INFO, BufferVarianceMark, 4)
    TEST_FIELD_OFFSET(ARRAY_INFO, BufferVarianceMark, 8)
    TEST_FIELD_SIZE  (ARRAY_INFO, MaxCountArray, 4)
    TEST_FIELD_ALIGN (ARRAY_INFO, MaxCountArray, 4)
    TEST_FIELD_OFFSET(ARRAY_INFO, MaxCountArray, 12)
    TEST_FIELD_SIZE  (ARRAY_INFO, OffsetArray, 4)
    TEST_FIELD_ALIGN (ARRAY_INFO, OffsetArray, 4)
    TEST_FIELD_OFFSET(ARRAY_INFO, OffsetArray, 16)
    TEST_FIELD_SIZE  (ARRAY_INFO, ActualCountArray, 4)
    TEST_FIELD_ALIGN (ARRAY_INFO, ActualCountArray, 4)
    TEST_FIELD_OFFSET(ARRAY_INFO, ActualCountArray, 20)
}

static void test_pack_COMM_FAULT_OFFSETS(void)
{
    /* COMM_FAULT_OFFSETS */
    TEST_TYPE_SIZE   (COMM_FAULT_OFFSETS, 4)
    TEST_TYPE_ALIGN  (COMM_FAULT_OFFSETS, 2)
    TEST_FIELD_SIZE  (COMM_FAULT_OFFSETS, CommOffset, 2)
    TEST_FIELD_ALIGN (COMM_FAULT_OFFSETS, CommOffset, 2)
    TEST_FIELD_OFFSET(COMM_FAULT_OFFSETS, CommOffset, 0)
    TEST_FIELD_SIZE  (COMM_FAULT_OFFSETS, FaultOffset, 2)
    TEST_FIELD_ALIGN (COMM_FAULT_OFFSETS, FaultOffset, 2)
    TEST_FIELD_OFFSET(COMM_FAULT_OFFSETS, FaultOffset, 2)
}

static void test_pack_CS_STUB_INFO(void)
{
    /* CS_STUB_INFO */
    TEST_TYPE_SIZE   (CS_STUB_INFO, 12)
    TEST_TYPE_ALIGN  (CS_STUB_INFO, 4)
    TEST_FIELD_SIZE  (CS_STUB_INFO, WireCodeset, 4)
    TEST_FIELD_ALIGN (CS_STUB_INFO, WireCodeset, 4)
    TEST_FIELD_OFFSET(CS_STUB_INFO, WireCodeset, 0)
    TEST_FIELD_SIZE  (CS_STUB_INFO, DesiredReceivingCodeset, 4)
    TEST_FIELD_ALIGN (CS_STUB_INFO, DesiredReceivingCodeset, 4)
    TEST_FIELD_OFFSET(CS_STUB_INFO, DesiredReceivingCodeset, 4)
    TEST_FIELD_SIZE  (CS_STUB_INFO, CSArrayInfo, 4)
    TEST_FIELD_ALIGN (CS_STUB_INFO, CSArrayInfo, 4)
    TEST_FIELD_OFFSET(CS_STUB_INFO, CSArrayInfo, 8)
}

static void test_pack_EXPR_EVAL(void)
{
    /* EXPR_EVAL */
}

static void test_pack_FULL_PTR_TO_REFID_ELEMENT(void)
{
    /* FULL_PTR_TO_REFID_ELEMENT */
    TEST_TYPE_SIZE   (FULL_PTR_TO_REFID_ELEMENT, 16)
    TEST_TYPE_ALIGN  (FULL_PTR_TO_REFID_ELEMENT, 4)
    TEST_FIELD_SIZE  (FULL_PTR_TO_REFID_ELEMENT, Next, 4)
    TEST_FIELD_ALIGN (FULL_PTR_TO_REFID_ELEMENT, Next, 4)
    TEST_FIELD_OFFSET(FULL_PTR_TO_REFID_ELEMENT, Next, 0)
    TEST_FIELD_SIZE  (FULL_PTR_TO_REFID_ELEMENT, Pointer, 4)
    TEST_FIELD_ALIGN (FULL_PTR_TO_REFID_ELEMENT, Pointer, 4)
    TEST_FIELD_OFFSET(FULL_PTR_TO_REFID_ELEMENT, Pointer, 4)
    TEST_FIELD_SIZE  (FULL_PTR_TO_REFID_ELEMENT, RefId, 4)
    TEST_FIELD_ALIGN (FULL_PTR_TO_REFID_ELEMENT, RefId, 4)
    TEST_FIELD_OFFSET(FULL_PTR_TO_REFID_ELEMENT, RefId, 8)
    TEST_FIELD_SIZE  (FULL_PTR_TO_REFID_ELEMENT, State, 1)
    TEST_FIELD_ALIGN (FULL_PTR_TO_REFID_ELEMENT, State, 1)
    TEST_FIELD_OFFSET(FULL_PTR_TO_REFID_ELEMENT, State, 12)
}

static void test_pack_FULL_PTR_XLAT_TABLES(void)
{
    /* FULL_PTR_XLAT_TABLES */
}

static void test_pack_GENERIC_BINDING_INFO(void)
{
    /* GENERIC_BINDING_INFO */
    TEST_FIELD_SIZE  (GENERIC_BINDING_INFO, pObj, 4)
    TEST_FIELD_ALIGN (GENERIC_BINDING_INFO, pObj, 4)
    TEST_FIELD_OFFSET(GENERIC_BINDING_INFO, pObj, 0)
    TEST_FIELD_SIZE  (GENERIC_BINDING_INFO, Size, 4)
    TEST_FIELD_ALIGN (GENERIC_BINDING_INFO, Size, 4)
    TEST_FIELD_OFFSET(GENERIC_BINDING_INFO, Size, 4)
}

static void test_pack_GENERIC_BINDING_ROUTINE_PAIR(void)
{
    /* GENERIC_BINDING_ROUTINE_PAIR */
}

static void test_pack_MALLOC_FREE_STRUCT(void)
{
    /* MALLOC_FREE_STRUCT */
}

static void test_pack_MIDL_FORMAT_STRING(void)
{
    /* MIDL_FORMAT_STRING */
    TEST_FIELD_SIZE  (MIDL_FORMAT_STRING, Pad, 2)
    TEST_FIELD_ALIGN (MIDL_FORMAT_STRING, Pad, 2)
    TEST_FIELD_OFFSET(MIDL_FORMAT_STRING, Pad, 0)
}

static void test_pack_MIDL_SERVER_INFO(void)
{
    /* MIDL_SERVER_INFO */
    TEST_TYPE_SIZE   (MIDL_SERVER_INFO, 32)
    TEST_TYPE_ALIGN  (MIDL_SERVER_INFO, 4)
    TEST_FIELD_SIZE  (MIDL_SERVER_INFO, pStubDesc, 4)
    TEST_FIELD_ALIGN (MIDL_SERVER_INFO, pStubDesc, 4)
    TEST_FIELD_OFFSET(MIDL_SERVER_INFO, pStubDesc, 0)
    TEST_FIELD_SIZE  (MIDL_SERVER_INFO, DispatchTable, 4)
    TEST_FIELD_ALIGN (MIDL_SERVER_INFO, DispatchTable, 4)
    TEST_FIELD_OFFSET(MIDL_SERVER_INFO, DispatchTable, 4)
    TEST_FIELD_SIZE  (MIDL_SERVER_INFO, ProcString, 4)
    TEST_FIELD_ALIGN (MIDL_SERVER_INFO, ProcString, 4)
    TEST_FIELD_OFFSET(MIDL_SERVER_INFO, ProcString, 8)
    TEST_FIELD_SIZE  (MIDL_SERVER_INFO, FmtStringOffset, 4)
    TEST_FIELD_ALIGN (MIDL_SERVER_INFO, FmtStringOffset, 4)
    TEST_FIELD_OFFSET(MIDL_SERVER_INFO, FmtStringOffset, 12)
    TEST_FIELD_SIZE  (MIDL_SERVER_INFO, ThunkTable, 4)
    TEST_FIELD_ALIGN (MIDL_SERVER_INFO, ThunkTable, 4)
    TEST_FIELD_OFFSET(MIDL_SERVER_INFO, ThunkTable, 16)
    TEST_FIELD_SIZE  (MIDL_SERVER_INFO, pTransferSyntax, 4)
    TEST_FIELD_ALIGN (MIDL_SERVER_INFO, pTransferSyntax, 4)
    TEST_FIELD_OFFSET(MIDL_SERVER_INFO, pTransferSyntax, 20)
    TEST_FIELD_SIZE  (MIDL_SERVER_INFO, nCount, 4)
    TEST_FIELD_ALIGN (MIDL_SERVER_INFO, nCount, 4)
    TEST_FIELD_OFFSET(MIDL_SERVER_INFO, nCount, 24)
    TEST_FIELD_SIZE  (MIDL_SERVER_INFO, pSyntaxInfo, 4)
    TEST_FIELD_ALIGN (MIDL_SERVER_INFO, pSyntaxInfo, 4)
    TEST_FIELD_OFFSET(MIDL_SERVER_INFO, pSyntaxInfo, 28)
}

static void test_pack_MIDL_STUB_DESC(void)
{
    /* MIDL_STUB_DESC */
    TEST_FIELD_SIZE  (MIDL_STUB_DESC, RpcInterfaceInformation, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_DESC, RpcInterfaceInformation, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_DESC, RpcInterfaceInformation, 0)
}

static void test_pack_MIDL_STUB_MESSAGE(void)
{
    /* MIDL_STUB_MESSAGE */
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, RpcMsg, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, RpcMsg, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, RpcMsg, 0)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, Buffer, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, Buffer, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, Buffer, 4)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, BufferStart, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, BufferStart, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, BufferStart, 8)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, BufferEnd, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, BufferEnd, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, BufferEnd, 12)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, BufferMark, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, BufferMark, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, BufferMark, 16)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, BufferLength, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, BufferLength, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, BufferLength, 20)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, MemorySize, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, MemorySize, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, MemorySize, 24)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, Memory, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, Memory, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, Memory, 28)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, ReuseBuffer, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, ReuseBuffer, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, ReuseBuffer, 36)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, pAllocAllNodesContext, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, pAllocAllNodesContext, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, pAllocAllNodesContext, 40)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, pPointerQueueState, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, pPointerQueueState, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, pPointerQueueState, 44)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, IgnoreEmbeddedPointers, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, IgnoreEmbeddedPointers, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, IgnoreEmbeddedPointers, 48)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, PointerBufferMark, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, PointerBufferMark, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, PointerBufferMark, 52)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, CorrDespIncrement, 1)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, CorrDespIncrement, 1)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, CorrDespIncrement, 56)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, uFlags, 1)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, uFlags, 1)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, uFlags, 57)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, MaxCount, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, MaxCount, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, MaxCount, 60)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, Offset, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, Offset, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, Offset, 64)
    TEST_FIELD_SIZE  (MIDL_STUB_MESSAGE, ActualCount, 4)
    TEST_FIELD_ALIGN (MIDL_STUB_MESSAGE, ActualCount, 4)
    TEST_FIELD_OFFSET(MIDL_STUB_MESSAGE, ActualCount, 68)
}

static void test_pack_MIDL_STUBLESS_PROXY_INFO(void)
{
    /* MIDL_STUBLESS_PROXY_INFO */
    TEST_TYPE_SIZE   (MIDL_STUBLESS_PROXY_INFO, 24)
    TEST_TYPE_ALIGN  (MIDL_STUBLESS_PROXY_INFO, 4)
    TEST_FIELD_SIZE  (MIDL_STUBLESS_PROXY_INFO, pStubDesc, 4)
    TEST_FIELD_ALIGN (MIDL_STUBLESS_PROXY_INFO, pStubDesc, 4)
    TEST_FIELD_OFFSET(MIDL_STUBLESS_PROXY_INFO, pStubDesc, 0)
    TEST_FIELD_SIZE  (MIDL_STUBLESS_PROXY_INFO, ProcFormatString, 4)
    TEST_FIELD_ALIGN (MIDL_STUBLESS_PROXY_INFO, ProcFormatString, 4)
    TEST_FIELD_OFFSET(MIDL_STUBLESS_PROXY_INFO, ProcFormatString, 4)
    TEST_FIELD_SIZE  (MIDL_STUBLESS_PROXY_INFO, FormatStringOffset, 4)
    TEST_FIELD_ALIGN (MIDL_STUBLESS_PROXY_INFO, FormatStringOffset, 4)
    TEST_FIELD_OFFSET(MIDL_STUBLESS_PROXY_INFO, FormatStringOffset, 8)
    TEST_FIELD_SIZE  (MIDL_STUBLESS_PROXY_INFO, pTransferSyntax, 4)
    TEST_FIELD_ALIGN (MIDL_STUBLESS_PROXY_INFO, pTransferSyntax, 4)
    TEST_FIELD_OFFSET(MIDL_STUBLESS_PROXY_INFO, pTransferSyntax, 12)
    TEST_FIELD_SIZE  (MIDL_STUBLESS_PROXY_INFO, nCount, 4)
    TEST_FIELD_ALIGN (MIDL_STUBLESS_PROXY_INFO, nCount, 4)
    TEST_FIELD_OFFSET(MIDL_STUBLESS_PROXY_INFO, nCount, 16)
    TEST_FIELD_SIZE  (MIDL_STUBLESS_PROXY_INFO, pSyntaxInfo, 4)
    TEST_FIELD_ALIGN (MIDL_STUBLESS_PROXY_INFO, pSyntaxInfo, 4)
    TEST_FIELD_OFFSET(MIDL_STUBLESS_PROXY_INFO, pSyntaxInfo, 20)
}

static void test_pack_MIDL_SYNTAX_INFO(void)
{
    /* MIDL_SYNTAX_INFO */
    TEST_TYPE_SIZE   (MIDL_SYNTAX_INFO, 48)
    TEST_TYPE_ALIGN  (MIDL_SYNTAX_INFO, 4)
    TEST_FIELD_SIZE  (MIDL_SYNTAX_INFO, TransferSyntax, 20)
    TEST_FIELD_ALIGN (MIDL_SYNTAX_INFO, TransferSyntax, 4)
    TEST_FIELD_OFFSET(MIDL_SYNTAX_INFO, TransferSyntax, 0)
    TEST_FIELD_SIZE  (MIDL_SYNTAX_INFO, DispatchTable, 4)
    TEST_FIELD_ALIGN (MIDL_SYNTAX_INFO, DispatchTable, 4)
    TEST_FIELD_OFFSET(MIDL_SYNTAX_INFO, DispatchTable, 20)
    TEST_FIELD_SIZE  (MIDL_SYNTAX_INFO, ProcString, 4)
    TEST_FIELD_ALIGN (MIDL_SYNTAX_INFO, ProcString, 4)
    TEST_FIELD_OFFSET(MIDL_SYNTAX_INFO, ProcString, 24)
    TEST_FIELD_SIZE  (MIDL_SYNTAX_INFO, FmtStringOffset, 4)
    TEST_FIELD_ALIGN (MIDL_SYNTAX_INFO, FmtStringOffset, 4)
    TEST_FIELD_OFFSET(MIDL_SYNTAX_INFO, FmtStringOffset, 28)
    TEST_FIELD_SIZE  (MIDL_SYNTAX_INFO, TypeString, 4)
    TEST_FIELD_ALIGN (MIDL_SYNTAX_INFO, TypeString, 4)
    TEST_FIELD_OFFSET(MIDL_SYNTAX_INFO, TypeString, 32)
    TEST_FIELD_SIZE  (MIDL_SYNTAX_INFO, aUserMarshalQuadruple, 4)
    TEST_FIELD_ALIGN (MIDL_SYNTAX_INFO, aUserMarshalQuadruple, 4)
    TEST_FIELD_OFFSET(MIDL_SYNTAX_INFO, aUserMarshalQuadruple, 36)
    TEST_FIELD_SIZE  (MIDL_SYNTAX_INFO, pReserved1, 4)
    TEST_FIELD_ALIGN (MIDL_SYNTAX_INFO, pReserved1, 4)
    TEST_FIELD_OFFSET(MIDL_SYNTAX_INFO, pReserved1, 40)
    TEST_FIELD_SIZE  (MIDL_SYNTAX_INFO, pReserved2, 4)
    TEST_FIELD_ALIGN (MIDL_SYNTAX_INFO, pReserved2, 4)
    TEST_FIELD_OFFSET(MIDL_SYNTAX_INFO, pReserved2, 44)
}

static void test_pack_NDR_CCONTEXT(void)
{
    /* NDR_CCONTEXT */
    TEST_TYPE_SIZE   (NDR_CCONTEXT, 4)
    TEST_TYPE_ALIGN  (NDR_CCONTEXT, 4)
}

static void test_pack_NDR_NOTIFY_ROUTINE(void)
{
    /* NDR_NOTIFY_ROUTINE */
}

static void test_pack_NDR_NOTIFY2_ROUTINE(void)
{
    /* NDR_NOTIFY2_ROUTINE */
}

static void test_pack_NDR_RUNDOWN(void)
{
    /* NDR_RUNDOWN */
}

static void test_pack_NDR_SCONTEXT(void)
{
    /* NDR_SCONTEXT */
    TEST_TYPE_SIZE   (NDR_SCONTEXT, 4)
    TEST_TYPE_ALIGN  (NDR_SCONTEXT, 4)
}

static void test_pack_NDR_USER_MARSHAL_INFO(void)
{
    /* NDR_USER_MARSHAL_INFO */
    TEST_FIELD_SIZE  (NDR_USER_MARSHAL_INFO, InformationLevel, 4)
    TEST_FIELD_ALIGN (NDR_USER_MARSHAL_INFO, InformationLevel, 4)
    TEST_FIELD_OFFSET(NDR_USER_MARSHAL_INFO, InformationLevel, 0)
}

static void test_pack_NDR_USER_MARSHAL_INFO_LEVEL1(void)
{
    /* NDR_USER_MARSHAL_INFO_LEVEL1 */
    TEST_FIELD_SIZE  (NDR_USER_MARSHAL_INFO_LEVEL1, Buffer, 4)
    TEST_FIELD_ALIGN (NDR_USER_MARSHAL_INFO_LEVEL1, Buffer, 4)
    TEST_FIELD_OFFSET(NDR_USER_MARSHAL_INFO_LEVEL1, Buffer, 0)
    TEST_FIELD_SIZE  (NDR_USER_MARSHAL_INFO_LEVEL1, BufferSize, 4)
    TEST_FIELD_ALIGN (NDR_USER_MARSHAL_INFO_LEVEL1, BufferSize, 4)
    TEST_FIELD_OFFSET(NDR_USER_MARSHAL_INFO_LEVEL1, BufferSize, 4)
}

static void test_pack_PARRAY_INFO(void)
{
    /* PARRAY_INFO */
    TEST_TYPE_SIZE   (PARRAY_INFO, 4)
    TEST_TYPE_ALIGN  (PARRAY_INFO, 4)
    TEST_TARGET_SIZE (PARRAY_INFO, 24)
    TEST_TARGET_ALIGN(PARRAY_INFO, 4)
}

static void test_pack_PFORMAT_STRING(void)
{
    /* PFORMAT_STRING */
    TEST_TYPE_SIZE   (PFORMAT_STRING, 4)
    TEST_TYPE_ALIGN  (PFORMAT_STRING, 4)
}

static void test_pack_PFULL_PTR_TO_REFID_ELEMENT(void)
{
    /* PFULL_PTR_TO_REFID_ELEMENT */
    TEST_TYPE_SIZE   (PFULL_PTR_TO_REFID_ELEMENT, 4)
    TEST_TYPE_ALIGN  (PFULL_PTR_TO_REFID_ELEMENT, 4)
    TEST_TARGET_SIZE (PFULL_PTR_TO_REFID_ELEMENT, 16)
    TEST_TARGET_ALIGN(PFULL_PTR_TO_REFID_ELEMENT, 4)
}

static void test_pack_PFULL_PTR_XLAT_TABLES(void)
{
    /* PFULL_PTR_XLAT_TABLES */
    TEST_TYPE_SIZE   (PFULL_PTR_XLAT_TABLES, 4)
    TEST_TYPE_ALIGN  (PFULL_PTR_XLAT_TABLES, 4)
}

static void test_pack_PGENERIC_BINDING_INFO(void)
{
    /* PGENERIC_BINDING_INFO */
    TEST_TYPE_SIZE   (PGENERIC_BINDING_INFO, 4)
    TEST_TYPE_ALIGN  (PGENERIC_BINDING_INFO, 4)
}

static void test_pack_PGENERIC_BINDING_ROUTINE_PAIR(void)
{
    /* PGENERIC_BINDING_ROUTINE_PAIR */
    TEST_TYPE_SIZE   (PGENERIC_BINDING_ROUTINE_PAIR, 4)
    TEST_TYPE_ALIGN  (PGENERIC_BINDING_ROUTINE_PAIR, 4)
}

static void test_pack_PMIDL_SERVER_INFO(void)
{
    /* PMIDL_SERVER_INFO */
    TEST_TYPE_SIZE   (PMIDL_SERVER_INFO, 4)
    TEST_TYPE_ALIGN  (PMIDL_SERVER_INFO, 4)
    TEST_TARGET_SIZE (PMIDL_SERVER_INFO, 32)
    TEST_TARGET_ALIGN(PMIDL_SERVER_INFO, 4)
}

static void test_pack_PMIDL_STUB_DESC(void)
{
    /* PMIDL_STUB_DESC */
    TEST_TYPE_SIZE   (PMIDL_STUB_DESC, 4)
    TEST_TYPE_ALIGN  (PMIDL_STUB_DESC, 4)
}

static void test_pack_PMIDL_STUB_MESSAGE(void)
{
    /* PMIDL_STUB_MESSAGE */
    TEST_TYPE_SIZE   (PMIDL_STUB_MESSAGE, 4)
    TEST_TYPE_ALIGN  (PMIDL_STUB_MESSAGE, 4)
}

static void test_pack_PMIDL_STUBLESS_PROXY_INFO(void)
{
    /* PMIDL_STUBLESS_PROXY_INFO */
    TEST_TYPE_SIZE   (PMIDL_STUBLESS_PROXY_INFO, 4)
    TEST_TYPE_ALIGN  (PMIDL_STUBLESS_PROXY_INFO, 4)
    TEST_TARGET_SIZE (PMIDL_STUBLESS_PROXY_INFO, 24)
    TEST_TARGET_ALIGN(PMIDL_STUBLESS_PROXY_INFO, 4)
}

static void test_pack_PMIDL_SYNTAX_INFO(void)
{
    /* PMIDL_SYNTAX_INFO */
    TEST_TYPE_SIZE   (PMIDL_SYNTAX_INFO, 4)
    TEST_TYPE_ALIGN  (PMIDL_SYNTAX_INFO, 4)
    TEST_TARGET_SIZE (PMIDL_SYNTAX_INFO, 48)
    TEST_TARGET_ALIGN(PMIDL_SYNTAX_INFO, 4)
}

static void test_pack_PNDR_ASYNC_MESSAGE(void)
{
    /* PNDR_ASYNC_MESSAGE */
    TEST_TYPE_SIZE   (PNDR_ASYNC_MESSAGE, 4)
    TEST_TYPE_ALIGN  (PNDR_ASYNC_MESSAGE, 4)
}

static void test_pack_PNDR_CORRELATION_INFO(void)
{
    /* PNDR_CORRELATION_INFO */
    TEST_TYPE_SIZE   (PNDR_CORRELATION_INFO, 4)
    TEST_TYPE_ALIGN  (PNDR_CORRELATION_INFO, 4)
}

static void test_pack_PSCONTEXT_QUEUE(void)
{
    /* PSCONTEXT_QUEUE */
    TEST_TYPE_SIZE   (PSCONTEXT_QUEUE, 4)
    TEST_TYPE_ALIGN  (PSCONTEXT_QUEUE, 4)
    TEST_TARGET_SIZE (PSCONTEXT_QUEUE, 8)
    TEST_TARGET_ALIGN(PSCONTEXT_QUEUE, 4)
}

static void test_pack_PXMIT_ROUTINE_QUINTUPLE(void)
{
    /* PXMIT_ROUTINE_QUINTUPLE */
    TEST_TYPE_SIZE   (PXMIT_ROUTINE_QUINTUPLE, 4)
    TEST_TYPE_ALIGN  (PXMIT_ROUTINE_QUINTUPLE, 4)
}

static void test_pack_SCONTEXT_QUEUE(void)
{
    /* SCONTEXT_QUEUE */
    TEST_TYPE_SIZE   (SCONTEXT_QUEUE, 8)
    TEST_TYPE_ALIGN  (SCONTEXT_QUEUE, 4)
    TEST_FIELD_SIZE  (SCONTEXT_QUEUE, NumberOfObjects, 4)
    TEST_FIELD_ALIGN (SCONTEXT_QUEUE, NumberOfObjects, 4)
    TEST_FIELD_OFFSET(SCONTEXT_QUEUE, NumberOfObjects, 0)
    TEST_FIELD_SIZE  (SCONTEXT_QUEUE, ArrayOfObjects, 4)
    TEST_FIELD_ALIGN (SCONTEXT_QUEUE, ArrayOfObjects, 4)
    TEST_FIELD_OFFSET(SCONTEXT_QUEUE, ArrayOfObjects, 4)
}

static void test_pack_SERVER_ROUTINE(void)
{
    /* SERVER_ROUTINE */
}

static void test_pack_STUB_THUNK(void)
{
    /* STUB_THUNK */
}

static void test_pack_USER_MARSHAL_CB(void)
{
    /* USER_MARSHAL_CB */
    TEST_FIELD_SIZE  (USER_MARSHAL_CB, Flags, 4)
    TEST_FIELD_ALIGN (USER_MARSHAL_CB, Flags, 4)
    TEST_FIELD_OFFSET(USER_MARSHAL_CB, Flags, 0)
    TEST_FIELD_SIZE  (USER_MARSHAL_CB, pStubMsg, 4)
    TEST_FIELD_ALIGN (USER_MARSHAL_CB, pStubMsg, 4)
    TEST_FIELD_OFFSET(USER_MARSHAL_CB, pStubMsg, 4)
    TEST_FIELD_SIZE  (USER_MARSHAL_CB, pReserve, 4)
    TEST_FIELD_ALIGN (USER_MARSHAL_CB, pReserve, 4)
    TEST_FIELD_OFFSET(USER_MARSHAL_CB, pReserve, 8)
    TEST_FIELD_SIZE  (USER_MARSHAL_CB, Signature, 4)
    TEST_FIELD_ALIGN (USER_MARSHAL_CB, Signature, 4)
    TEST_FIELD_OFFSET(USER_MARSHAL_CB, Signature, 12)
}

static void test_pack_USER_MARSHAL_FREEING_ROUTINE(void)
{
    /* USER_MARSHAL_FREEING_ROUTINE */
}

static void test_pack_USER_MARSHAL_MARSHALLING_ROUTINE(void)
{
    /* USER_MARSHAL_MARSHALLING_ROUTINE */
}

static void test_pack_USER_MARSHAL_ROUTINE_QUADRUPLE(void)
{
    /* USER_MARSHAL_ROUTINE_QUADRUPLE */
}

static void test_pack_USER_MARSHAL_SIZING_ROUTINE(void)
{
    /* USER_MARSHAL_SIZING_ROUTINE */
}

static void test_pack_USER_MARSHAL_UNMARSHALLING_ROUTINE(void)
{
    /* USER_MARSHAL_UNMARSHALLING_ROUTINE */
}

static void test_pack_XMIT_HELPER_ROUTINE(void)
{
    /* XMIT_HELPER_ROUTINE */
}

static void test_pack_XMIT_ROUTINE_QUINTUPLE(void)
{
    /* XMIT_ROUTINE_QUINTUPLE */
}

static void test_pack_PRPC_STUB_FUNCTION(void)
{
    /* PRPC_STUB_FUNCTION */
}

#endif /* _WIN64 */

static void test_pack(void)
{
    test_pack_ARRAY_INFO();
    test_pack_COMM_FAULT_OFFSETS();
    test_pack_CS_STUB_INFO();
    test_pack_EXPR_EVAL();
    test_pack_FULL_PTR_TO_REFID_ELEMENT();
    test_pack_FULL_PTR_XLAT_TABLES();
    test_pack_GENERIC_BINDING_INFO();
    test_pack_GENERIC_BINDING_ROUTINE_PAIR();
    test_pack_I_RPC_HANDLE();
    test_pack_MALLOC_FREE_STRUCT();
    test_pack_MIDL_FORMAT_STRING();
    test_pack_MIDL_SERVER_INFO();
    test_pack_MIDL_STUBLESS_PROXY_INFO();
    test_pack_MIDL_STUB_DESC();
    test_pack_MIDL_STUB_MESSAGE();
    test_pack_MIDL_SYNTAX_INFO();
    test_pack_NDR_CCONTEXT();
    test_pack_NDR_NOTIFY2_ROUTINE();
    test_pack_NDR_NOTIFY_ROUTINE();
    test_pack_NDR_RUNDOWN();
    test_pack_NDR_SCONTEXT();
    test_pack_NDR_USER_MARSHAL_INFO();
    test_pack_NDR_USER_MARSHAL_INFO_LEVEL1();
    test_pack_PARRAY_INFO();
    test_pack_PFORMAT_STRING();
    test_pack_PFULL_PTR_TO_REFID_ELEMENT();
    test_pack_PFULL_PTR_XLAT_TABLES();
    test_pack_PGENERIC_BINDING_INFO();
    test_pack_PGENERIC_BINDING_ROUTINE_PAIR();
    test_pack_PMIDL_SERVER_INFO();
    test_pack_PMIDL_STUBLESS_PROXY_INFO();
    test_pack_PMIDL_STUB_DESC();
    test_pack_PMIDL_STUB_MESSAGE();
    test_pack_PMIDL_SYNTAX_INFO();
    test_pack_PNDR_ASYNC_MESSAGE();
    test_pack_PNDR_CORRELATION_INFO();
    test_pack_PRPC_CLIENT_INTERFACE();
    test_pack_PRPC_DISPATCH_TABLE();
    test_pack_PRPC_MESSAGE();
    test_pack_PRPC_POLICY();
    test_pack_PRPC_PROTSEQ_ENDPOINT();
    test_pack_PRPC_SERVER_INTERFACE();
    test_pack_PRPC_STUB_FUNCTION();
    test_pack_PRPC_SYNTAX_IDENTIFIER();
    test_pack_PSCONTEXT_QUEUE();
    test_pack_PXMIT_ROUTINE_QUINTUPLE();
    test_pack_RPC_AUTHZ_HANDLE();
    test_pack_RPC_AUTH_IDENTITY_HANDLE();
    test_pack_RPC_AUTH_KEY_RETRIEVAL_FN();
    test_pack_RPC_BINDING_HANDLE();
    test_pack_RPC_BINDING_VECTOR();
    test_pack_RPC_CLIENT_INTERFACE();
    test_pack_RPC_DISPATCH_FUNCTION();
    test_pack_RPC_DISPATCH_TABLE();
    test_pack_RPC_IF_HANDLE();
    test_pack_RPC_IF_ID();
    test_pack_RPC_MESSAGE();
    test_pack_RPC_POLICY();
    test_pack_RPC_PROTSEQ_ENDPOINT();
    test_pack_RPC_SERVER_INTERFACE();
    test_pack_RPC_STATUS();
    test_pack_RPC_SYNTAX_IDENTIFIER();
    test_pack_RPC_VERSION();
    test_pack_SCONTEXT_QUEUE();
    test_pack_SERVER_ROUTINE();
    test_pack_STUB_THUNK();
    test_pack_USER_MARSHAL_CB();
    test_pack_USER_MARSHAL_FREEING_ROUTINE();
    test_pack_USER_MARSHAL_MARSHALLING_ROUTINE();
    test_pack_USER_MARSHAL_ROUTINE_QUADRUPLE();
    test_pack_USER_MARSHAL_SIZING_ROUTINE();
    test_pack_USER_MARSHAL_UNMARSHALLING_ROUTINE();
    test_pack_UUID_VECTOR();
    test_pack_XMIT_HELPER_ROUTINE();
    test_pack_XMIT_ROUTINE_QUINTUPLE();
}

START_TEST(generated)
{
    test_pack();
}
