#ifndef DOWNLOAD_IMAGE_H
#define DOWNLOAD_IMAGE_H

/*
  This file is part of "WhoAmI" - A "Guess whats on the photo" riddle game.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Dlg/Progress.h>

#include "Image.h"

class DownloadImageTask : public Lum::Dlg::ProgressTask
{
private:
  std::string buffer;
  std::string error;
  Image*      image;

public:
  DownloadImageTask();

  void SetImage(Image* image);

  void Run();

  void AppendToBuffer(const char* text, size_t size);

  bool HasError() const;
  std::wstring GetError() const;
};

#endif

