#ifndef MAINWINDOW_H
#define MAINWINDOW_H

/****************************************************************************
**
** Copyright (C) 2009 Alvaro Manera.
** Contact: alblurrow@yute.com
**
** This file is part of weiight program
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 or 3.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.fsf.org/licensing/licenses/info/GPLv2.html and
** http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/


#include <QtGui/QMainWindow>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QPushButton>
#include <QLabel>
#include "balanceboard.h"
#include "digits.h"


class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:

    QHBoxLayout *buttonsLayout;
    QHBoxLayout *digitsLayout;
    QVBoxLayout *globalLayout;
    QPushButton *connectButton;
    QPushButton *weightButton;
    QPushButton *disconnectButton;
    QLabel *msgLabel;

    BalanceBoard  board;
    Digits  *integer;
    Digits  *decimal;

private slots:
    void connectClicked();
    void weightClicked();
    void disconnectClicked();

    void weightDone(float weight);
    void initDone();
    void closeDone();
    void error(int error);
    void toggleBusy(int checkState);
    void about();
};

#endif // MAINWINDOW_H
