#ifndef UTIL_H
#define UTIL_H

/*
  This file is part of "WeightJinni" - A program to control your weight.
  Copyright (C) 2007  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <string>

#include <Lum/Dlg/Validator.h>

#include "Configuration.h"

extern bool StringToValue(const std::wstring& string, Value& value);
extern std::wstring ValueToString(Value value);

extern bool StringToAmount(const std::wstring& string, size_t& amount);
extern std::wstring AmountToString(size_t amount);

class AmountValidator : public Lum::Dlg::InputValidator
{
public:
  bool IsValid(Lum::Base::Model* value) const;
};

class ValueValidator : public Lum::Dlg::InputValidator
{
public:
  bool IsValid(Lum::Base::Model* value) const;
};

#endif
