/*
  This file is part of "WeightJinni" - A program to control your weight.
  Copyright (C) 2008  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "Preferences.h"

#include <Lum/Base/L10N.h>

#include <Lum/Def/OneOfMany.h>

#include <Lum/Manager/Behaviour.h>

#include <Lum/ButtonRow.h>
#include <Lum/Combo.h>
#include <Lum/Label.h>
#include <Lum/Panel.h>
#include <Lum/String.h>
#include <Lum/Tab.h>
#include <Lum/Text.h>

#include "Configuration.h"
#include "Util.h"

Preferences::Preferences()
: okAction(new Lum::Model::Action()),

  topWeight(new Lum::Model::String(AmountToString(::topWeight->Get()))),
  bottomWeight(new Lum::Model::String(AmountToString(::bottomWeight->Get()))),
  maxWeight(new Lum::Model::String(AmountToString(::maxWeight->Get()))),
  minWeight(new Lum::Model::String(AmountToString(::minWeight->Get()))),

  topValue(new Lum::Model::String(AmountToString(::topValue->Get()))),
  bottomValue(new Lum::Model::String(AmountToString(::bottomValue->Get()))),
  maxValue(new Lum::Model::String(AmountToString(::maxValue->Get()))),
  minValue(new Lum::Model::String(AmountToString(::minValue->Get()))),
  goodValueLimit(new Lum::Model::String(ValueToString(::goodValueLimit->Get()))),
  badValueLimit(new Lum::Model::String(ValueToString(::badValueLimit->Get()))),
  refValue(new Lum::Model::String(ValueToString(::refValue->Get()))),
  valueUnit(new Lum::Model::String(::valueUnit->Get())),
  weightUnit(new Lum::Model::String(::weightUnit->Get()))
{
  trendType->Push();
  trendDirection->Push();

  Observe(okAction);

  Observe(topWeight);
  Observe(bottomWeight);
  Observe(maxWeight);
  Observe(minWeight);

  Observe(topValue);
  Observe(bottomValue);
  Observe(maxValue);
  Observe(minValue);
  Observe(goodValueLimit);
  Observe(badValueLimit);

  Observe(refValue);

  Observe(valueUnit);
  Observe(weightUnit);

  SetExitAction(GetClosedAction());
}

Preferences::~Preferences()
{
  trendDirection->Pop();
  trendType->Pop();
}

Lum::Object* Preferences::GetContent()
{
  Lum::Label                 *label;
  Lum::Panel                 *panel,*panel2;
  Lum::String                *string;
  Lum::Tab                   *tab;
  Lum::Model::StringTableRef table;

  panel=Lum::VPanel::Create(true,false);

  tab=Lum::Tab::Create(true,false);

  label=Lum::Label::Create(true,true);
  label->AddLabel(_(L"PREFS_LABEL_VALUE_UNIT",L"Value unit:"),Lum::String::Create(valueUnit,10u));
  label->AddLabel(_(L"PREFS_LABEL_WEIGHT_UNIT",L"Weight unit:"),Lum::String::Create(weightUnit,10u));

  tab->Add(_(L"PREFS_LABEL_UNITS",L"Units"),label);

  label=Lum::Label::Create(true,true);

  panel2=new Lum::HPanel();

  string=new Lum::String();
  string->SetMinWidth(Lum::Base::Size::stdCharWidth,5);
  string->SetAlignment(Lum::String::right);
  string->SetInputTypeHint(Lum::Object::inputTypeSignedFloatNumber);
  string->SetModel(bottomWeight);
  panel2->Add(string);

  panel2->AddSpace();
  panel2->Add(new Lum::Text(L"-"));
  panel2->AddSpace();

  string=new Lum::String();
  string->SetMinWidth(Lum::Base::Size::stdCharWidth,5);
  string->SetAlignment(Lum::String::right);
  string->SetInputTypeHint(Lum::Object::inputTypeSignedFloatNumber);
  string->SetModel(topWeight);
  panel2->Add(string);

  label->AddLabel(_(L"PREFS_LABEL_WEIGHT_GRAPH",L"Shown interval:"),panel2);

  panel2=Lum::HPanel::Create();

  string=new Lum::String();
  string->SetMinWidth(Lum::Base::Size::stdCharWidth,5);
  string->SetAlignment(Lum::String::right);
  string->SetInputTypeHint(Lum::Object::inputTypeSignedFloatNumber);
  string->SetModel(minWeight);
  panel2->Add(string);

  panel2->AddSpace();
  panel2->Add(new Lum::Text(L"-"));
  panel2->AddSpace();

  string=new Lum::String();
  string->SetMinWidth(Lum::Base::Size::stdCharWidth,5);
  string->SetAlignment(Lum::String::right);
  string->SetInputTypeHint(Lum::Object::inputTypeSignedFloatNumber);
  string->SetModel(maxWeight);
  panel2->Add(string);
  label->AddLabel(_(L"PREFS_LABEL_WEIGHT_LIMIT",L"Target range:"),panel2);

  tab->Add(_(L"PREFS_LABEL_WEIGHTS",L"Weights"),label);

  label=Lum::Label::Create(true,true);

  panel2=Lum::HPanel::Create();

  string=new Lum::String();
  string->SetMinWidth(Lum::Base::Size::stdCharWidth,4);
  string->SetAlignment(Lum::String::right);
  string->SetInputTypeHint(Lum::Object::inputTypeSignedFloatNumber);
  string->SetModel(bottomValue);
  panel2->Add(string);

  panel2->AddSpace();
  panel2->Add(new Lum::Text(L"-"));
  panel2->AddSpace();

  string=new Lum::String();
  string->SetMinWidth(Lum::Base::Size::stdCharWidth,4);
  string->SetAlignment(Lum::String::right);
  string->SetInputTypeHint(Lum::Object::inputTypeSignedFloatNumber);
  string->SetModel(topValue);
  panel2->Add(string);

  label->AddLabel(_(L"PREFS_LABEL_VALUE_GRAPH",L"Shown interval:"),panel2);

  panel2=new Lum::HPanel();

  string=new Lum::String();
  string->SetMinWidth(Lum::Base::Size::stdCharWidth,4);
  string->SetAlignment(Lum::String::right);
  string->SetInputTypeHint(Lum::Object::inputTypeSignedFloatNumber);
  string->SetModel(minValue);
  panel2->Add(string);

  panel2->AddSpace();
  panel2->Add(new Lum::Text(L"-"));
  panel2->AddSpace();

  string=new Lum::String();
  string->SetMinWidth(Lum::Base::Size::stdCharWidth,4);
  string->SetAlignment(Lum::String::right);
  string->SetInputTypeHint(Lum::Object::inputTypeSignedFloatNumber);
  string->SetModel(maxValue);
  panel2->Add(string);

  label->AddLabel(_(L"PREFS_LABEL_VALUE_LIMIT",L"Target range:"),panel2);

  string=new Lum::String();
  string->SetMinWidth(Lum::Base::Size::stdCharWidth,4);
  string->SetAlignment(Lum::String::right);
  string->SetInputTypeHint(Lum::Object::inputTypeSignedFloatNumber);
  string->SetModel(goodValueLimit);
  label->AddLabel(_(L"PREFS_LABEL_GOOD_VALUE_LIMIT",L"Good value limit:"),string);

  string=new Lum::String();
  string->SetMinWidth(Lum::Base::Size::stdCharWidth,4);
  string->SetAlignment(Lum::String::right);
  string->SetInputTypeHint(Lum::Object::inputTypeSignedFloatNumber);
  string->SetModel(badValueLimit);
  label->AddLabel(_(L"PREFS_LABEL_BAD_VALUE_LIMIT",L"Bad value limit:"),string);

  tab->Add(_(L"PREFS_LABEL_VALUES",L"Values"),label);

  label=Lum::Label::Create(true,true);

  string=new Lum::String();
  string->SetMinWidth(Lum::Base::Size::stdCharWidth,4);
  string->SetAlignment(Lum::String::right);
  string->SetInputTypeHint(Lum::Object::inputTypeSignedFloatNumber);
  string->SetModel(refValue);
  label->AddLabel(_(L"PREFS_LABEL_REF_VALUE",L"Reference for trend:"),string);

  table=new Lum::Model::StringTable();
  table->Append(_(L"PREFS_LABEL_TREND_TYPE_REFREL",L"Relative to reference"));
  table->Append(_(L"PREFS_LABEL_TREND_TYPE_TWOWEEK",L"2 week trend"));

  Lum::Def::OneOfMany trendTypeDef(Lum::Def::Desc(L"Trend type"),
                                   trendType,table);

  label->AddLabel(_(L"PREFS_LABEL_TREND_TYPE",L"Trend type:"),
                  Lum::Manager::Behaviour::Instance()->GetOneOfManyControl(trendTypeDef,true,false));

  table=new Lum::Model::StringTable();
  table->Append(_(L"PREFS_LABEL_TREND_DIR_DOWN",L"Lower is better"));
  table->Append(_(L"PREFS_LABEL_TREND_DIR_UP",L"Higher is better"));

  Lum::Def::OneOfMany trendDirDef(Lum::Def::Desc(L"Trend direction"),
                                  trendDirection,table);

  label->AddLabel(_(L"PREFS_LABEL_TREND_DIR",L"Trend direction:"),
  Lum::Manager::Behaviour::Instance()->GetOneOfManyControl(trendDirDef,true,false));

  tab->Add(_(L"PREFS_LABEL_TREND",L"Trend"),label);

  panel->Add(tab);

  return panel;
}

void Preferences::GetActions(std::vector<Lum::Dlg::ActionInfo>& actions)
{
  Lum::Dlg::ActionDialog::CreateActionInfosOkCancel(actions,okAction,GetClosedAction());
}

void Preferences::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
{
  if (model==topWeight ||
      model==bottomWeight ||
      model==maxWeight ||
      model==minWeight ||
      model==topValue ||
      model==bottomValue ||
      model==maxValue ||
      model==minValue ||
      model==goodValueLimit ||
      model==badValueLimit) {
    size_t topW,bottomW,topV,bottomV,gVL,bVL,tmp;

    if (StringToAmount(topWeight->Get(),topW) &&
        StringToAmount(bottomWeight->Get(),bottomW) &&
        StringToAmount(maxWeight->Get(),tmp) &&
        StringToAmount(minWeight->Get(),tmp) &&
        StringToAmount(topValue->Get(),topV) &&
        StringToAmount(bottomValue->Get(),bottomV) &&
        StringToAmount(maxValue->Get(),tmp) &&
        StringToAmount(minValue->Get(),tmp) &&
        StringToAmount(goodValueLimit->Get(),gVL) &&
        StringToAmount(badValueLimit->Get(),bVL) &&
        StringToAmount(refValue->Get(),tmp) &&
        topW>bottomW &&
        topV>bottomV &&
        gVL<bVL) {
      okAction->Enable();
    }
    else {
      okAction->Disable();
    }
  }
  else if (model==okAction && okAction->IsFinished()) {
    size_t topW,bottomW,maxW,minW,topV,bottomV,maxV,minV,goodVL,badVL,refV;

    assert(StringToAmount(topWeight->Get(),topW) &&
           StringToAmount(bottomWeight->Get(),bottomW) &&
           StringToAmount(maxWeight->Get(),maxW) &&
           StringToAmount(minWeight->Get(),minW) &&
           StringToAmount(topValue->Get(),topV) &&
           StringToAmount(bottomValue->Get(),bottomV) &&
           StringToAmount(maxValue->Get(),maxV) &&
           StringToAmount(minValue->Get(),minV) &&
           StringToAmount(goodValueLimit->Get(),goodVL) &&
           StringToAmount(badValueLimit->Get(),badVL) &&
           StringToAmount(refValue->Get(),refV));

    ::valueUnit->Set(valueUnit->Get());
    ::weightUnit->Set(weightUnit->Get());

    ::topWeight->Set(topW);
    ::bottomWeight->Set(bottomW);
    ::maxWeight->Set(maxW);
    ::minWeight->Set(minW);

    ::topValue->Set(topV);
    ::bottomValue->Set(bottomV);
    ::maxValue->Set(maxV);
    ::minValue->Set(minV);
    ::goodValueLimit->Set(goodVL);
    ::badValueLimit->Set(badVL);

    ::refValue->Set(refV);

    trendType->Save();
    trendDirection->Save();

    Exit();
  }

  Dialog::Resync(model,msg);
}
