#ifndef DIAGRAM_H
#define DIAGRAM_H

/*
  This file is part of "WeightJinni" - A program to control your weight.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Object.h>

class Diagram : public Lum::Scrollable
{
private:
  enum Mode {
    modeFullDay  = 0,
    modeSmallDay = 1,
    modeOverview = 2,
    modeMax      =2
  };

private:
  Lum::OS::ColorRef backgroundColor;
  Lum::OS::ColorRef warnColor;
  Lum::OS::ColorRef limitColor;
  Lum::OS::ColorRef valueGoodColor;
  Lum::OS::ColorRef valueGoodFrameColor;
  Lum::OS::ColorRef valueBadColor;
  Lum::OS::ColorRef valueBadFrameColor;
  Lum::OS::ColorRef labelColor;
  Lum::OS::ColorRef scaleColor;

  Lum::OS::FontRef  font;

  size_t            fullDayWidth;
  size_t            smallDayWidth;
  size_t            weightUnitWidth;
  size_t            valueUnitWidth;

  int               gestureStartX;
  int               gestureStartY;

  Mode              mode;

  void UpdateDimensions();

  int TransformWeight(double y);
  int TransformValue(double y);
  size_t GetDayWidth() const;

  void PrintData(Lum::OS::DrawInfo* draw,
                 size_t dayWidth,
                 const Lum::Base::Calendar& start,
                 const Lum::Base::Calendar& end);
  void PrintHorizontalLabel(Lum::OS::DrawInfo* draw,
                            size_t dayWidth,
                            const Lum::Base::Calendar& start);
  void PrintVerticalScale(Lum::OS::DrawInfo* draw,
                          size_t dayWidth,
                          const Lum::Base::Calendar& start);
  void PrintVerticalLabel(Lum::OS::DrawInfo* draw);
  void PrintLimits(Lum::OS::DrawInfo* draw);
  void SyncGraphWithDate();

public:
  Diagram();

  bool RequiresKnobs() const;

  //bool SetModel(Lum::Base::Model* model);

  void CalcSize();
  void GetDimension(size_t& width, size_t& height);
  void Layout();
  void Draw(Lum::OS::DrawInfo* draw,
            int x, int y, size_t w, size_t h);

  bool HandleMouseEvent(const Lum::OS::MouseEvent& event);

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);
};

#endif
