#ifndef CONFIGURATION_H
#define CONFIGURATION_H

/*
  This file is part of "WeightJinni" - A program to control your weight.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <map>
#include <set>

#include <Lum/Base/DateTime.h>

#include <Lum/Model/Adjustment.h>
#include <Lum/Model/Calendar.h>
#include <Lum/Model/Number.h>
#include <Lum/Model/String.h>
#include <Lum/Model/Time.h>

typedef signed long Value;

enum TrendType {
  trendRefRel   = 1,
  trendTwoWeeks = 2
};

class Entry
{
public:
  Lum::Base::Time time;
  std::wstring    item; // if name.empty() this is a weight value
  std::wstring    unit;
  Value           value;
  size_t          amount;

public:
  bool operator==(const Entry& entry) const;
};

class Day
{
public:
  std::list<Entry> entries;
};

class Food
{
public:
  std::wstring name;
  std::wstring unit;
  Value        value;

public:
  bool IsIdentical(const Food& entry) const;

  bool operator==(const Food& entry) const;
  bool operator<(const Food& entry) const;
};

class Data
{
public:
  std::map<Lum::Base::Calendar,Day*> data;
  std::set<Food>                     foods;

public:
  Day* GetDay(const Lum::Base::Calendar& date) const;
  size_t GetDaysCovered() const;
  const Lum::Base::Calendar GetStartDate() const;
  const Lum::Base::Calendar GetEndDate() const;

  const Food* AddFood(const Food& food);
  void DeleteFood(const Food& name);

  Entry* AddEntry(const Lum::Base::Calendar& date, const Entry& entry);
  void DeleteEntry(const Lum::Base::Calendar& date, const Entry* entry);
};

extern Data                      data;

extern Lum::Model::CalendarRef   date;
extern Lum::Model::TimeRef       timestamp;

extern Lum::Model::ULongRef      currentTab;

// Weight range of diagram
extern Lum::Model::ULongRef      topWeight;
extern Lum::Model::ULongRef      bottomWeight;
// Weight limit for "good" values in diagram
extern Lum::Model::ULongRef      maxWeight;
extern Lum::Model::ULongRef      minWeight;

// Value range of diagram
extern Lum::Model::ULongRef      topValue;
extern Lum::Model::ULongRef      bottomValue;
// Value limit for "good" values in diagram
extern Lum::Model::ULongRef      maxValue;
extern Lum::Model::ULongRef      minValue;

// Valze limit for "good" values in food list
extern Lum::Model::ULongRef      goodValueLimit;
extern Lum::Model::ULongRef      badValueLimit;

// Start value for trend
extern Lum::Model::ULongRef      refValue;

extern Lum::Model::StringRef     valueUnit;
extern Lum::Model::StringRef     weightUnit;

// trend type
extern Lum::Model::ULongRef      trendType;
extern Lum::Model::ULongRef      trendDirection;

extern bool LoadConfig(const std::wstring& file);

extern bool SaveConfig(const std::wstring& file);

#endif
