/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the Graphics Dojo project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#ifndef WIDGET_H
#define WIDGET_H

#include <QWidget>
#include <QPixmap>
#include <QMap>
#include <QSettings>
 #include <QNetworkReply>

class QPaintEvent;
//class QSvgRenderer;
class QResizeEvent;
class QPushButton;
class QTimer;
class QNetworkAccessManager;
class QNetworkReply;
class QUrl;
class QFile;
class QSettings;
class QSlider;


 struct Cam_s {
     QString nick;
     QString address;
     QString username, password;
     int    updateIntervall;
     QByteArray lastImage;

     Cam_s(QString _nik, QString _addr):nick(_nik),address(_addr)
     {
         updateIntervall = 10; //default value
     }

     Cam_s(const QString& _nik, const QString& _addr,
           const QString& _username, const QString _password,
           const int& _updateIntervall,
           const QByteArray& _lastImage):
        nick(_nik),address(_addr),
        username(_username), password(_password),
        updateIntervall(_updateIntervall),
        lastImage(_lastImage)
        {
         if(updateIntervall<0) updateIntervall = 10;
        }
 };

 /*struct loadProcess{
     QNetworkReply* reply;
     QByteArray     replyData;
 }*/


class Widget : public QWidget
{
    Q_OBJECT
public:
    Widget();
    ~Widget();

protected:
    virtual void paintEvent(QPaintEvent *e);
    virtual void resizeEvent(QResizeEvent *e);


    virtual void mouseDoubleClickEvent( QMouseEvent * event );

    void downloadFile(QUrl url);
    void refreshLabels(bool online);
    void download(const QUrl &url);
    void changeCamera();


private slots:
    void timerHandler();
    void timerInfoHandler();
    void downloadProgress(qint64,qint64);
    void activateConnection(bool toggle);

    void prevCamera();
    void nextCamera();

    void replyFinished(QNetworkReply*);
    void replyError(QNetworkReply::NetworkError);


private:
    //QSvgRenderer *renderer;
    QPixmap         cache;
    bool            dirty;
    QList<Cam_s>    m_camList;
    QList<Cam_s>::iterator m_currentCam;
    int             m_currentCamIndex;
    QTimer          *timer,*timerInfo;


    QPushButton     *runButton;
    QPushButton     *nextButton;
    QPushButton     *prevButton;
    QSlider         *progressSlider;


    int             m_refreshInterval;

    bool            m_loadingInProcess;
    bool            m_cameraChangedWhenLoadingProcess;

    QSettings       *m_settings;
    bool            m_showInfo;
    int             m_showInfoTimeout;
    const QByteArray      *m_pImageData;

    QNetworkAccessManager *m_networkmanager;

    QList<QNetworkReply*> m_networkReplyList;

    bool            x11Event ( XEvent * event );
};

#endif
