
#include <QInputDialog>

#include "settingsdialog.h"
#include "ui_settingsdialog.h"

SettingsDialog::SettingsDialog(QList<Cam_s>* pList, QWidget *parent) :
    QDialog(parent),
    m_ui(new Ui::SettingsDialog)
{
    m_ui->setupUi(this);

    this->setWindowTitle(tr("Webcam viewer settings"));

    m_pCamList = pList;
    currentItem = 0;

    for ( int i = 0 ; i < m_pCamList->size(); i++ ) {
            m_ui->listWidget->addItem( m_pCamList->at(i).nick );
    }

}

SettingsDialog::~SettingsDialog()
{
    delete m_ui;
}

void SettingsDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

/** Nick selected */
void SettingsDialog::on_listWidget_itemPressed(QListWidgetItem* item)
{
    const Cam_s *p = FindByNick( item->text() );
    if(p)
    {
        m_ui->url->setText(p->address);
        m_ui->horizontalSlider->setValue( p->updateIntervall );
        currentItem = item;
    }
}
/** Find cam structure by nick name */
const Cam_s* SettingsDialog::FindByNick(QString nick)
{
    int i=-1;
    if(FindByNick(nick, i))return &(m_pCamList->at(i));
    return 0;
}
/** Find cam structure index by nick name */
bool SettingsDialog::FindByNick(QString nick_, int& index)
{
    for ( int i = 0 ; i < m_pCamList->size(); i++ ) {
         if(nick_==m_pCamList->at(i).nick )
         {
             index= i;
             return true;
         }
    }
    return false;
}
/** Change Nick by double click */
void SettingsDialog::on_listWidget_itemDoubleClicked(QListWidgetItem* item)
{
    bool ok=false;
    QString text, old = item->text();
    text = QInputDialog::getText(this, tr("Change nick name"), tr("New nick:"), QLineEdit::Normal, old, &ok );
    if ( ok )
    {
        Cam_s* p = (Cam_s*)FindByNick(old);
        if(p) p->nick = text;
        item->setText(text);
    }
}

void SettingsDialog::on_buttonBox_clicked(QAbstractButton* button)
{
    //buttom->
}

void SettingsDialog::saveItems()
{

}
/** Refreshrate changed */
void SettingsDialog::on_horizontalSlider_valueChanged(int value)
{
    m_ui->refreshRate->setText( QString("%1").arg(value) );
    m_ui->buttonSaveUrl->setEnabled(true);

}
/** button Remove cam clicked */
void SettingsDialog::on_buttonRemove_clicked()
{
    if( currentItem!=0 )
    {
        int index;
        FindByNick( currentItem->text(), index );
        delete m_ui->listWidget->takeItem( index ); //!< @bug this not working!
        m_pCamList->removeAt( index );
    }
}
/** button new clicked */
void SettingsDialog::on_buttonNew_clicked()
{
    bool ok=false;
    QString text, address;
    text = QInputDialog::getText(this, tr("New nick name"), tr("Nick:"), QLineEdit::Normal, text, &ok );
    if ( ok )
    {
        m_ui->listWidget->addItem( text );
        m_pCamList->append( Cam_s(text, address) );
        currentItem = m_ui->listWidget->item( m_ui->listWidget->count()-1 );
    }
}
/** event url edited
 *  Action is only to activate save button.
 */
void SettingsDialog::on_url_textEdited(QString newUrl)
{
    m_ui->buttonSaveUrl->setEnabled(true);
}
/** button Save URL+update intervall clicked */
void SettingsDialog::on_buttonSaveUrl_clicked()
{
    m_ui->buttonSaveUrl->setEnabled(false);
    if(currentItem==0)return;

    Cam_s *p = (Cam_s*)FindByNick( currentItem->text() );
    if(p)
    {
        p->address = m_ui->url->text(); //url
        p->updateIntervall = m_ui->horizontalSlider->value();   //update intervall
    }

}


