/* ======================================================================
**  MainWindow.h
** ======================================================================
**
** ======================================================================
**  Copyright (c) 2007 by Artemov Nikita
** ======================================================================
*/

#ifndef _MAINWINDOW_H_
#define _MAINWINDOW_H_
#define COUNT_OF_IMAGE 11

#include <iostream>
#include <QtGui>
#include <QtCore/QStringList>
#include <QtDBus/QtDBus>
#include <QtDBus>


// ======================================================================
class MainWindow : public QMainWindow
{
    Q_OBJECT
    QDBusInterface authInterface;

private: 
    QString clientID, encoded;
    QWidget *window;
    QAction *rotateAction;
    QLabel *view, *info, *lblFile, *lblClient;
    QVBoxLayout *vbox;
    QHBoxLayout *hbox1, *hbox2, *hbox3;
    QLineEdit *editFileName, *editClientID;
    QPushButton *choiceButton, *sendButton;


public:
    void sendImage(const QString &strBase64);
    void loadFile(const QString &fileName);
    MainWindow();

protected:
    virtual void closeEvent(QCloseEvent *event);

public slots:
    void messageSlot(const QStringList &result);
    void choose();
    void send();
};

#endif  //_MAINWINDOW_H_
