/*
 * CaptchaWindow.h - main window class.
 *
 * Copyright (C) 2010 - Aleksandr A. Lomov.
 *
 * Webauth is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Webauth is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Webauth; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */


#ifndef _CAPTCHAWINDOW_H_
#define _CAPTCHAWINDOW_H_

#include <QtGui>

#include "authdbusadaptor.h"
#include "authparams.h"

class QLineEdit;


class CaptchaWindow : public QMainWindow
{
    Q_OBJECT

    public:
        CaptchaWindow(const int ID);
        virtual ~CaptchaWindow();

        void setImage(const QString &strBase64);

        void startCaptcha(const QString &strBase64, const QString clientID);

        int getWindowID();

    protected:
        virtual void closeEvent(QCloseEvent *event);


    protected slots:
        void sendCaptchaResult(const QString & captchaResult);
        void enter();

    private:
        QByteArray ba;
        QPixmap pix;
        QString clientID;

        QWidget *window;
        QLabel *view;
        QVBoxLayout *vbox;
        QLineEdit *locationEdit;
        QPushButton *button;

        AuthParams authParams;

        bool isClosedByUser;
        const int windowID;


    Q_SIGNALS:
        void captchaClosed(const int windowID);
}; 

#endif
