#include "webappview.h"

#include <QLayout>
#include <QWebPage>
#include <QWebFrame>
#include <QDesktopServices>
#include <QDir>

#include "webappnativeservices.h"
#include "qwebviewselectionsuppressor.h"

WebAppView::WebAppView(const QString& appUrl) :
        m_view(new QWebView),
        m_suppressor(new QWebViewSelectionSuppressor(m_view)),
        m_nativeServices(new WebAppNativeServices(this))
{


    // please call from javascript only
    //m_nativeServices->requestConnection();
    //connect(m_nativeServices, SIGNAL(stateChanged(QNetworkSession::State)), this, SLOT(stateChanged(QNetworkSession::State)));
    QVBoxLayout *layout = new QVBoxLayout(this);
    layout->setMargin(0);
    layout->setSpacing(0);
    layout->addWidget(m_view);

    QWebPage *page = m_view->page();
    // should be able to quit from js by window.close() now!
    connect(page, SIGNAL(windowCloseRequested()), this, SLOT(close()));
    connect(page->view(),SIGNAL(linkClicked(const QUrl&)),this,SLOT(onLinkClicked(const QUrl&)));
    page->setLinkDelegationPolicy(QWebPage::DelegateAllLinks);

    QWebFrame* frame = page->mainFrame();
    frame->addToJavaScriptWindowObject("nativeServices", m_nativeServices);



    QWebSettings *settings = page->settings();
    settings->setAttribute(QWebSettings::JavascriptEnabled, true);
    settings->setAttribute(QWebSettings::OfflineStorageDatabaseEnabled, true);
    settings->setAttribute(QWebSettings::LocalStorageEnabled , true);
    settings->setAttribute(QWebSettings::LocalContentCanAccessRemoteUrls, true);
    settings->setOfflineStorageDefaultQuota(5000000);
    settings->setOfflineWebApplicationCacheQuota(20000000);
    settings->setOfflineStoragePath(storagePath(appUrl));
    m_view->setContextMenuPolicy(Qt::NoContextMenu);
    m_view->load(QUrl(appUrl));
}

void WebAppView::onLinkClicked ( const QUrl & url )
{
    if(url.toString().contains("http://")
        || url.toString().contains("sms:")
        || url.toString().contains("tel:")
        || url.toString().contains("mail:")) QDesktopServices::openUrl(url);
}

const QString WebAppView::storagePath(const QString& path) const{
    QString p = path;
    p.remove("file:///");
    p = QDir::homePath() + "/.wa/" + p.replace(QRegExp("\\W"),QString("_"));
    return p;
}

#if 0
void WebAppView::stateChanged(QtMobility::QNetworkSession::State state)
{
    QString js = QString("window.doNetworkStateChanged(%1); null;").arg((int)state);
    qDebug() << "Running " << js;
    m_view->page()->mainFrame()->evaluateJavaScript(js);
}
#endif
