#include "webappnativeservices.h"

#include <QDBusConnection>
#include <QDBusMessage>
#include <QDebug>
#include <QNetworkInterface>

#if 0
#include <QNetworkConfigurationManager>
#include <QNetworkConfiguration>
#include <QNetworkSession>
#endif


WebAppNativeServices::WebAppNativeServices(QObject *parent) :
    QObject(parent)
{
}

// window.nativeservices.exitAppView() in javascript
void WebAppNativeServices::exitAppView()
{
    qDebug() << "Exit app view";
    QDBusConnection bus = QDBusConnection::sessionBus();
    QDBusMessage message = QDBusMessage::createSignal("/", "com.nokia.hildon_desktop", "exit_app_view");
    bus.send(message);
}



void WebAppNativeServices::requestConnection()
{
    QDBusConnection bus = QDBusConnection::sessionBus();
    QDBusMessage message = QDBusMessage::createMethodCall
              ("com.nokia.icd", "/com/nokia/icd", "com.nokia.icd", "connect");
//    message.
    QList<QVariant> args;
    args << QVariant("[ANY]") << QVariant(0);
    message.setArguments(args);
    bool r = bus.send(message);

#if 0


    QNetworkConfigurationManager manager;
    QNetworkConfiguration cfg = manager.defaultConfiguration();
    m_session = new QNetworkSession(cfg, this);
    connect(m_session, SIGNAL(stateChanged(QNetworkSession::State)), this, SIGNAL(stateChanged(QNetworkSession::State)));

    m_session->open();

#endif
}

#if 0



using namespace QtMobility;


QtMobility::QNetworkSession::State WebAppNativeServices::networkState()
{
    Q_ASSERT(m_session);
    return m_session->state();
}

#endif

bool WebAppNativeServices::isOnline()
{
    bool online = false;
    QNetworkInterface wlan = QNetworkInterface::interfaceFromName("wlan0");
    QNetworkInterface gprs = QNetworkInterface::interfaceFromName("gprs0");
    if ((wlan.isValid() && wlan.flags().testFlag(QNetworkInterface::IsUp) ||
         gprs.isValid() && gprs.flags().testFlag(QNetworkInterface::IsUp))) {
        online = true;
    }
    qDebug() << "isOnline = " << online;
    return online;
}
