#include "webappnativeservices.h"

#include <QDBusConnection>
#include <QDBusMessage>
#include <QDebug>

#include <QNetworkConfigurationManager>
#include <QNetworkConfiguration>
#include <QNetworkSession>


WebAppNativeServices::WebAppNativeServices(QObject *parent) :
    QObject(parent)
{
}

// window.nativeservices.exitAppView() in javascript
void WebAppNativeServices::exitAppView()
{
    qDebug() << "Exit app view";
    QDBusConnection bus = QDBusConnection::sessionBus();
    QDBusMessage message = QDBusMessage::createSignal("/", "com.nokia.hildon_desktop", "exit_app_view");
    bus.send(message);
}

using namespace QtMobility;

void WebAppNativeServices::requestConnection()
{

    QNetworkConfigurationManager manager;
    QNetworkConfiguration cfg = manager.defaultConfiguration();
    m_session = new QNetworkSession(cfg, this);
    connect(m_session, SIGNAL(stateChanged(QNetworkSession::State)), this, SIGNAL(stateChanged(QNetworkSession::State)));

    m_session->open();
}


QtMobility::QNetworkSession::State WebAppNativeServices::networkState()
{
    Q_ASSERT(m_session);
    return m_session->state();
}

bool WebAppNativeServices::isOnline()
{
    QNetworkConfigurationManager manager;
    return manager.isOnline();
}
