/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef __web2sms_appsettings_hpp__
#define __web2sms_appsettings_hpp__

// Local includes
#include "src/settings.h"

// Global includes
#include <QtCore/QByteArray>

// Forward declarations
class AppSettings2Private;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class AppSettings2
{
public:
  AppSettings2();
  AppSettings2(const AppSettings2& cpy);
  ~AppSettings2();

  AppSettings2& operator=(const AppSettings2& cpy);

  void setUsername(const QByteArray& userName);
  QByteArray userName() const;

  void setPassword(const QByteArray& password);
  QByteArray password() const;

  void setNumber(const QByteArray& number);
  QByteArray number() const;

  void setProvider(Providers provider);
  Providers provider() const;

  void setUseProxyScript(bool useProxyScript);
  bool useProxyScript() const;

  void setSaveMsg(bool saveMsg);
  bool saveMsg() const;

  void setOrientationEnabled(bool orientationEnabled);
  bool orientationEnabled() const;

  void setEmulator(bool emulator);
  bool emulator() const;

  void setExtraLogging(bool extraLogging);
  bool extraLogging() const;

  void setProxyUrl(const QByteArray& proxyUrl);
  QByteArray proxyUrl() const;

  void setCurlTimeout(int curlTimeout);
  int curlTimeout() const;

  /// Fill the application settings
  void fillAppSettings(AppSettings* settings);

protected:
  AppSettings2Private* d;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // __web2sms_appsettings_hpp__
