/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "accountsettingsdialog.hpp"
#include "ui_accountsettingsdialog.h"

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

AccountSettingsDialog::AccountSettingsDialog(QWidget* parent /* = 0 */)
: QDialog(parent)
, ui(new Ui_AccountSettingsDialog)
{
  ui->setupUi(this);

  // Try not to start with uppercase
  ui->usernameEdit->setInputMethodHints(Qt::ImhNoAutoUppercase);
}

//////////////////////////////////////////////////////////////////////////

AccountSettingsDialog::~AccountSettingsDialog()
{
  delete ui;
}

//////////////////////////////////////////////////////////////////////////

void AccountSettingsDialog::setUserName(const QString& userName)
{
  ui->usernameEdit->setText(userName);
}

//////////////////////////////////////////////////////////////////////////

QString AccountSettingsDialog::userName() const
{
  return ui->usernameEdit->text();
}

//////////////////////////////////////////////////////////////////////////

void AccountSettingsDialog::setPassword(const QString& password)
{
  ui->passwordEdit->setText(password);
}

//////////////////////////////////////////////////////////////////////////

QString AccountSettingsDialog::password() const
{
  return ui->passwordEdit->text();
}

//////////////////////////////////////////////////////////////////////////

QFormLayout* AccountSettingsDialog::formLayout() const
{
  return ui->formLayout;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
