/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef MESSAGETEXTFIELD_HPP
#define MESSAGETEXTFIELD_HPP

// Global includes
#include <QtGui/QPlainTextEdit>

// Forward declarations
class MessageTextFieldPrivate;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

/**
 * The MessageTextField is a text input field which checks a given codec
 * for its supporting characters before inserting the text.
 * 
 * Mainly used for GSM codec which does not support all characters. So the
 * user can't input them.
 *
 * TODO: Also check copy/paste code :)
 */
class MessageTextField : public QPlainTextEdit
{
  Q_OBJECT

public:
  MessageTextField(QWidget* parent = 0);
  ~MessageTextField();

  /// Get/Set the codec for this field (for future use)
  //void setCodec(QTextCodec* codec);
  //QTextCodec* codec() const;

protected:
  void keyPressEvent(QKeyEvent* event);
  void paintEvent(QPaintEvent* event);

private:
  MessageTextFieldPrivate* d;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // MESSAGETEXTFIELD_HPP
