/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "startwidget.hpp"
#include "ui_startwidget.h"
#include "providers/accountsmodel.hpp"

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class StartWidgetPrivate : public QObject
{
  Q_OBJECT

public:
  // Properties
  StartWidget* self;
  Ui_StartWidget ui;

  AccountsModel accountsModel;

  // Functions
  void init();

public slots:
  void onItemClicked(const QModelIndex& index);
};

//////////////////////////////////////////////////////////////////////////

void StartWidgetPrivate::init()
{
  // Setup the ui
  ui.setupUi(self);

  // Setup the list view
  ui.listView->setModel(&accountsModel);

  // Make the connections
  connect(ui.listView, SIGNAL(clicked(QModelIndex)), this, SLOT(onItemClicked(QModelIndex)));
}

//////////////////////////////////////////////////////////////////////////

void StartWidgetPrivate::onItemClicked(const QModelIndex& index)
{
  // Huh ..?
  if ( !index.isValid() )
    return;

  // Get the account alias and emit the signal
  QString alias = index.data(AccountsModel::AccountAliasRole).toString();
  if ( !alias.isEmpty() )
    emit self->accountClicked(alias);
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

StartWidget::StartWidget(QWidget* parent /* = 0 */)
: QWidget(parent)
, d(new StartWidgetPrivate)
{
  d->self = this;
  d->init();
}

//////////////////////////////////////////////////////////////////////////

StartWidget::~StartWidget()
{
  delete d;
}

//////////////////////////////////////////////////////////////////////////

void StartWidget::setAccounts(const AccountsPtr& accounts)
{
  d->accountsModel.setAccounts(accounts);
}

//////////////////////////////////////////////////////////////////////////

AccountsPtr StartWidget::accounts() const
{
  return d->accountsModel.accounts();
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#include "startwidget.moc"
