/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef __web2sms_providerinterface_hpp__
#define __web2sms_providerinterface_hpp__

// Local includes
#include "message.hpp"

// Global includes
#include <QtCore/QtPlugin>
#include <QtCore/QLocale>
#include <QtCore/QSharedPointer>
#include <QtGui/QPixmap>
#include <QtGui/QAction>

// Forward declarations
class ProviderInterface;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

enum CallbackType
{
  Callback_Sync, // Sync = Operation Done.
  Callback_Async // Async = Operation not done, asyncronous callback over signal
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class PROVIDERS_API ProviderInterface : public QObject
{
  Q_OBJECT

public:
  ProviderInterface(QObject* parent = 0);
  ~ProviderInterface();

  // Initialization functions (not called when already initialized)
  virtual bool isLoggedIn() const;
  virtual CallbackType login();  // true = done; false = need more time (signal slot connection)
  virtual CallbackType logout(); // same as above

  virtual void updateBalance();

  /// Settings loading and saving
  virtual void loadSettings(const QByteArray& data) = 0;
  virtual QByteArray saveSettings() const = 0;

  /// The supported message types by this provider
  virtual QList<MessageType> messageTypes() const;

  /// The send message function
  virtual void sendMessage(const Message& message) = 0;

  /// Show the account settings dialog for this provider
  virtual bool showAccountSettingsDialog(QWidget* parent) = 0;

signals:
  void loginReply(bool success);
  void logoutReply(bool success);
  void balanceReply(const QString& balance);

  void sendMessageReply(bool success, const Message& message);
  void error(const QString& message);
};

Q_DECLARE_INTERFACE(ProviderInterface, "org.maemo.garage.web2sms.ProviderInterface/1.0");

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // __web2sms_providerinterface_hpp__
