/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef NETWORKHELPER_HPP
#define NETWORKHELPER_HPP

// Local includes
#include "export.hpp"

// Global includes
#include <QtCore/QObject>
#include <QtNetwork/QNetworkRequest>
#include <QtNetwork/QNetworkReply>

// Forward declarations
class NetworkHelperPrivate;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class PROVIDERS_API NetworkHelper : public QObject
{
  Q_OBJECT

public:
  NetworkHelper(QObject* parent = 0);
  ~NetworkHelper();

  /// Prepare a request
  QNetworkRequest prepareRequest() const;

  /// Get/Post functions
  QNetworkReply* get(const QNetworkRequest& request, const QString& stateName);
  QNetworkReply* post(const QNetworkRequest& request, const QByteArray& data, const QString& stateName);

  /// Add or remove a listener
  void addListener(QObject* listener);
  void removeListener(QObject* listener);

private:
  NetworkHelperPrivate* d;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // NETWORKHELPER_HPP
