#ifndef QT_C_API_H
#define QT_C_API_H

struct QByteArray;
struct QString;
struct QStringList;

#ifndef QT_VERSION
struct ContactInfoList;
#endif
//struct gchar;

#ifdef __cplusplus
extern "C" {
#endif

//////////////////////////////////////////////////////////////////////////

struct QByteArray* QByteArray_new();
struct QByteArray* QByteArray_copy(const struct QByteArray* str);
void QByteArray_delete(struct QByteArray* str);

void QByteArray_setValue(struct QByteArray* str, const gchar* value);
const gchar* QByteArray_getValue(const struct QByteArray* str);

//////////////////////////////////////////////////////////////////////////

struct QString* QString_new();
struct QString* QString_copy(const struct QString* str);
void QString_delete(struct QString* str);

void QString_setValue(struct QString* str, const gchar* value);
const gchar* QString_getValue(const struct QString* str);

struct QByteArray* QString_toUtf8(const struct QString* str);

//////////////////////////////////////////////////////////////////////////

void QStringList_append(struct QStringList* list, const gchar* value);

//////////////////////////////////////////////////////////////////////////

void ContactInfoList_addContact(struct ContactInfoList* list, const gchar* name, const gchar* number, const gchar* uniqueId);

//////////////////////////////////////////////////////////////////////////

#ifdef __cplusplus
} // extern "C"
#endif

#endif // QT_C_API_H
