/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "messagetextfield.hpp"
#include "providers/qgsmcodec.h"

// Global includes
#include <QtGui/QKeyEvent>

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class MessageTextFieldPrivate
{
public:
  MessageTextFieldPrivate()
  : codec(&gsmCodec)
  {
  }

  QGsmCodec gsmCodec;
  QTextCodec* codec;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

MessageTextField::MessageTextField(QWidget* parent /* = 0 */)
: QPlainTextEdit(parent)
, d(new MessageTextFieldPrivate)
{
}

//////////////////////////////////////////////////////////////////////////

MessageTextField::~MessageTextField()
{
  delete d;
}

//////////////////////////////////////////////////////////////////////////

/*void MessageTextField::setCodec(QTextCodec* codec)
{
  if ( d->codec == codec )
    return;

  d->codec = codec;
}

//////////////////////////////////////////////////////////////////////////

QTextCodec* MessageTextField::codec() const
{
  return d->codec;
}*/

//////////////////////////////////////////////////////////////////////////

void MessageTextField::keyPressEvent(QKeyEvent* event)
{
  // Get the entered text
  QString text = event->text();
  if ( !text.isEmpty() && (text[0].isPrint() || text[0] == QLatin1Char('\n')) )
  {
    // Get the two byte code
    unsigned short twoByte = d->gsmCodec.twoByteFromUnicode( text.at(0) );

    if ( twoByte == 0x10 ) // Unsupported character
    {
      // Trash the event
      event->setAccepted(false);
      return;
    }
  }

  QPlainTextEdit::keyPressEvent(event);
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
