/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef ORIENTATIONHELPER_HPP
#define ORIENTATIONHELPER_HPP

// Global includes
#include <QtCore/QObject>

// Forward declarations
class QLayout;
class OrientationHelperPrivate;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

/**
  * OrientationHelper helps with Maemo5 screen orientations. You can set
  * a portrait and a landscape layout which will be switched
  * automatically when the orientation changed.
  *
  * The OrientationHelper must receive a setWidget() call before any setupUi()
  * is called on the widget.
  */
class OrientationHelper : public QObject
{
  Q_OBJECT

public:
  OrientationHelper(QObject* parent = 0);
  ~OrientationHelper();

  /// Get/Set the widgets for which you want to use multiple layouts
  void setWidget(QWidget* widget);
  QWidget* widget() const;

  /// Get/Set the landscape layout
  void setLandscapeLayout(QLayout* layout);
  QLayout* landscapeLayout() const;

  /// Get/Set the portrait layout
  void setPortraitLayout(QLayout* layout);
  QLayout* portraitLayout() const;

signals:
  void orientationChanged(Qt::Orientation orientation);

private:
  OrientationHelperPrivate* d;
  friend class OrientationHelperPrivate;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // ORIENTATIONHELPER_HPP
