/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef PROVIDERINFO_HPP
#define PROVIDERINFO_HPP

// Local includes
#include "export.hpp"

// Global includes
#include <QtCore/QLocale>
#include <QtCore/QMetaType>
#include <QtCore/QSharedDataPointer>
#include <QtCore/QUuid>
#include <QtGui/QIcon>

// Forward declarations
class ProviderInfoData;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

enum ProviderType
{
  Free           = 1,
  Payment        = 2,
  FreeAndPayment = Free | Payment
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

/// Simple ProviderInfo structure
struct PROVIDERS_API ProviderInfo
{
  ProviderInfo();
  ProviderInfo(const ProviderInfo& cpy);
  ProviderInfo(const QString& visibleName,
               const QString& providerId,
               const QIcon& icon,
               QLocale::Country country,
               ProviderType type = Payment);
  ~ProviderInfo();

  ProviderInfo& operator=(const ProviderInfo& other);

  void setVisibleName(const QString& visibleName);
  QString visibleName() const;

  void setProviderId(const QUuid& providerId);
  QUuid providerId() const;

  void setIcon(const QIcon& icon);
  QIcon icon() const;

  void setCountry(const QLocale::Country& country);
  QLocale::Country country() const;

  void setProviderType(const ProviderType& providerType);
  ProviderType providerType() const;

private:
  QSharedDataPointer<ProviderInfoData> data;
};

//////////////////////////////////////////////////////////////////////////

// Metatype declaration
Q_DECLARE_METATYPE(ProviderInfo);

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // PROVIDERINFO_HPP
