/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef __web2sms_contactinfo_hpp__
#define __web2sms_contactinfo_hpp__

// Local includes
#include "export.hpp"

// Global includes
#include <QtCore/QString>
#include <QtCore/QList>
#include <QtCore/QSharedData>
#include <QtCore/QSharedDataPointer>
#include <QtCore/QMetaType>

// Type definitions
typedef QList<class ContactInfo> ContactInfoList;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class ContactInfoPrivate : public QSharedData
{
public:
  ContactInfoPrivate()
  {}

  ContactInfoPrivate(const ContactInfoPrivate& other)
  : QSharedData(other)
  , name(other.name)
  , number(other.number)
  , uniqueId(other.uniqueId)
  {}

  QString name;
  QString number;
  QString uniqueId;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class PROVIDERS_API ContactInfo
{
public:
  ContactInfo();
  ContactInfo(const ContactInfo& other);
  ~ContactInfo();

  void setName(const QString& name);
  QString name() const;

  void setNumber(const QString& number);
  QString number() const;

  void setUniqueId(const QString& uniqueId);
  QString uniqueId() const;

private:
  QSharedDataPointer<ContactInfoPrivate> d;
};

Q_DECLARE_METATYPE(ContactInfo);

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // __web2sms_contactinfo_hpp__
