/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef __web2sms_accountsettingsdialog_hpp__
#define __web2sms_accountsettingsdialog_hpp__

// Local includes
#include "export.hpp"

// Global includes
#include <QtGui/QDialog>

// Forward declarations
class QFormLayout;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

/**
 * Default account settings dialog for providers
 */
class PROVIDERS_API AccountSettingsDialog : public QDialog
{
  Q_OBJECT

public:
  AccountSettingsDialog(QWidget* parent = 0);
  ~AccountSettingsDialog();

  void setUserName(const QString& userName);
  QString userName() const;

  void setPassword(const QString& password);
  QString password() const;

  /// Return the form layout
  QFormLayout* formLayout() const;

private:
  class Ui_AccountSettingsDialog *ui;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // __web2sms_accountsettingsdialog_hpp__
