﻿# -*- coding: utf-8 -*-
#
#  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
#
#  This file is part of Web2SMS.
#
#  Web2SMS is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  Web2SMS is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
#
#

from PyQt4 import QtCore, QtGui
import web2sms
import socket

gmxProviderUuid = QtCore.QUuid('4bc8b184-c7cb-47a1-92bf-fb0b9be31702')

class SMSManager:
    '''this code is mostly copy&paste from http://gmxsms.sourceforge.net/ 
       with some late-night modifications

       basicly the (gmx) adressbook support was kicked, and only needed methods are implemented'''
       
    app_ver = "1.15.04" 
    server = "app5.wr-gmbh.de"
    huffman = None #huffman.huffman()
    sms = {}
    
    def do_bootstrap(self, email, code):
        '''Fuehrt den Bootstrap aus. code ist der Freischaltcode\nGibt 0 bei einem Fehlschlag (z.B. falsches Kennwort), 1 bei Erfolg'''
        #print "Bootstrap: EMAIL %s CODE: %s" % (email, code)
        data = self.send_packet(('GET_CUSTOMER','1.10'),{'email_address': email,'password':code,'gmx':1})
        #print "data: ", data
        
        if data['rslt'] == "25":
            print "Der Server akzeptiert die Emailadresse bzw. den Freischaltcode nicht."
            return False
        if data['rslt'] != '0':
            print "Error "+data['rslt']+"."
            return False

        self.sms['freesms'] = (int(data['free_rem_month']), int(data['free_max_month']))
        self.sms['name'] = (data['first_name'], data['last_name'])
        self.sms['handy']= data['cell_phone']
        self.sms['country'] = data['home_phone_code']
        self.sms['id'] = data['customer_id']
        self.update_freesms(data)
        self.sms['confirmed'] = int(data['cell_phone_confirmed'])
        self.sms['password'] = code
        self.sms['email'] = data['email_address']
        return True
    
    def send_packet(self, p, packet_data):
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM, 0)
        s.connect((self.server,80))
        packet = self.build_packet(p, packet_data)
        if self.huffman:
            packet = self.huffman.encode(packet)
        s.send(("POST /WRServer/WRServer.dll/WR HTTP/1.0\r\n"+
            "Accept: */*\r\n"+
            "Content-Type:     text/plain\r\n"+
            "Content-Encoding: wr-cs%s\r\n"+
            "User-Agent: Mozilla/3.0 (compatible)\r\n"+
            "Host: %s\r\n"+
            "Content-Length: %d\r\n\r\n") % (
            self.huffman and ", wr-compress-v2" or '',
            self.server, len(packet)))
        s.send(packet)

        data = ''
        data = s.recv(1024)
        tmp = data.split("\r\n")
        headers = {}
        for i in tmp:
            try:
                key, value = i.split(': ', 1)
                headers[key] = value
            except: pass
        
        #modified, seemed to be buggy for small (<1024/8) responses (infinite loop)
        while 1:
            line = ""
            try:
                line = s.recv(1024)
            except socket.timeout:
                break
            if line == "": break
            data += line

        s.close()
        if self.huffman:
            data = self.huffman.decode(data)
        
        if data == 'The truth is out there':
            self.error.emit("GMX mag uns heute nicht. Der folgende Request ist wohl fehlerhaft:\n%s" % self.huffman and self.huffman.decode(packet) or packet)
            sys.exit()
        data = data[data.index('>')+1:-5]
        out = {}
        for i in data.split('\p'):
            try:
                key, value = i.split('=',1)
                out[key] = value.replace("\\>",'>').replace("\\<",'<').replace('\\\\','\\')
            except: pass
        if out['rslt'] != '0':
            if out['rslt'] == '11':
            	#TODO: make this work with GUI
                print "Ihr Kennwort stimmt nicht mehr. Starten Sie das Programm mit der Option -b erneut bzw. fuehren Sie den Bootstrap erneut aus"
                #TODO: Try to get to this point and then decide how web2sms should handle this case
                #sys.exit(0)
            print "Vielleicht ein Fehler: %s" % out
        return out

    def build_packet(self, p, data):
        (name, version) = p
        payload=''
        for key in data:
            payload += key+"="+str(data[key]).replace("\\","\\\\").replace(">","\\>").replace("<","\\<")+"\\p"
        return "<WR TYPE=\"RQST\" NAME=\""+name+"\" VER=\""+version+"\" PROGVER=\""+self.app_ver+"\">"+payload+"</WR>"        
    
    def build_receiver_table(self, receivers):
        id = 1
        rows = []
        for name in receivers:
            rows.append({'receiver_id':id, 'receiver_number':receivers[name], 'receiver_name':name})
            id += 1
        return self.build_table(rows)
        
    def build_table(self, rows, cols=None):
        table = "<TBL ROWS=\""+str(len(rows))+"\" COLS=\""+str(len(rows) > 0 and len(rows[0].keys()) or len(cols))+"\">"
        for name in (len(rows) > 0 and rows[0].keys() or cols):
            table += name + "\\;"
        for row in rows:
            for val in row.keys():
                table += str(row[val]) + "\\;"
        return table+"</TBL>"
    
    def parse_table(self, data):
        cols = data.index('COLS="')+6
        cols = int(data[cols:cols+data[cols:].index('"')])
        data = data[data.index('>')+1:-6]
        data = data.split('\;')
        out = []
        keys = []
        for i in range(0, cols):
            keys.append(data[i])
        for i in range(1, len(data)/cols):
            tmp = {}
            for j in range(0, cols):
                tmp[keys[j]] = data[i*cols+j].replace("\\>",'>').replace("\\<",'<').replace('\\\\','\\')
            out.append(tmp)
        return out
    
    def format_number(self, number):
        '''not used. maybe it isn't needed, because web2sms does this all right?!?'''
        if number[0] == '+': return number
        if number[0:len(self.sms['country'])] == self.sms['country']: return "+"+number
        if number[0] == '0': return '+'+self.sms['country']+number[1:]
        return ''
    
    def update_freesms(self, data):
        self.sms['freesms'] = (int(data['free_rem_month']), int(data['free_max_month']))
        
    def reload_freesms(self):
        data = self.send_packet(('GET_SMS_CREDITS', '1.00'), {'customer_id': self.sms['id'], 'password': self.sms['password']})
        self.update_freesms(data)
    
    def write_sms(self, recvlist, message, sender='', date=''):
        """recvlist ist ein dictionary {'John Doe': '0049...'}
        message ein iso8859-15-string"""
        #print self.sms
        if len(recvlist) == 0:
            self.error("Keine Empfaenger vorhanden")
            return
        if sender=='': sender = self.sms['handy']
        
        data = {'customer_id': self.sms['id'], 'password': self.sms['password'],
            'sms_text': message, 'receivers': self.build_receiver_table(recvlist), 
            'send_option': 'sms', 'sms_sender': sender}
        #print "Sending SMS: " , data
        
        if date!='': data['send_date'] = date
        data = self.send_packet(('SEND_SMS', '1.01'), data)
        self.update_freesms(data)
        errors = self.parse_table(data['error_codes'])
        for i in range(0, len(errors)):
            errors[i]['name'] = recvlist.keys()[int(errors[i]['receiver_id'])-1]
        
        return errors
    
    
# The provider instance
class GmxProvider(web2sms.ProviderInterface, SMSManager):
    userName = str()
    password = str()
    customer_id = str()
    sender = str()
    loggedIn = bool     #saves if
    
    def __init__(self, parent):
        web2sms.ProviderInterface.__init__(self, parent)

    def loadSettings(self, data):
        print "LOAD SETTINGS"
        stream = QtCore.QDataStream(data, QtCore.QIODevice.ReadOnly)
        self.userName = stream.readQString()
        self.password = stream.readQString()
        self.customer_id = stream.readQString()
        self.sender = stream.readQString()
        
        if self.customer_id == '':
            self.loggedIn = False
        else:
            #SMSManager data is ready set it so it can be used. Not nice, but it works... (should use the same vars and not self.sms)
            self.sms['id'] = str(self.customer_id)
            self.sms['password'] = str(self.password)
            self.sms['handy'] = str(self.sender)
            self.loggedIn = True
        #print "Customer ID %s " % self.customer_id
        
    def saveSettings(self):
        print "SAVE SETTINGS"
        data = QtCore.QByteArray()
        stream = QtCore.QDataStream(data, QtCore.QIODevice.WriteOnly)
        stream.writeQString(self.userName)
        stream.writeQString(self.password)
        stream.writeQString(self.customer_id)
        stream.writeQString(self.sender)
        return data
        
    def messageTypes(self):
        return [ web2sms.MessageType('Standard', 'standard', QtGui.QIcon(), '', 160, 160, 1) ]
                         
    def showAccountSettingsDialog(self, parent):
        dialog = web2sms.AccountSettingsDialog()
        dialog.setWindowTitle('GMX Account Options')

        dialog.setUserName(self.userName)
        dialog.setPassword(self.password)
        
        #use the password field for the api token ('Freischaltcode')
        dialog.findChild(QtGui.QLabel, QtCore.QString('label_2')).setText('Code:')
        dialog.findChild(QtGui.QLineEdit, QtCore.QString('passwordEdit')).setEchoMode(QtGui.QLineEdit.Normal)
        
        #print "cfg USER:", self.userName
        #print "cfg CODE:", self.password
        #print "cfg CID", self.customer_id

        if dialog.exec_() == QtGui.QDialog.Accepted:

            if self.userName != dialog.userName() or self.password != dialog.password():
                #some data were changed. so we are not longer logged in, and need a new bootstrap (done in self.loggin next time connection is needed
                self.loggedIn = False
                     
            self.userName = dialog.userName()
            self.password = dialog.password()

            return True
        else: 
            return False
    
    def updateBalance(self):
        if self.isLoggedIn():
            if not 'freesms' in self.sms:
                self.reload_freesms()
            freesms = "%s / %s " % self.sms['freesms']
        else:
            freesms = "Not connected"
        
        self.balanceReply.emit(freesms)

    def isLoggedIn(self):
        #print "Is logged in? ", self.customer_id
        return self.loggedIn
        
    
    def login(self):
        #print "Login -> do Bootstrap"
        if self.do_bootstrap(self.userName, self.password):
            self.customer_id = self.sms['id']
            self.sender = self.sms['handy']
            self.loggedIn = True
            #print "Logged in with cid: " , self.customer_id
        else:
            self.error.emit("Error: Login failed")
            if self.showAccountSettingsDialog(self):
                self.login()    #user saved accountsettings, try new login
        return False #asynchronous off
    
    
    def logout(self):
        #print "Logging out"
        return False    #asynchronous off
    
    
    def sendMessage(self, message):
        print 'Text: %s' % message.text().toLatin1()
        
        #print message.receivers()
        recvlist = {}
        for contact in message.receivers():
            if contact.name() not in recvlist:
                name = str(QtCore.QString(contact.name()).toLatin1())
                recvlist[name] = str(contact.number())
            else:
                self.error.emit("Duplicate contact: %s" % contact.name())
        
        #print "Receivers: %s" % recvlist
        
        #send sms an get an list of errors
        try:
            smserr = self.write_sms(recvlist, str(message.text().toLatin1()))
        except Exception, e:
            print "Error: %s" % e
            self.error.emit("Error: %s" % e)
            self.sendMessageReply.emit(False, message)
            return
            
        if len(smserr) is 0:
            self.sendMessageReply.emit(True, message)
        else:
            print "errors while sending: " , err
            self.sendMessageReply.emit(False, "Errors: %s " % err) 
            
        self.updateBalance()
        #self.sendMessageReply.emit(False, "An error occured") 
        #self.sendMessageReply.emit(True, message) # Message has been successfully sent			        

          
          
# The Plugin instance
class GmxProviderPlugin(web2sms.ProviderPlugin):
    safetyObject = QtCore.QObject() # Makes sure that the Provider exists until the Plugin dies
    
    def info(self):
        return [ web2sms.ProviderInfo('GMX Germany', gmxProviderUuid, QtGui.QIcon(), QtCore.QLocale.Germany) ]            

    def createProvider(self, uuid):   
        if uuid == gmxProviderUuid:
            return GmxProvider(self.safetyObject) # The provider must live as long as the Plugin lives
    
        return None
        
# Entry point function
def qt_plugin_instance():
    return GmxProviderPlugin() # The returned class gets owned by c++
    
