/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "settings.hpp"

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

Settings::Settings()
: d(new SettingsPrivate)
{
}

//////////////////////////////////////////////////////////////////////////

Settings::Settings(const Settings& cpy)
: d(cpy.d)
{
}

//////////////////////////////////////////////////////////////////////////

Settings::~Settings()
{
}

//////////////////////////////////////////////////////////////////////////

void Settings::load(QSettings& settings)
{
  settings.beginGroup("GlobalSettings");
  d->prefixNumbers = settings.value("prefixNumbers", d->prefixNumbers).toBool();
  d->prefix = settings.value("prefix", d->prefix).toString();
  d->notifyOnPrefix = settings.value("notifyOnPrefix", d->notifyOnPrefix).toBool();
  d->hideReceiverNumbers = settings.value("hideReceiverNumbers", d->hideReceiverNumbers).toBool();
  d->usePlatformDisplayMode = settings.value("usePlatformDisplayMode", d->usePlatformDisplayMode).toBool();
  settings.endGroup();
}

//////////////////////////////////////////////////////////////////////////

void Settings::save(QSettings& settings)
{
  settings.beginGroup("GlobalSettings");
  settings.setValue("prefixNumbers", d->prefixNumbers);
  settings.setValue("prefix", d->prefix);
  settings.setValue("notifyOnPrefix", d->notifyOnPrefix);
  settings.setValue("hideReceiverNumbers", d->hideReceiverNumbers);
  settings.setValue("usePlatformDisplayMode", d->usePlatformDisplayMode);
  settings.endGroup();
}

//////////////////////////////////////////////////////////////////////////

void Settings::setPrefixNumbers(bool prefixNumbers)
{
  d->prefixNumbers = prefixNumbers;
}

//////////////////////////////////////////////////////////////////////////

bool Settings::prefixNumbers() const
{
  return d->prefixNumbers;
}

//////////////////////////////////////////////////////////////////////////

void Settings::setPrefix(const QString& prefix)
{
  d->prefix = prefix;
}

//////////////////////////////////////////////////////////////////////////

QString Settings::prefix() const
{
  return d->prefix;
}

//////////////////////////////////////////////////////////////////////////

void Settings::setNotifyOnPrefix(bool notifyOnPrefix)
{
  d->notifyOnPrefix = notifyOnPrefix;
}

//////////////////////////////////////////////////////////////////////////

bool Settings::notifyOnPrefix() const
{
  return d->notifyOnPrefix;
}

//////////////////////////////////////////////////////////////////////////

void Settings::setHideReceiverNumbers(bool hideReceiverNumbers)
{
  d->hideReceiverNumbers = hideReceiverNumbers;
}

//////////////////////////////////////////////////////////////////////////

bool Settings::hideReceiverNumbers() const
{
  return d->hideReceiverNumbers;
}

//////////////////////////////////////////////////////////////////////////

void Settings::setUsePlatformDisplayMode(bool usePlatformDisplayMode)
{
  d->usePlatformDisplayMode = usePlatformDisplayMode;
}

//////////////////////////////////////////////////////////////////////////

bool Settings::usePlatformDisplayMode() const
{
  return d->usePlatformDisplayMode;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
