/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef MESSAGETYPEMODEL_HPP
#define MESSAGETYPEMODEL_HPP

// Local includes
#include "messagetype.hpp"

// Global includes
#include <QtCore/QAbstractListModel>

// Forward declarations
struct MessageTypeModelPrivate;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class PROVIDERS_API MessageTypeModel : public QAbstractListModel
{
  Q_OBJECT

public:
  MessageTypeModel(QObject* parent = 0);
  ~MessageTypeModel();

  enum
  {
    MessageTypeRole = Qt::UserRole + 1
  };

  /// Get/Set the message types
  void setMessageTypes(const QList<MessageType>& messageTypes);
  QList<MessageType> messageTypes() const;

  /// Get the index of a given message type
  QModelIndex indexFromMessageType(const MessageType& messageType) const;

  // QAbstractListModel overrides
  int rowCount(const QModelIndex& parent = QModelIndex()) const;
  QVariant data(const QModelIndex& index, int role = Qt::DisplayRole) const;

protected:
  MessageTypeModelPrivate* d;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // MESSAGETYPEMODEL_HPP
