TEMPLATE = app
TARGET   = web2sms
DESTDIR  = ../dist

CONFIG += console

unix {
  QT += maemo5
  CONFIG += link_pkgconfig
  PKGCONFIG += uuid
}

# Add the providers lib
LIBS += -L../dist -lproviders

# Leave MADDE out when using visual studio
unix {
  # Adjust the linker flags and add the rpath
  QMAKE_LFLAGS += -Wl,-z,origin \'-Wl,-rpath,\$\$ORIGIN\'
}

HEADERS += mainwindow.hpp \
           messagewidget.hpp \
           contactsedit.hpp \
    startwidget.hpp
SOURCES += mainwindow.cpp \
           messagewidget.cpp \
           contactsedit.cpp \
           main.cpp \
    startwidget.cpp

FORMS += messagewidget.ui \
    startwidget.ui

RESOURCES    += web2sms.qrc
TRANSLATIONS += translations/web2sms_de.ts

# Define the installation features
unix {
  PREFIX = ../debian/web2sms
  BINDIR = $$PREFIX/bin
  DATADIR =$$PREFIX/share
  
  # What are these defines for?
  DEFINES += DATADIR=\"$$DATADIR\" PKGDATADIR=\"$$PKGDATADIR\"
  
  # We want some more install steps
  INSTALLS += target desktop icon64 iconPixmaps 
  
  # Install the application
  target.path = $$PREFIX/opt/web2sms
  
  # Install the .desktop starter file
  desktop.path = $$PREFIX/usr/share/applications/hildon
  desktop.files += web2sms.desktop
  
  # Install the application icon
  icon64.path = $$PREFIX/usr/share/icons/hicolor/64x64/apps
  icon64.files += web2sms.png

  # Install the application icon at a second destination  
  iconPixmaps.path = $$PREFIX/usr/share/pixmaps
  iconPixmaps.files += web2sms.png
  
  # Setup translation helpers
  trs.path = $$PREFIX/opt/web2sms/translations
  for(translation, TRANSLATIONS) {
    qmfile = $$translation
    qmfile ~= s/\.ts/.qm/i
        
    trs.files += $$qmfile
    INSTALLS  *= trs # Add once     
  }
}
