/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef SMS77DE_HPP
#define SMS77DE_HPP

// Local includes
#include "../providerinterface.hpp"

// Forward declarations
class sms77dePrivate;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class sms77de : public ProviderInterface
{
  Q_OBJECT
  Q_INTERFACES(ProviderInterface)

public:
  sms77de(QObject* parent = 0);
  ~sms77de();

  // ProviderInterface overrides
  void loadSettings(const QByteArray& data);
  QByteArray saveSettings() const;

  bool showAccountSettingsDialog(QWidget* parent);
  QList<QAction*> actions() const;

  bool hasLoginData() const;
  bool isLoggedIn() const;

  int freeSMSCount() const;

  void login();
  void logout();

  /// SendMessage returns a unique message id for this instance
  int sendMessage(const QList<ContactInfo>& receivers, const QString& text);

private:
  sms77dePrivate* d;
  friend class sms77dePrivate;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // SMS77DE_HPP
