#
#
#  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
#
#  This file is part of Web2SMS.
#
#  Web2SMS is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  Web2SMS is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
#
#

from PyQt4 import QtCore, QtGui
import web2sms

# The provider instance
class MyPythonProvider(web2sms.ProviderInterface):
    userName = str()
    password = str()

    def __init__(self, parent):
        web2sms.ProviderInterface.__init__(self, parent)

    def loadSettings(self, data):
        stream = QtCore.QDataStream(data, QtCore.QIODevice.ReadOnly)
        stream.__rshift__(self.userName)
        stream.__rshift__(self.password)
    
    def saveSettings(self):
        data = QtCore.QByteArray()
        stream = QtCore.QDataStream(data, QtCore.QIODevice.WriteOnly)
        stream.__lshift__(self.userName)
        stream.__lshift__(self.password)
        return data
        
    def hasLoginData(self):
        return len(self.userName) > 0 and len(self.password) > 0
        
    def isLoggedIn(self):
        return False
        
    def freeSMSCount(self): # Removed in the future
        return -1
        
    def showAccountSettingsDialog(self, parent):
        dialog = QtGui.QDialog(parent)
        dialog.setWindowTitle('Python Account Options')
        
        # Add some controls here
        
        if dialog.exec_() == QtGui.QDialog.Accepted:
            print 'Dialog accepted'
            #self.userName = userNameEdit.text()
            #self.password = passwordEdit.text()    
        return True
				
    def actions(self): # Removed in the future
        return []
				
    def login(self):
        self.loginReply.emit(True)

    def logout(self):
        self.logoutReply.emit(True)
				
    def sendMessage(self, receivers, text):
        messageId = 0
        self.sendMessageReply.emit(False, messageId)
        print text
        return messageId				        

# The Plugin instance
class MyPythonProviderPlugin(web2sms.ProviderPlugin):
    safetyObject = QtCore.QObject() # Makes sure that the Provider exists until the Plugin dies
    
    def info(self):
        return [ web2sms.ProviderInfo('Visible python name', 'mypythonprovider', QtGui.QIcon(), QtCore.QLocale.Germany) ]            

    def createProvider(self, name):
        if name == 'mypythonprovider': 
            return MyPythonProvider(self.safetyObject) # The provider must live as long as the Plugin lives         
    
        return None
        
# Entry point function
def qt_plugin_instance():
    return MyPythonProviderPlugin() # The returned class gets owned by c++
    
