TEMPLATE = app
QT      += network
TARGET   = web2sms

# Leave MADDE out when using visual studio
unix {
  CONFIG += link_pkgconfig
  PKGCONFIG += libosso-abook-1.0 libosso rtcom-eventlogger glib-2.0 gtk+-2.0 \
               hildon-1              

  # Some defines for MADDE on windows
  exists(C:\MADDE) {
    DEFINES     += Q_WS_MAEMO_5
    INCLUDEPATH += C:\MADDE\0.6.14\sysroots\fremantle-arm-sysroot-2.2009-51-1-qt453\usr\include\libosso-abook-1.0 \
                   C:\MADDE\0.6.14\sysroots\fremantle-arm-sysroot-2.2009-51-1-qt453\usr\include\telepathy-1.0 \
                   C:\MADDE\0.6.14\sysroots\fremantle-arm-sysroot-2.2009-51-1-qt453\usr\include\glib-2.0 \
                   C:\MADDE\0.6.14\sysroots\fremantle-arm-sysroot-2.2009-51-1-qt453\usr\lib\glib-2.0\include \
                   C:\MADDE\0.6.14\sysroots\fremantle-arm-sysroot-2.2009-51-1-qt453\usr\include\gtk-2.0 \
                   C:\MADDE\0.6.14\sysroots\fremantle-arm-sysroot-2.2009-51-1-qt453\usr\lib\gtk-2.0\include \
                   C:\MADDE\0.6.14\sysroots\fremantle-arm-sysroot-2.2009-51-1-qt453\usr\include\dbus-1.0 \
                   C:\MADDE\0.6.14\sysroots\fremantle-arm-sysroot-2.2009-51-1-qt453\usr\include\gconf\2 \
                   C:\MADDE\0.6.14\sysroots\fremantle-arm-sysroot-2.2009-51-1-qt453\usr\include\cairo \
                   C:\MADDE\0.6.14\sysroots\fremantle-arm-sysroot-2.2009-51-1-qt453\usr\include\pango-1.0 \
                   C:\MADDE\0.6.14\sysroots\fremantle-arm-sysroot-2.2009-51-1-qt453\usr\include\hildon-1 \
                   C:\MADDE\0.6.14\sysroots\fremantle-arm-sysroot-2.2009-51-1-qt453\usr\include\atk-1.0 \
                   C:\MADDE\0.6.14\sysroots\fremantle-arm-sysroot-2.2009-51-1-qt453\usr\include\evolution-data-server-1.4 \
                   C:\MADDE\0.6.14\sysroots\fremantle-arm-sysroot-2.2009-51-1-qt453\usr\include\libxml2 \
                   C:\MADDE\0.6.14\sysroots\fremantle-arm-sysroot-2.2009-51-1-qt453\usr\lib\dbus-1.0\include \
                   C:\MADDE\0.6.14\sysroots\fremantle-arm-sysroot-2.2009-51-1-qt453\usr\include
  
    LIBS += -LC:\MADDE\0.6.14\sysroots\fremantle-arm-sysroot-2.2009-51-1-qt453\usr\lib
    LIBS += -losso-abook-1.0 -lebook-1.2 -luuid
  }
}

HEADERS += mainwindow.hpp \
           messagewidget.hpp \
           contacts.h
SOURCES += mainwindow.cpp \
           messagewidget.cpp \ 
           contacts.cpp \         
           main.cpp

FORMS += messagewidget.ui

RESOURCES    += web2sms.qrc
TRANSLATIONS += translations/web2sms_de.ts
         
# Providers
include(providers/providers.pri)
include(providers/o2_germany/o2_germany.pri)

# Only add the contacts api when not using windows
!win32 {
  HEADERS += qt_c_api.h
  SOURCES += qt_c_api.cpp \
             contacts_maemo.c
}
else:SOURCES += contacts_windows.cpp

# Define the installation features
unix {
  PREFIX = ../debian/web2sms
  BINDIR = $$PREFIX/bin
  DATADIR =$$PREFIX/share
  
  # What are these defines for?
  DEFINES += DATADIR=\"$$DATADIR\" PKGDATADIR=\"$$PKGDATADIR\"
  
  # We want some more install steps
  INSTALLS += target desktop icon64 iconPixmaps 
  
  # Install the application
  target.path = $$PREFIX/opt/web2sms
  
  # Install the .desktop starter file
  desktop.path = $$PREFIX/usr/share/applications/hildon
  desktop.files += web2sms.desktop
  
  # Install the application icon
  icon64.path = $$PREFIX/usr/share/icons/hicolor/64x64/apps
  icon64.files += web2sms.png

  # Install the application icon at a second destination  
  iconPixmaps.path = $$PREFIX/usr/share/pixmaps
  iconPixmaps.files += web2sms.png
}

