#include <gtk/gtk.h>
#include <QtCore/QString>
#include <QtCore/QStringList>

#include "qt_c_api.h"

extern "C" {

struct QByteArray* QByteArray_new()
{
  return new QByteArray;
}

struct QByteArray* QByteArray_copy(const struct QByteArray* str)
{
  return new QByteArray(*str);
}

void QByteArray_delete(struct QByteArray* str)
{
  delete str;
}

void QByteArray_setValue(struct QByteArray* str, const gchar* value)
{
  *str = QByteArray(value);
}

const gchar* QByteArray_getValue(const struct QByteArray* str)
{
  return str->constData();
}

struct QString* QString_new()
{
  return new QString();
}

struct QString* QString_copy(const struct QString* str)
{
  return new QString(*str);
}

void QString_delete(struct QString* str)
{
  delete str;
}

void QString_setValue(QString* str, const gchar* value)
{
  *str = QString::fromUtf8(value);
}

const gchar* QString_getValue(const struct QString *str)
{
  return str->toUtf8();
}


struct QByteArray* QString_toUtf8(const struct QString* str)
{
  return new QByteArray(str->toUtf8());
}

void QStringList_append(QStringList *list, const gchar *value)
{
  list->append( QString::fromUtf8(value) );
}

} // extern "C"
