/*
 * LICENSE:
 *
 *   Copyright 2009 Israel Disatnik
 *
 *   RoadMap is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License V2 as published by
 *   the Free Software Foundation.
 *
 *   RoadMap is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with RoadMap; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef  __WEB_DATE_FORMAT_H__
#define  __WEB_DATE_FORMAT_H__
//////////////////////////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////////////////////////
#include "web_date_format_defs.h"
#include <time.h>
//////////////////////////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////////////////////////
#ifdef __cplusplus
extern "C"   {
#endif   //   __cplusplue
//////////////////////////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////////////////////////
void	WDF_FormatHttpDate (
				time_t		tStamp,		// IN		-	result of time()
				char *		pDate);		// OUT	-	HTTP-Date format (must be at least WDF_DATE_SIZE + 1 long)
				
void	WDF_FormatHttpIfModifiedSince (
				time_t		tStamp,		// IN		-	result of time()
				char *		pHeader);	// OUT	-	If-Modified-Since header (must be at least WDF_MODIFIED_HEADER_SIZE + 1 long)

time_t WDF_TimeFromModifiedSince(const char *modified_since);

//////////////////////////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////////////////////////
#ifdef   __cplusplus
};
#endif   // __cplusplue
//////////////////////////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////////////////////////
#endif   // __WEB_DATE_FORMAT_H__

