/* navigate_tts.h - Navigate TTS definitions
 *
 * LICENSE:
 *
 *   Copyright 2011, Waze Ltd
 *                   Alex Agranovich   (AGA)
 *
 *   This file is part of RoadMap.
 *
 *   RoadMap is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   RoadMap is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with RoadMap; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef INCLUDE__NAVIGATE_TTS_DEFS__H
#define INCLUDE__NAVIGATE_TTS_DEFS__H

#ifdef __cplusplus
extern "C" {
#endif


#define NAV_TTS_TEXT_IN_200_METERS                   "in two hundred meters"
#define NAV_TTS_TEXT_IN_400_METERS                   "in four hundred meters"
#define NAV_TTS_TEXT_IN_500_METERS                   "in five hundred meters"
#define NAV_TTS_TEXT_IN_800_METERS                   "in eight hundred meters"
#define NAV_TTS_TEXT_IN_1_KILOMETER                  "in one kilometer"
#define NAV_TTS_TEXT_IN_1p5_KILOMETERS               "in one point five kilometers"

#define NAV_TTS_TEXT_IN_0p1_MILE                     "in zero point one mile"
#define NAV_TTS_TEXT_IN_QUARTER_OF_MILE              "in a quarter of a mile"
#define NAV_TTS_TEXT_IN_0p3_MILE                     "in zero point three mile"
#define NAV_TTS_TEXT_IN_HALF_MILE                    "in half a mile"
#define NAV_TTS_TEXT_IN_0p6_MILE                     "in zero point six miles"
#define NAV_TTS_TEXT_IN_1_MILE                       "in one mile"

#define NAV_TTS_TEXT_PREPARE_TURN_LEFT               "get ready to turn left"
#define NAV_TTS_TEXT_PREPARE_TURN_RIGHT              "get ready to turn right"
#define NAV_TTS_TEXT_PREPARE_EXIT_LEFT               "get ready to exit left"
#define NAV_TTS_TEXT_PREPARE_EXIT_RIGHT              "get ready to exit right"

#define NAV_TTS_TEXT_TURN_LEFT                       "take a left"
#define NAV_TTS_TEXT_TURN_RIGHT                      "take a right"
#define NAV_TTS_TEXT_KEEP_LEFT                       "stay to the left"
#define NAV_TTS_TEXT_KEEP_RIGHT                      "stay to the right"
#define NAV_TTS_TEXT_EXIT_LEFT                       "exit to the left"
#define NAV_TTS_TEXT_EXIT_RIGHT                      "exit to the right"
#define NAV_TTS_TEXT_APPROACHING_DESTINATION         "you have reached your destination"
#define NAV_TTS_TEXT_CONTINUE                        "continue straight"
#define NAV_TTS_TEXT_ROUNDABOUT_LEFT                 "at the roundabout, take a left"
#define NAV_TTS_TEXT_ROUNDABOUT_RIGHT                "at the roundabout, take a right"
#define NAV_TTS_TEXT_ROUNDABOUT_STRAIGHT             "at the roundabout, continue straight"
#define NAV_TTS_TEXT_ROUNDABOUT_ENTER                "at the roundabout, take the"

#define NAV_TTS_TEXT_ARRIVING_AT                  "arriving at"
#define NAV_TTS_TEXT_WITHIN                       "within"
#define NAV_TTS_TEXT_METERS                       "meters"
#define NAV_TTS_TEXT_MILES                        "miles"
#define NAV_TTS_TEXT_TAKE_THE                     "take the"
#define NAV_TTS_TEXT_EXIT                         "exit"
#define NAV_TTS_TEXT_AND_THEN                     "and then"
#define NAV_TTS_TEXT_AT                           "at"

#define NAV_TTS_TEXT_FIRST_EXIT                   "first exit"
#define NAV_TTS_TEXT_SECOND_EXIT                  "second exit"
#define NAV_TTS_TEXT_THIRD_EXIT                   "third exit"
#define NAV_TTS_TEXT_FOURTH_EXIT                  "fourth exit"
#define NAV_TTS_TEXT_FIFTH_EXIT                   "fifth exit"
#define NAV_TTS_TEXT_SIXTH_EXIT                   "sixth exit"
#define NAV_TTS_TEXT_SEVENTH_EXIT                 "seventh exit"

#define NAV_TTS_TEXT_SOUTH                        "south"
#define NAV_TTS_TEXT_NORTH                        "north"
#define NAV_TTS_TEXT_WEST                         "west"
#define NAV_TTS_TEXT_EAST                         "east"
#define NAV_TTS_TEXT_AVENUE                       "avenue"
#define NAV_TTS_TEXT_ROAD                         "road"
#define NAV_TTS_TEXT_LANE                         "lane"
#define NAV_TTS_TEXT_STREET                       "street"

#endif // INCLUDE__NAVIGATE_TTS_DEFS__H
