#ifndef WALLPAEPER_H
#define WALLPAEPER_H

#include "wpnew.h"
#include "ui_wpnew.h"
#include "wpmanager.h"
#include "ui_wpmanager.h"
#include "aboutdialog.h"
#include "ui_aboutdialog.h"

#include <QMainWindow>
#include <QDialog>

namespace Ui {
    class wallPaeper;
}

class wallPaeper : public QMainWindow
{
    Q_OBJECT

public:
    explicit wallPaeper(QWidget *parent = 0);
    ~wallPaeper();

private:
    Ui::wallPaeper *ui;

    void setupWPMenuBar();
    // The menu and its actions
    QMenu* wpMenu;
    QAction* wpMenuActionAbout;
    // The About dialog with its contents
    bool abtDialogExists;
    aboutDialog* abtDialog;

    wpNew* newWin;
    wpManager* manWin;
    bool openManWin;
    bool openNewWin;

public slots:
    void createAbtDialog();
    void newBtnClicked();
    void manBtnClicked();
    void openWinTrue();
};

#endif // WALLPAEPER_H
